/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OSI.sMatEntry;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchMatEntry;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TarpModel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.helper.OsiHelper;
import cerent.cms.ui.shelf.AbstractShelfTablePane;
import cerent.cms.ui.shelf.MatAddDialog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;

public class OsiTarpAdjacencyPane
extends AbstractShelfTablePane
implements ActionListener {
    private final int MAT_IDX = 0;
    private final int NSAP_IDX = 1;
    protected TarpModel tarpModel;
    private JButton removeB;
    private JButton addB;
    private static final SDebug db = new SDebug("OsiTarpAdjacencyPane");
    static /* synthetic */ Class class$cerent$cms$idl$OSI$sMatEntry;

    public OsiTarpAdjacencyPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.tarpModel = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getTarpModel();
    }

    private JPanel getButtonBar() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel3.add(new CSHelpButton(CSHelpConst.OsiTarpMATPane));
        this.addB = new JButton("Add...");
        this.removeB = new JButton("Remove...");
        jPanel2.add(this.addB);
        jPanel2.add(this.removeB);
        this.addB.addActionListener(this);
        this.removeB.addActionListener(this);
        WindowHelper.setEnabled((JComponent)this.addB, (boolean)this.isUserAuthorized());
        WindowHelper.setEnabled((JComponent)this.removeB, (boolean)false);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    protected void initModels() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new LevelColumnRenderer(), new NsapAddrColumnRenderer()};
        MatRowSource matRowSource = new MatRowSource();
        this.model = new SortableRowTableModel((RowDataSource)matRowSource, columnRendererArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateTableData() {
        ArrayList arrayList = this.tableData;
        synchronized (arrayList) {
            this.tableData = new ArrayList();
            sMatEntry[] sMatEntryArray = this.tarpModel.getTarpAdjacencyTable();
            for (int i = 0; i < sMatEntryArray.length; ++i) {
                this.tableData.add(sMatEntryArray[i]);
            }
        }
    }

    public void repopulateTable() {
        super.repopulateTable();
        int n = this.table.getSelectedRow();
        if (n < 0 || n > this.model.getRowCount()) {
            this.clearTableSelection();
            if (this.removeB != null) {
                WindowHelper.setEnabled((JComponent)this.removeB, (boolean)false);
            }
        }
    }

    protected void registerWithModels() {
        this.getObservableManager().addObservable((Observable)((Object)this.tarpModel));
    }

    protected void localInit() {
        this.setLayout(new BorderLayout());
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.add(this.getButtonBar(), "South");
        this.setDataSourceControl();
        ListSelectionModel listSelectionModel = this.getTable().getSelectionModel();
        listSelectionModel.setSelectionMode(2);
    }

    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.removeB != null) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            WindowHelper.setEnabled((JComponent)this.removeB, (!listSelectionModel.isSelectionEmpty() && this.isUserAuthorized() ? 1 : 0) != 0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        Object var3_3 = null;
        if (object.equals(this.removeB)) {
            int n;
            int[] nArray = this.table.getSelectedRows();
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("Really delete selected MAT " + PluralisationUtil.s("entry", nArray.length) + "?"), (String)"Delete MAT Entry")) {
                return;
            }
            sMatEntry[] sMatEntryArray = new sMatEntry[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] >= 0 && nArray[n] < this.model.getRowCount()) {
                    sMatEntryArray[n] = (sMatEntry)this.model.getValueAt(nArray[n], 0);
                    continue;
                }
                db.severe("Selected entry does not exist, index: " + nArray[n]);
                sMatEntryArray[n] = null;
            }
            for (n = 0; n < sMatEntryArray.length; ++n) {
                if (sMatEntryArray[n] == null) continue;
                try {
                    this.tarpModel.remMatEntry(sMatEntryArray[n].level.value(), sMatEntryArray[n].nsap);
                    continue;
                }
                catch (NoSuchMatEntry noSuchMatEntry) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_SUCH_MAT_ENTRY);
                    continue;
                }
                catch (InternalCommError internalCommError) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSI_OPERATION_FAILURE);
                    continue;
                }
                catch (Exception exception) {
                    ErrorMsg.displayError((Component)((Object)this), EMC.EID_CANT_ADD_DEL_MAT_ENTRY_PARAM_2, "remove", exception.getMessage());
                }
            }
        } else if (object.equals(this.addB)) {
            MatAddDialog matAddDialog = MatAddDialog.instance(this);
            matAddDialog.show();
            matAddDialog.dispose();
        }
    }

    public void destroy() {
        db.info("destroy");
        this.tarpModel = null;
        super.destroy();
    }

    class NsapAddrColumnRenderer
    extends BaseColumnRenderer {
        NsapAddrColumnRenderer() {
        }

        public String getName() {
            return "NSAP";
        }

        public int getWidth() {
            return 450;
        }
    }

    class LevelColumnRenderer
    extends BaseColumnRenderer {
        LevelColumnRenderer() {
        }

        public String getName() {
            return "Level";
        }

        public int getWidth() {
            return 50;
        }
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        protected BaseColumnRenderer() {
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        protected String getStringValue(sMatEntry sMatEntry2, int n) {
            String string = "???";
            switch (n) {
                case 0: {
                    Integer n2 = new Integer(sMatEntry2.level.value() + 1);
                    string = n2.toString();
                    break;
                }
                case 1: {
                    string = OsiHelper.getNsapString((byte[])sMatEntry2.nsap);
                }
            }
            return string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            sMatEntry sMatEntry2 = (sMatEntry)jTable.getValueAt(n, 0);
            String string = this.getStringValue(sMatEntry2, n2);
            JLabel jLabel = new JLabel(string);
            if (n2 == 1) {
                jLabel.setFont(OsiHelper.FIXED_WIDTH_FONT);
            }
            jLabel.setOpaque(true);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(jTable.getSelectionForeground());
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(jTable.getForeground());
            }
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = this.getStringValue((sMatEntry)object, n);
            String string2 = this.getStringValue((sMatEntry)object2, n);
            return string.compareTo(string2);
        }
    }

    class MatRowSource
    extends AbstractRowDataSource {
        MatRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            ArrayList arrayList = OsiTarpAdjacencyPane.this.tableData;
            synchronized (arrayList) {
                var2_2 = OsiTarpAdjacencyPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            ArrayList arrayList = OsiTarpAdjacencyPane.this.tableData;
            synchronized (arrayList) {
                n = OsiTarpAdjacencyPane.this.tableData.size();
            }
            return n;
        }

        public Collection getAllObjects() {
            return OsiTarpAdjacencyPane.this.tableData;
        }

        public Class getRowObjectClass() {
            return class$cerent$cms$idl$OSI$sMatEntry == null ? (class$cerent$cms$idl$OSI$sMatEntry = OsiTarpAdjacencyPane.class$("cerent.cms.idl.OSI.sMatEntry")) : class$cerent$cms$idl$OSI$sMatEntry;
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        boolean initedOM = false;

        private void initObservableManager() {
            this.getObservableManager().reset();
            OsiTarpAdjacencyPane.this.registerWithModels();
            this.getObservableManager().setActive(true);
            this.initedOM = true;
            if (db.on()) {
                db.println("initObservabledManager() done");
            }
        }

        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            if (!this.initedOM) {
                this.initObservableManager();
            } else if (db.on()) {
                db.println("did not call initObservableManager()");
            }
            OsiTarpAdjacencyPane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)OsiTarpAdjacencyPane.this), true);
            }
            return this.dscObservableManager;
        }
    }
}

