/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OSI.sTarpRoute;
import cerent.cms.model.IOsiConstants;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchTdcEntry;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TarpModel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.helper.OsiHelper;
import cerent.cms.ui.shelf.AbstractShelfTablePane;
import cerent.cms.ui.shelf.TdcCreationDialog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;

public class OsiTarpDataCachePane
extends AbstractShelfTablePane
implements ActionListener,
IOsiConstants {
    final int TID_IDX = 0;
    final int NSAP_IDX = 1;
    final int TYPE_IDX = 2;
    protected TarpModel tarpModel;
    private JButton flushB;
    private JButton addB;
    private JButton remB;
    private JButton refreshB;
    private JLabel refreshLB;
    boolean isProvision;
    private Thread _updater = null;
    private boolean _needsUpdate = false;
    boolean blockUpdate = false;
    boolean showPage = false;
    private InnerDsc _dsc;
    static final SDebug db = new SDebug("OsiTarpDataCachePane");
    static /* synthetic */ Class class$cerent$cms$idl$OSI$sTarpRoute;

    public OsiTarpDataCachePane(String string, TabbedView tabbedView, boolean bl) {
        super(string, tabbedView);
        this.isProvision = bl;
        if (bl) {
            this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        } else {
            this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        }
        this.tarpModel = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getTarpModel();
    }

    protected void localInit() {
        this.setLayout(new BorderLayout());
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.add(this.getButtonBar(), "South");
        this._dsc = new InnerDsc();
        this.setDataSourceControl(this._dsc);
        ListSelectionModel listSelectionModel = this.getTable().getSelectionModel();
        listSelectionModel.setSelectionMode(2);
    }

    private JPanel getButtonBar() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        String string = this.isProvision ? "Add Static Entry..." : "TID to NSAP...";
        this.addB = new JButton(string);
        jPanel2.add(this.addB);
        this.addB.addActionListener(this);
        WindowHelper.setEnabled((JComponent)this.addB, (boolean)this.isUserAuthorized());
        if (this.isProvision) {
            jPanel3.add(new CSHelpButton(CSHelpConst.OsiTarpTDCPane));
            this.remB = new JButton("Delete Selected Entry...");
            jPanel2.add(this.remB);
            this.remB.addActionListener(this);
            WindowHelper.setEnabled((JComponent)this.remB, (boolean)false);
        } else {
            jPanel3.add(new CSHelpButton(CSHelpConst.SmpOsiTDCPane));
            this.flushB = new JButton("Flush Dynamic Entries");
            jPanel2.add(this.flushB);
            this.flushB.addActionListener(this);
            WindowHelper.setEnabled((JComponent)this.flushB, (boolean)this.isUserAuthorized());
            this.refreshB = new JButton("Refresh");
            jPanel2.add(this.refreshB);
            this.refreshLB = new JLabel("");
            jPanel2.add(this.refreshLB);
            this.refreshB.addActionListener(this);
            WindowHelper.setEnabled((JComponent)this.refreshB, (boolean)true);
        }
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    protected void initModels() {
        int n = this.isProvision ? 2 : 3;
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[n];
        columnRendererArray[0] = new TidColumnRenderer();
        columnRendererArray[1] = new NsapAddrColumnRenderer();
        if (!this.isProvision) {
            columnRendererArray[2] = new TypeColumnRenderer();
        }
        TdcRowSource tdcRowSource = new TdcRowSource();
        this.model = new SortableRowTableModel((RowDataSource)tdcRowSource, columnRendererArray);
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        this.showPage = true;
        this.registerWithModels();
        this._dsc.refreshFromModel();
    }

    public void leavingPage() throws Exception {
        this.showPage = false;
        this.deregisterWithModels();
        super.leavingPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateTableData() {
        if (this.blockUpdate || !this.showPage) {
            return;
        }
        sTarpRoute[] sTarpRouteArray = this.tarpModel.getTarpDataCache();
        ArrayList arrayList = this.tableData;
        synchronized (arrayList) {
            this.tableData.clear();
            for (int i = 0; i < sTarpRouteArray.length; ++i) {
                if (this.isProvision && sTarpRouteArray[i].dynamic) continue;
                this.tableData.add(sTarpRouteArray[i]);
            }
        }
        ((SortableRowTableModel)((Object)this.model)).dataSourceChanged();
        if (this.refreshLB != null) {
            this.refreshLB.setText("Refreshed: " + OsiTarpDataCachePane.getFormattedDateTime(new Date()));
        }
    }

    private synchronized boolean needsUpdate() {
        if (this._needsUpdate) {
            this._needsUpdate = false;
            return true;
        }
        return false;
    }

    public void repopulateTable() {
        if (this.nodeModel != null && this.nodeModel.isInited() && this.nodeModel.getConnectionState()) {
            this._needsUpdate = true;
            if (this._updater == null) {
                this._updater = new Thread(new Runnable(){

                    public void run() {
                        OsiTarpDataCachePane.this.uiToolkit.setSBText("Loading TDC entries...");
                        while (OsiTarpDataCachePane.this.needsUpdate()) {
                            OsiTarpDataCachePane.this.populateTableData();
                        }
                        OsiTarpDataCachePane.this._updater = null;
                        OsiTarpDataCachePane.this.uiToolkit.setSBText("");
                    }
                });
                this._updater.start();
            }
        }
    }

    protected void registerWithModels() {
        this.getObservableManager().reset();
        this.getObservableManager().addObservable((Observable)((Object)this.tarpModel));
        this.getObservableManager().setActive(true);
    }

    protected void deregisterWithModels() {
        this.getObservableManager().removeObservable((Observable)((Object)this.tarpModel));
        this.getObservableManager().setActive(false);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.remB != null) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            WindowHelper.setEnabled((JComponent)this.remB, (!listSelectionModel.isSelectionEmpty() && this.isUserAuthorized() ? 1 : 0) != 0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.flushB)) {
            try {
                this.tarpModel.flushTdc();
                this.repopulateTable();
            }
            catch (InternalCommError internalCommError) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CANT_FLUSH_TDC);
            }
        } else if (object.equals(this.addB)) {
            TdcCreationDialog tdcCreationDialog = TdcCreationDialog.instance(this);
            tdcCreationDialog.show();
            tdcCreationDialog.dispose();
        } else if (object.equals(this.refreshB)) {
            this.repopulateTable();
        } else if (object.equals(this.remB)) {
            int n;
            int[] nArray = this.table.getSelectedRows();
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("Really delete selected TDC " + PluralisationUtil.s("entry", nArray.length) + "?"), (String)"Delete TDC Entry")) {
                return;
            }
            sTarpRoute[] sTarpRouteArray = new sTarpRoute[nArray.length];
            this.blockUpdate = true;
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] >= 0 && nArray[n] < this.model.getRowCount()) {
                    sTarpRouteArray[n] = (sTarpRoute)this.model.getValueAt(nArray[n], 0);
                    continue;
                }
                db.severe("Selected entry does not exist, index: " + nArray[n]);
                sTarpRouteArray[n] = null;
            }
            for (n = 0; n < sTarpRouteArray.length; ++n) {
                if (sTarpRouteArray[n] == null) continue;
                try {
                    this.tarpModel.remTdcEntry(sTarpRouteArray[n].tid);
                    continue;
                }
                catch (NoSuchTdcEntry noSuchTdcEntry) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_SUCH_TDC_ENTRY_PARAM_1, (Object)sTarpRouteArray[n].tid);
                    continue;
                }
                catch (InternalCommError internalCommError) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSI_OPERATION_FAILURE);
                    continue;
                }
                catch (Exception exception) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_UNABLE_TO_REM_TDC_ENTRY_PARAM_1, (Object)sTarpRouteArray[n].tid);
                }
            }
            this.blockUpdate = false;
        }
    }

    public void destroy() {
        db.info("destroy");
        this.tarpModel = null;
        super.destroy();
    }

    class TypeColumnRenderer
    extends BaseColumnRenderer {
        TypeColumnRenderer() {
        }

        public String getName() {
            return "Type";
        }

        public int getWidth() {
            return 75;
        }
    }

    class NsapAddrColumnRenderer
    extends BaseColumnRenderer {
        NsapAddrColumnRenderer() {
        }

        public String getName() {
            return "NSAP";
        }

        public int getWidth() {
            return 400;
        }
    }

    class TidColumnRenderer
    extends BaseColumnRenderer {
        TidColumnRenderer() {
        }

        public String getName() {
            return "TID";
        }

        public int getWidth() {
            return 150;
        }
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        protected BaseColumnRenderer() {
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        protected String getStringValue(sTarpRoute sTarpRoute2, int n) {
            String string = "???";
            switch (n) {
                case 0: {
                    string = sTarpRoute2.tid;
                    break;
                }
                case 1: {
                    string = OsiHelper.getNsapString((byte[])sTarpRoute2.nsap);
                    break;
                }
                case 2: {
                    string = sTarpRoute2.dynamic ? "Dynamic" : "Static";
                    break;
                }
                default: {
                    db.println("ERROR: getStringValue has no case for column " + n);
                }
            }
            return string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            sTarpRoute sTarpRoute2 = (sTarpRoute)jTable.getValueAt(n, 0);
            String string = this.getStringValue(sTarpRoute2, n2);
            JLabel jLabel = new JLabel(string);
            if (n2 == 1) {
                jLabel.setFont(OsiHelper.FIXED_WIDTH_FONT);
            }
            jLabel.setOpaque(true);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(jTable.getSelectionForeground());
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(jTable.getForeground());
            }
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = this.getStringValue((sTarpRoute)object, n);
            String string2 = this.getStringValue((sTarpRoute)object2, n);
            return string.compareTo(string2);
        }
    }

    class TdcRowSource
    extends AbstractRowDataSource {
        TdcRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            ArrayList arrayList = OsiTarpDataCachePane.this.tableData;
            synchronized (arrayList) {
                var2_2 = OsiTarpDataCachePane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            ArrayList arrayList = OsiTarpDataCachePane.this.tableData;
            synchronized (arrayList) {
                n = OsiTarpDataCachePane.this.tableData.size();
            }
            return n;
        }

        public Collection getAllObjects() {
            return OsiTarpDataCachePane.this.tableData;
        }

        public Class getRowObjectClass() {
            return class$cerent$cms$idl$OSI$sTarpRoute == null ? (class$cerent$cms$idl$OSI$sTarpRoute = OsiTarpDataCachePane.class$("cerent.cms.idl.OSI.sTarpRoute")) : class$cerent$cms$idl$OSI$sTarpRoute;
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            OsiTarpDataCachePane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)OsiTarpDataCachePane.this), true);
            }
            return this.dscObservableManager;
        }
    }
}

