/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IDccOspfArea;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOspfAreaRange;
import cerent.cms.model.OspfAreaRange;
import cerent.cms.model.OspfLanConfig;
import cerent.cms.model.OspfLanConfigModel;
import cerent.cms.model.OspfVLink;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractProvPane;
import cerent.cms.ui.LeavePageException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.gui.SpinPropertyEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OspfAreaRangeAttributesPane
extends AbstractProvPane
implements ActionListener,
DocumentListener,
PropertyChangeListener {
    protected INodeModel nodeModel;
    protected IOspfAreaRange myAreaRange = new OspfAreaRange();
    OspfLanConfigModel ospfLanConfigModel;
    protected JTextField addressTF;
    protected JComboBox rangeAreaCB;
    protected JCheckBox advertiseCB;
    protected SpinPropertyEditor maskEdit;
    JLabel rangeAddress;
    JLabel rangeArea;
    JLabel maskLength;
    JLabel maskProps;
    JLabel advertise;
    private static final SDebug db = new SDebug("OspfAreaRangeAttributesPane");

    public void setAreaRange(IOspfAreaRange iOspfAreaRange) {
        this.myAreaRange = iOspfAreaRange;
        this.refresh();
    }

    public IOspfAreaRange getAreaRange() {
        return this.myAreaRange;
    }

    protected OspfAreaRangeAttributesPane(String string, INodeModel iNodeModel) {
        super(string, (IModel)iNodeModel, null);
        this.setNodeModel(iNodeModel);
        if (db.on()) {
            db.println("<init>: start");
        }
        this.add(this.createAttributesPanel(), "Center");
        this.setNodeModel(iNodeModel);
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    public boolean hasSubTabs() {
        return true;
    }

    public void destroy() {
        this.nodeModel = null;
        this.ospfLanConfigModel.deleteObserver((Observer)((Object)this));
        super.destroy();
    }

    protected void repopulateRangeAreas() {
        if (db.on()) {
            db.println("Repopulating the range area combobox");
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (this.nodeModel != null && this.rangeAreaCB != null && this.ospfLanConfigModel != null) {
            Object object;
            Object object2;
            OspfLanConfig ospfLanConfig = this.ospfLanConfigModel.getLanOspfConf();
            boolean bl = ospfLanConfig.getIfAdminStat();
            if (bl) {
                object2 = ospfLanConfig.getAreaId();
                hashSet.add(InetUtil.makeDottedString((IIpAddr)object2));
            }
            if ((object2 = (OspfVLink)this.ospfLanConfigModel.getOspfVLink()) != null && !((OspfVLink)object2).hasEmptyNeighbor()) {
                hashSet.add("0.0.0.0");
            }
            IDccOspfArea[] iDccOspfAreaArray = this.ospfLanConfigModel.getDccOspfAreaIdArray();
            for (int i = 0; i < iDccOspfAreaArray.length; ++i) {
                object = iDccOspfAreaArray[i];
                IIpAddr iIpAddr = object.getAreaId();
                hashSet.add(InetUtil.makeDottedString(iIpAddr));
            }
            this.rangeAreaCB.removeAllItems();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                this.rangeAreaCB.addItem(object);
            }
        } else {
            if (this.nodeModel == null) {
                db.println("Repopulate: NodeModel null.");
            }
            if (this.rangeAreaCB == null) {
                db.println("Repopulate: CB is null.");
            }
            if (this.ospfLanConfigModel == null) {
                db.println("Repopulate: ospf lan config model is null.");
            }
        }
    }

    protected void customInit() {
        this.rangeAddress = new JLabel("Range Address: ", 4);
        this.rangeArea = new JLabel("Range Area ID: ", 4);
        this.maskLength = new JLabel("?????? ", 4);
        this.maskProps = new JLabel("Mask Length: ", 4);
        this.advertise = new JLabel("Advertise: ", 4);
        String string = "0.0.0.0";
        try {
            OspfLanConfigModel ospfLanConfigModel;
            if (this.nodeModel != null && (ospfLanConfigModel = (OspfLanConfigModel)this.nodeModel.getOspfLanConfigModel()) != null) {
                IDccOspfArea[] iDccOspfAreaArray = ospfLanConfigModel.getDccOspfAreaIdArray();
                if (iDccOspfAreaArray != null && iDccOspfAreaArray.length > 0) {
                    IDccOspfArea iDccOspfArea = iDccOspfAreaArray[0];
                    IIpAddr iIpAddr = iDccOspfArea.getAreaId();
                    string = InetUtil.makeDottedString(iIpAddr);
                } else if (db.on()) {
                    db.println("The DCC Ospf area array was null or empty.");
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        this.addressTF = new JTextField(string);
        this.addressTF.setPreferredSize(new Dimension(105, 21));
        this.rangeAreaCB = new JComboBox();
        this.repopulateRangeAreas();
        this.advertiseCB = new JCheckBox();
        this.maskEdit = new SpinPropertyEditor("", 1, 8, 32);
    }

    protected JPanel buildAttributesPanel() {
        this.customInit();
        this.rangeAddress.setBorder(BorderFactory.createLineBorder(Color.red, 3));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3));
        jPanel.add(this.rangeAddress);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        this.addressTF.setPreferredSize(new Dimension(105, 21));
        jPanel2.add(this.addressTF);
        jPanel.add(jPanel2);
        this.rangeArea.setBorder(BorderFactory.createLineBorder(Color.red, 3));
        jPanel.add(this.rangeArea);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        jPanel3.add(this.rangeAreaCB);
        jPanel.add(jPanel3);
        return jPanel;
    }

    protected JPanel createAttributesPanel() {
        this.customInit();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        this.rangeAddress.setSize(100, 21);
        this.rangeAddress.setLocation(0, 0);
        this.addressTF.setSize(105, 21);
        this.addressTF.setLocation(110, 0);
        jPanel.add(this.rangeAddress);
        jPanel.add(this.addressTF);
        this.rangeArea.setSize(100, 21);
        this.rangeArea.setLocation(0, 30);
        this.rangeAreaCB.setSize(105, 21);
        this.rangeAreaCB.setLocation(110, 30);
        jPanel.add(this.rangeArea);
        jPanel.add(this.rangeAreaCB);
        this.maskProps.setSize(100, 21);
        this.maskProps.setLocation(0, 60);
        this.maskEdit.setSize(60, 21);
        this.maskEdit.setLocation(110, 60);
        this.maskLength.setSize(100, 21);
        this.maskLength.setLocation(170, 60);
        this.maskLength.setAlignmentX(0.0f);
        jPanel.add(this.maskProps);
        jPanel.add(this.maskEdit);
        jPanel.add(this.maskLength);
        this.advertise.setSize(100, 21);
        this.advertiseCB.setSize(105, 21);
        this.advertise.setLocation(0, 90);
        this.advertiseCB.setLocation(110, 90);
        jPanel.add(this.advertise);
        jPanel.add(this.advertiseCB);
        this.addressTF.getDocument().addDocumentListener(this);
        this.advertiseCB.addActionListener(this);
        this.maskEdit.addPropertyChangeListener(this);
        return jPanel;
    }

    public void setNodeModel(INodeModel iNodeModel) {
        this.nodeModel = iNodeModel;
        boolean bl = this.isUserAuthorized((IModel)this.nodeModel);
        if (iNodeModel != null) {
            this.ospfLanConfigModel = (OspfLanConfigModel)this.nodeModel.getOspfLanConfigModel();
            this.ospfLanConfigModel.addObserver((Observer)((Object)this));
        }
    }

    public boolean onValidate() {
        try {
            this.validateFields();
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_PROV_PANE_VALIDATION_PARAM_1, (Object)exception.getMessage());
            return false;
        }
        return true;
    }

    protected void validateFields() throws Exception {
        try {
            this.myAreaRange.setRangeAddress(InetUtil.makeIpAddr(this.addressTF.getText()));
        }
        catch (Exception exception) {
            throw new Exception("Improper Range Address");
        }
        try {
            IIpAddr iIpAddr = InetUtil.makeIpAddr((String)this.rangeAreaCB.getSelectedItem());
            this.myAreaRange.setRangeAreaId(iIpAddr);
        }
        catch (Exception exception) {
            throw new Exception("Improper Area Range Address");
        }
        try {
            int n = Integer.parseInt((String)this.maskEdit.getValue());
            this.myAreaRange.setMaskLength((short)n);
        }
        catch (Exception exception) {
            throw new Exception("Improper Mask Length");
        }
        this.myAreaRange.setAdvertise(this.advertiseCB.isSelected());
    }

    public void refreshFromModel() throws Exception {
        String string = InetUtil.makeDottedString(this.myAreaRange.getRangeAddress());
        String string2 = InetUtil.makeDottedString(this.myAreaRange.getRangeAreaId());
        short s = this.myAreaRange.getMaskLength();
        boolean bl = this.myAreaRange.getAdvertise();
        this.addressTF.setText(string);
        this.repopulateRangeAreas();
        for (int i = 0; i < this.rangeAreaCB.getItemCount(); ++i) {
            String string3 = (String)this.rangeAreaCB.getItemAt(i);
            if (!string2.equals(string3)) continue;
            this.rangeAreaCB.setSelectedItem(string3);
            break;
        }
        this.advertiseCB.setSelected(bl);
        this.maskEdit.setValue(String.valueOf(s));
        this.updateMaskLabel();
        super.refreshFromModel();
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof OspfLanConfigModel) {
            this.repopulateRangeAreas();
        } else {
            super.update(observable, object);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
    }

    public void removeUpdate(DocumentEvent documentEvent) {
    }

    public Dimension getPreferredSize() {
        return new Dimension(250, 90);
    }

    protected AbstractLeavePageException createLeavePageException(String string) {
        if (db.on()) {
            db.println("createLeavePageException");
        }
        return new LeavePageException(string);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("OspfAreaRangeAttributesPane Unit Test");
        jFrame.setSize(300, 200);
        jFrame.getContentPane().add((Component)((Object)new OspfAreaRangeAttributesPane("", null)));
        jFrame.setVisible(true);
    }

    protected void updateMaskLabel() {
        try {
            int n = Integer.parseInt((String)this.maskEdit.getValue());
            int n2 = InetUtil.makeNetMask(n);
            this.maskLength.setText(InetUtil.makeDottedString(n2));
        }
        catch (NumberFormatException numberFormatException) {
            db.finer("NumberFormatException in updateMaskLabel() " + numberFormatException);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object instanceof SpinPropertyEditor) {
            this.updateMaskLabel();
        }
    }
}

