/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IModel;
import cerent.cms.model.InvalidAreaId;
import cerent.cms.model.InvalidMask;
import cerent.cms.model.InvalidOspfRangeAddress;
import cerent.cms.model.MaxOspfAreaRanges;
import cerent.cms.ui.Pane;
import cerent.cms.ui.shelf.OspfAreaRangeCreatePane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OspfAreaRangeCreateDialog
extends UDialog
implements ActionListener {
    public static final String TITLE = "Create Area Range";
    private JButton okButton;
    private JButton cancelButton;
    OspfAreaRangeCreatePane attributesPane;
    static Object model;

    public static OspfAreaRangeCreateDialog instance(Pane pane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        model = pane.getUiModel();
        OspfAreaRangeCreateDialog ospfAreaRangeCreateDialog = new OspfAreaRangeCreateDialog(frame, model);
        ospfAreaRangeCreateDialog.setSize(300, 200);
        return ospfAreaRangeCreateDialog;
    }

    private OspfAreaRangeCreateDialog(Frame frame, Object object) {
        super(frame, TITLE, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        jPanel.add((Component)this.createAttributesPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        this.attributesPane.setNodeModel(((IModel)object).getNodeModel());
    }

    public void dispose() {
        if (this.attributesPane != null) {
            this.attributesPane.destroy();
            this.attributesPane = null;
        }
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = "Error creating Area Range entry";
        if (object == this.okButton) {
            try {
                if (this.attributesPane.onValidate()) {
                    this.apply();
                    this.dispose();
                }
            }
            catch (MaxOspfAreaRanges maxOspfAreaRanges) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSPF_MAX_AREA_RANGES);
            }
            catch (InvalidAreaId invalidAreaId) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSPF_INVALID_AREA_ID);
            }
            catch (InvalidMask invalidMask) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSPF_INVALID_MASK);
            }
            catch (InvalidOspfRangeAddress invalidOspfRangeAddress) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSPF_INVALID_RANGE_ADDR);
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSPF_AREA_ERROR_PARAM_1, (Object)exception.getMessage());
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected void apply() throws Exception {
        this.attributesPane.setDirty();
        this.attributesPane.apply();
    }

    private JPanel createAttributesPanel() {
        this.attributesPane = new OspfAreaRangeCreatePane(((IModel)model).getNodeModel());
        return this.attributesPane;
    }

    public JPanel getAttributesPanel() {
        return this.attributesPane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

