/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOspfVLink;
import cerent.cms.model.InvalidData;
import cerent.cms.model.OspfVLink;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractProvPane;
import cerent.cms.ui.LeavePageException;
import cerent.cms.ui.shelf.OspfAreaRangeAttributesPane;
import cerent.cms.ui.shelf.OspfPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OspfVLinkAttributesPane
extends AbstractProvPane
implements ActionListener,
DocumentListener {
    static final String DEFAULT_IP_ADDRESS = "";
    boolean editOnly = false;
    protected INodeModel nodeModel;
    protected IOspfVLink myVLink = new OspfVLink();
    protected JTextField neighborTF;
    protected JTextField transitTF;
    protected JTextField retransitTF;
    protected JTextField helloTF;
    protected JTextField deadTF;
    protected JComboBox authTypeCB;
    protected JPasswordField authKeyPF;
    protected JPasswordField confirmKeyPF;
    JLabel neighborLbl;
    JLabel transitLbl;
    JLabel retransitLbl;
    JLabel helloLbl;
    JLabel deadLbl;
    JLabel authTypeLbl;
    JLabel authKeyLbl;
    JLabel confirmKeyLbl;
    private static final SDebug db = new SDebug("OspfVLinkAttributesPane");

    public void setVLink(IOspfVLink iOspfVLink) {
        this.myVLink = iOspfVLink;
        this.refresh();
    }

    public IOspfVLink getVLink() {
        return this.myVLink;
    }

    protected OspfVLinkAttributesPane(String string, INodeModel iNodeModel) {
        super(string, (IModel)iNodeModel, null);
        this.setNodeModel(iNodeModel);
        if (db.on()) {
            db.println("<init>: start");
        }
        this.add(this.createAttributesPanel(), "Center");
        this.setNodeModel(iNodeModel);
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    public boolean hasSubTabs() {
        return true;
    }

    public void destroy() {
        this.nodeModel = null;
        super.destroy();
    }

    protected void customInit() {
        this.neighborLbl = new JLabel("Neighbor: ", 2);
        this.transitLbl = new JLabel("Transmit Delay (sec): ", 2);
        this.retransitLbl = new JLabel("Retransmit Int (sec): ", 2);
        this.helloLbl = new JLabel("Hello Int (sec): ", 2);
        this.deadLbl = new JLabel("Dead Int (sec): ", 2);
        this.authTypeLbl = new JLabel("Auth Type: ", 2);
        this.authKeyLbl = new JLabel("Auth Key: ", 2);
        this.confirmKeyLbl = new JLabel("Confirm Auth Key: ", 2);
        this.neighborTF = new JTextField(DEFAULT_IP_ADDRESS);
        this.neighborTF.setPreferredSize(new Dimension(105, 21));
        this.transitTF = new JTextField();
        this.retransitTF = new JTextField();
        this.helloTF = new JTextField();
        this.deadTF = new JTextField();
        this.authTypeCB = new JComboBox<String>(OspfPane.authChoices);
        this.authKeyPF = new JPasswordField();
        this.confirmKeyPF = new JPasswordField();
    }

    protected void setEditOnly() {
        this.neighborLbl.setEnabled(false);
        this.neighborTF.setEnabled(false);
        this.editOnly = true;
    }

    protected JPanel buildAttributesPanel() {
        this.customInit();
        this.neighborLbl.setBorder(BorderFactory.createLineBorder(Color.red, 3));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        jPanel.add(this.neighborLbl);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(this.neighborTF);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected JPanel createAttributesPanel() {
        this.customInit();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        this.neighborLbl.setSize(130, 21);
        this.neighborLbl.setLocation(0, 0);
        this.neighborTF.setSize(100, 21);
        this.neighborTF.setLocation(140, 0);
        jPanel.add(this.neighborLbl);
        jPanel.add(this.neighborTF);
        this.transitLbl.setSize(130, 21);
        this.transitLbl.setLocation(0, 25);
        this.transitTF.setSize(30, 21);
        this.transitTF.setLocation(140, 25);
        jPanel.add(this.transitLbl);
        jPanel.add(this.transitTF);
        this.authTypeLbl.setSize(100, 21);
        this.authTypeLbl.setLocation(250, 25);
        this.authTypeCB.setSize(130, 21);
        this.authTypeCB.setLocation(380, 25);
        jPanel.add(this.authTypeLbl);
        jPanel.add(this.authTypeCB);
        this.helloLbl.setSize(130, 21);
        this.helloLbl.setLocation(0, 50);
        this.helloTF.setSize(30, 21);
        this.helloTF.setLocation(140, 50);
        jPanel.add(this.helloLbl);
        jPanel.add(this.helloTF);
        this.authKeyLbl.setSize(60, 21);
        this.authKeyLbl.setLocation(250, 50);
        this.authKeyPF.setSize(100, 21);
        this.authKeyPF.setLocation(380, 50);
        jPanel.add(this.authKeyLbl);
        jPanel.add(this.authKeyPF);
        this.retransitLbl.setSize(140, 21);
        this.retransitLbl.setLocation(0, 75);
        this.retransitTF.setSize(30, 21);
        this.retransitTF.setLocation(140, 75);
        jPanel.add(this.retransitLbl);
        jPanel.add(this.retransitTF);
        this.confirmKeyLbl.setSize(140, 21);
        this.confirmKeyLbl.setLocation(250, 75);
        this.confirmKeyPF.setSize(100, 21);
        this.confirmKeyPF.setLocation(380, 75);
        jPanel.add(this.confirmKeyLbl);
        jPanel.add(this.confirmKeyPF);
        this.deadLbl.setSize(100, 21);
        this.deadLbl.setLocation(0, 100);
        this.deadTF.setSize(50, 21);
        this.deadTF.setLocation(140, 100);
        jPanel.add(this.deadLbl);
        jPanel.add(this.deadTF);
        this.neighborTF.getDocument().addDocumentListener(this);
        this.transitTF.getDocument().addDocumentListener(this);
        this.retransitTF.getDocument().addDocumentListener(this);
        this.helloTF.getDocument().addDocumentListener(this);
        this.deadTF.getDocument().addDocumentListener(this);
        this.authKeyPF.getDocument().addDocumentListener(this);
        this.authTypeCB.addActionListener(this);
        this.confirmKeyPF.getDocument().addDocumentListener(this);
        return jPanel;
    }

    public void setNodeModel(INodeModel iNodeModel) {
        this.nodeModel = iNodeModel;
    }

    public boolean onValidate() {
        try {
            this.validateFields();
            return true;
        }
        catch (InvalidData invalidData) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_AUTH_KEY_BLANK);
            return false;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_VALIDATION_ERROR);
            return false;
        }
    }

    protected void validateFields() throws Exception, InvalidData {
        String string = String.valueOf(this.authKeyPF.getPassword());
        if (this.authTypeCB.getSelectedIndex() != 0) {
            if (string.length() == 0) {
                throw new InvalidData(DEFAULT_IP_ADDRESS);
            }
            if (string.length() > 8) {
                throw new Exception("The authentication key may only be eight characters maximum.");
            }
            String string2 = String.valueOf(this.confirmKeyPF.getPassword());
            if (!string.equals(string2)) {
                throw new Exception("Confirm key is not the same as the authentication key.");
            }
        }
        if (!this.editOnly) {
            if (this.neighborTF.getText().equals(DEFAULT_IP_ADDRESS) || this.neighborTF.getText().equals("0.0.0.0")) {
                throw new Exception("Neighbor Address may not be empty or 0.0.0.0");
            }
            try {
                this.myVLink.setNeighbor(InetUtil.makeIpAddr(this.neighborTF.getText()));
            }
            catch (Exception exception) {
                throw new Exception("Improper Neighbor Address");
            }
        }
        int n = Integer.parseInt(this.transitTF.getText());
        this.myVLink.setTransitDelay((short)n);
        n = Integer.parseInt(this.retransitTF.getText());
        this.myVLink.setRetransitInterval((short)n);
        n = Integer.parseInt(this.helloTF.getText());
        this.myVLink.setHelloInterval((short)n);
        n = Integer.parseInt(this.deadTF.getText());
        this.myVLink.setDeadInterval(n);
        n = this.authTypeCB.getSelectedIndex();
        this.myVLink.setAuthType(n);
        this.myVLink.setAuthKey(string);
    }

    public void refreshFromModel() throws Exception {
        String string = InetUtil.makeDottedString(this.myVLink.getNeighbor());
        short s = this.myVLink.getTransitDelay();
        short s2 = this.myVLink.getRetransitInterval();
        short s3 = this.myVLink.getHelloInterval();
        int n = this.myVLink.getDeadInterval();
        int n2 = this.myVLink.getAuthType();
        String string2 = this.myVLink.getAuthKey();
        this.neighborTF.setText(string);
        this.transitTF.setText(String.valueOf(s));
        this.retransitTF.setText(String.valueOf(s2));
        this.helloTF.setText(String.valueOf(s3));
        this.deadTF.setText(String.valueOf(n));
        this.authTypeCB.setSelectedIndex(n2);
        this.authKeyPF.setText(string2);
        super.refreshFromModel();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.authTypeCB) {
            if (this.authTypeCB.getSelectedIndex() == 0) {
                this.authKeyPF.setEnabled(false);
                this.authKeyPF.setText(DEFAULT_IP_ADDRESS);
                this.confirmKeyPF.setEnabled(false);
                this.confirmKeyPF.setText(DEFAULT_IP_ADDRESS);
            } else {
                this.authKeyPF.setEnabled(true);
                this.confirmKeyPF.setEnabled(true);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
    }

    public void removeUpdate(DocumentEvent documentEvent) {
    }

    public Dimension getPreferredSize() {
        return new Dimension(550, 150);
    }

    protected AbstractLeavePageException createLeavePageException(String string) {
        if (db.on()) {
            db.println("createLeavePageException");
        }
        return new LeavePageException(string);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("OspfVLinkAttributesPane Unit Test");
        jFrame.setSize(500, 250);
        jFrame.getContentPane().add((Component)((Object)new OspfAreaRangeAttributesPane(DEFAULT_IP_ADDRESS, null)));
        jFrame.setVisible(true);
    }
}

