/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eProtectionType;
import cerent.cms.idl.SonetTopology.eDetectionGuardTimer;
import cerent.cms.idl.SonetTopology.eOnePlusOneType;
import cerent.cms.idl.SonetTopology.eRecoveryGuardTimer;
import cerent.cms.idl.SonetTopology.eVerifyGuardTimer;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.RanSvcModuleModel;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.model.YCableModel;
import cerent.cms.ui.RevertiveBehaviorPanel;
import cerent.cms.ui.shelf.PgAttrsPane;
import cerent.cms.ui.shelf.SppProtectionPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class PgEditPane
extends PgAttrsPane {
    protected Model model;
    public static final String USER_CANCEL = "Cancelled by user";
    protected static final SDebug db = new SDebug((KDebug)SppProtectionPane.db, "PgEditPane");

    public PgEditPane(SppProtectionPane sppProtectionPane) {
        super("EditPane", (IChassisModel)sppProtectionPane.getUiModel(), sppProtectionPane.getParentView());
        this.protTypeCB.setEnabled(false);
        this.protTypeCB.addItem(protTypeStrings[0]);
        this.protTypeCB.addItem(protTypeStrings[5]);
        this.protectCB.setEnabled(false);
        this.enableToFromButtons();
        this.refresh();
    }

    public void setModel(Model model) throws Exception {
        if (!(model == null || model instanceof ProtectionGroupModel || model instanceof OnePlusOneModel || model instanceof YCableModel)) {
            throw new ClassCastException(model.getClass().getName());
        }
        this.leavingPage();
        this.model = model;
        this.enteringPage();
    }

    public Model getModel() {
        return this.model;
    }

    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("applyChangesToModel: start");
        }
        if (this.model instanceof ProtectionGroupModel) {
            if (this.isXtcProtGrp()) {
                CerentDialog.warningDialog((Component)((Object)this), (String)"Cannot edit XTC protection group");
            } else {
                this.applyChangesToPgModel((ProtectionGroupModel)this.model);
            }
        } else if (this.model instanceof OnePlusOneModel) {
            this.applyChangesToOpoModel((OnePlusOneModel)this.model);
        } else if (this.model instanceof YCableModel) {
            this.applyChangesToYcModel((YCableModel)this.model);
        }
        if (db.on()) {
            db.println("applyChangesToModel: finish");
        }
    }

    private void applyChangesToPgModel(ProtectionGroupModel protectionGroupModel) throws Exception {
        if (protectionGroupModel.getReversion().getReversionTime() == 0 && this.rbPanel.getReversionTime() != 0 && !this.rbPanel.RevertiveDialog()) {
            throw new Exception(USER_CANCEL);
        }
        protectionGroupModel.setName(this.nameTF.getText());
        if (this.protType == 1) {
            ModuleModel[] moduleModelArray = (ModuleModel[])protectionGroupModel.getMainModuleModels();
            Object[] objectArray = new ModuleModel[this.mainListModel.getSize()];
            this.mainListModel.copyInto(objectArray);
            ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
            arrayList.removeAll(Arrays.asList(moduleModelArray));
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                protectionGroupModel.addMainModuleModel((ModuleModel)object.next());
            }
            object = new ArrayList<ModuleModel>(Arrays.asList(moduleModelArray));
            object.removeAll(Arrays.asList(objectArray));
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ModuleModel moduleModel = (ModuleModel)iterator.next();
                try {
                    protectionGroupModel.removeMainModuleModel(moduleModel);
                }
                catch (ResourceInUse resourceInUse) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_PG_EDIT_REMOVE_PARAM_1, (Object)this.entityCellRenderer.getString(moduleModel, "slot "));
                }
            }
        }
        try {
            protectionGroupModel.setReversion(this.rbPanel.getRevertiveBehavior());
        }
        catch (Busy busy) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_SET_PG_REVERSION_FAILED);
        }
    }

    private void applyChangesToOpoModel(OnePlusOneModel onePlusOneModel) throws Exception {
        if (onePlusOneModel.getReversion().getReversionTime() == 0 && this.rbPanel.getReversionTime() != 0 && !this.rbPanel.RevertiveDialog()) {
            throw new Exception(USER_CANCEL);
        }
        onePlusOneModel.setName(this.nameTF.getText());
        try {
            boolean bl;
            boolean bl2 = bl = onePlusOneModel.getOnePlusOneType() == eOnePlusOneType.ONEPLUSONE_STANDARD;
            if (bl) {
                onePlusOneModel.setBidirectional(this.bidirCB.isSelected());
                onePlusOneModel.setReversion(this.rbPanel.getRevertiveBehavior());
            } else {
                onePlusOneModel.setReversion(new RevertiveBehavior(1, ((RevertiveBehaviorPanel.ReversionTime)this.reversionTimer.getSelectedItem()).getTime()));
                onePlusOneModel.setVerificationGuardTimer(eVerifyGuardTimer.from_int(this.vgTimer.getSelectedIndex()));
                onePlusOneModel.setRecoveryGuardTimer(eRecoveryGuardTimer.from_int(this.rgTimer.getSelectedIndex()));
                onePlusOneModel.setDetectionGuardTimer(eDetectionGuardTimer.from_int(this.dgTimer.getSelectedIndex()));
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (db.on()) {
                db.println("failed to applyChangesToOpoModel");
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            throw abstractCmsIOException;
        }
    }

    private void applyChangesToYcModel(YCableModel yCableModel) throws Exception {
        if (yCableModel.getReversion().getReversionTime() == 0 && this.rbPanel.getReversionTime() != 0 && !this.rbPanel.RevertiveDialog()) {
            throw new Exception(USER_CANCEL);
        }
        String string = this.nameTF.getText();
        if (!yCableModel.getName().equals(string)) {
            yCableModel.setName(string);
        }
        try {
            boolean bl = this.bidirCB.isSelected();
            if (yCableModel.isBidirectional() != bl) {
                yCableModel.setBidirectional(this.bidirCB.isSelected());
            }
            RevertiveBehavior revertiveBehavior = (RevertiveBehavior)this.rbPanel.getRevertiveBehavior();
            if (!yCableModel.getReversion().equals(revertiveBehavior)) {
                yCableModel.setReversion(this.rbPanel.getRevertiveBehavior());
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (db.on()) {
                db.println("failed to applyChangesToYcModel");
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            throw abstractCmsIOException;
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel: start");
        }
        if (this.model == null) {
            if (db.on()) {
                db.println("refreshFromModel: model is null");
            }
            this.nameTF.setText("");
            this.nameTF.setEnabled(false);
            this.protTypeCB.setSelectedItem(null);
            if (this.protectCB.getItemCount() > 0) {
                this.protectCB.removeAllItems();
            }
            this.availListModel.removeAllElements();
            this.mainListModel.removeAllElements();
            this.bidirCB.setSelected(false);
            this.bidirCB.setEnabled(false);
            this.rbPanel.setRevertiveBehavior(null);
            return;
        }
        if (this.model instanceof ProtectionGroupModel) {
            this.refreshFromPgModel((ProtectionGroupModel)this.model);
        } else if (this.model instanceof OnePlusOneModel) {
            this.refreshFromOpoModel((OnePlusOneModel)this.model);
        } else if (this.model instanceof YCableModel) {
            this.refreshFromYcModel((YCableModel)this.model);
        }
        boolean bl = this.isUserAuthorized();
        if (this.protType == 1) {
            this.setListsEnabled(bl);
            this.rbPanel.setRevertiveEnabled(bl && this.allowRevertiveOffFor1ToN());
        } else {
            this.setListsEnabled(false);
            this.rbPanel.setRevertiveEnabled(bl);
        }
        if (this.isXtcProtGrp()) {
            this.nameTF.setEnabled(false);
            this.rbPanel.setRevertiveEnabled(false);
            if (db.on()) {
                db.println("refreshFromModel: XTC Prot Group:Revertive disabled");
            }
        }
        if (db.on()) {
            db.println("refreshFromModel: finish");
        }
    }

    private int mapPgProtectionType(eProtectionType eProtectionType2) {
        switch (eProtectionType2.value()) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unknown protection type");
    }

    private void refreshFromPgModel(ProtectionGroupModel protectionGroupModel) {
        block7: {
            try {
                this.nameTF.setText(protectionGroupModel.getName());
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!db.on()) break block7;
                db.println("failed to refreshFromPgModel");
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
        this.nameTF.setEnabled(this.isUserAuthorized());
        this.setProtectionType(this.mapPgProtectionType(protectionGroupModel.getProtectType()));
        if (this.protectCB.getItemCount() > 0) {
            this.protectCB.removeAllItems();
        }
        this.mainListModel.removeAllElements();
        this.availListModel.removeAllElements();
        ModuleModel moduleModel = (ModuleModel)protectionGroupModel.getProtectModuleModel();
        if (moduleModel == null) {
            return;
        }
        this.protectCB.addItem(moduleModel);
        ModuleModel[] moduleModelArray = (ModuleModel[])protectionGroupModel.getMainModuleModels();
        if (db.on()) {
            db.println("refreshFromPgModel: found " + moduleModelArray.length + " main modules");
        }
        for (int i = 0; i < moduleModelArray.length; ++i) {
            this.mainListModel.addElement(moduleModelArray[i]);
        }
        ModuleModel[] moduleModelArray2 = (ModuleModel[])this.chassis.getEntityTableModel().getCompatibleMainModules(moduleModel, this.getProtectionType());
        for (int i = 0; i < moduleModelArray2.length; ++i) {
            if (this.mainListModel.contains(moduleModelArray2[i])) continue;
            this.availListModel.addElement(moduleModelArray2[i]);
        }
        this.bidirCB.setSelected(false);
        this.bidirCB.setEnabled(false);
        this.rbPanel.updateReversionTimes(moduleModel);
        this.rbPanel.setRevertiveBehavior(protectionGroupModel.getReversion());
    }

    private void refreshFromOpoModel(OnePlusOneModel onePlusOneModel) {
        block15: {
            boolean bl;
            block14: {
                EntityModel entityModel;
                block13: {
                    this.nameTF.setText(onePlusOneModel.getName());
                    this.nameTF.setEnabled(this.isUserAuthorized());
                    boolean bl2 = bl = onePlusOneModel.getOnePlusOneType() == eOnePlusOneType.ONEPLUSONE_STANDARD;
                    if (bl) {
                        this.setProtectionType(2);
                    } else {
                        this.setProtectionType(3);
                    }
                    try {
                        entityModel = (EntityModel)onePlusOneModel.getProtectEntityModel();
                        if (this.protectCB.getItemCount() > 0) {
                            this.protectCB.removeAllItems();
                        }
                        this.protectCB.addItem(entityModel);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!db.on()) break block13;
                        db.println("failed to getProtectEntityModel in refreshFromOpoModel");
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
                try {
                    entityModel = (EntityModel)onePlusOneModel.getMainEntityModel();
                    this.mainListModel.removeAllElements();
                    this.mainListModel.addElement(entityModel);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (db.on()) {
                        db.println("AbstractCmsIOException in refreshFromOpoModel");
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block14;
                    db.println("AbstractCmsNoSuchEntityException in refreshFromOpoModel");
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            this.availListModel.removeAllElements();
            try {
                if (bl) {
                    this.bidirCB.setEnabled(this.isUserAuthorized());
                    this.bidirCB.setSelected(onePlusOneModel.isBidirectional());
                    this.rbPanel.setRevertiveBehavior(onePlusOneModel.getReversion());
                } else {
                    this.reversionTimer.setSelectedItem(RevertiveBehaviorPanel.getReversionTime(onePlusOneModel.getReversion().getReversionTime()));
                    this.vgTimer.setSelectedIndex(onePlusOneModel.getVerificationGuardTimer().value());
                    this.rgTimer.setSelectedIndex(onePlusOneModel.getRecoveryGuardTimer().value());
                    this.dgTimer.setSelectedIndex(onePlusOneModel.getDetectionGuardTimer().value());
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!db.on()) break block15;
                db.println("failed to setRevertiveBehavior");
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
    }

    private void refreshFromYcModel(YCableModel yCableModel) {
        block11: {
            block10: {
                EntityModel entityModel;
                block9: {
                    this.nameTF.setText(yCableModel.getName());
                    this.nameTF.setEnabled(this.isUserAuthorized());
                    this.setProtectionType(yCableModel.getType() == 4 ? 4 : 5);
                    try {
                        entityModel = (EntityModel)yCableModel.getProtectEntityModel();
                        if (this.protectCB.getItemCount() > 0) {
                            this.protectCB.removeAllItems();
                        }
                        this.protectCB.addItem(entityModel);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!db.on()) break block9;
                        db.println("failed to getProtectEntityModel in refreshFromYcModel");
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
                try {
                    entityModel = (EntityModel)yCableModel.getMainEntityModel();
                    this.mainListModel.removeAllElements();
                    this.mainListModel.addElement(entityModel);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (db.on()) {
                        db.println("AbstractCmsIOException in refreshFromYcModel");
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block10;
                    db.println("AbstractCmsNoSuchEntityException in refreshFromYcModel");
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            this.availListModel.removeAllElements();
            this.bidirCB.setEnabled(false);
            try {
                this.bidirCB.setSelected(yCableModel.isBidirectional());
                this.rbPanel.setRevertiveBehavior(yCableModel.getReversion());
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!db.on()) break block11;
                db.println("failed to setRevertiveBehavior");
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
    }

    protected boolean isXtcProtGrp() {
        boolean bl = false;
        if (this.model != null && this.model instanceof ProtectionGroupModel && this.pci.is327()) {
            bl = ((ProtectionGroupModel)this.model).getName().equals("XTCPROTGRP");
        }
        return bl;
    }

    private boolean allowRevertiveOffFor1ToN() {
        return this.model instanceof ProtectionGroupModel && ((ProtectionGroupModel)this.model).getProtectModuleModel() instanceof RanSvcModuleModel;
    }
}

