/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.Busy;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.DwdmOpticalSetupModel;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.MissingEquipment;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ans.AnsPathDataSource;
import cerent.cms.ui.ans.AnsPathTableModel;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class ProvSpPathPane
extends AbstractPane
implements ActionListener,
Runnable {
    private static final String LAUNCH = "Launch ANS";
    private static final String REFRESH = "Refresh";
    static final SimpleDateFormat timeFmt = new SimpleDateFormat("MMMMM d,yyyy H:mm:ss a,z");
    private JButton launchButton = new JButton("Launch ANS");
    private JButton refreshButton = new JButton("Refresh");
    private JLabel label = new JLabel(" ");
    private String labelText;
    private AnsPathTableModel dataModel;
    private AnsPathDataSource dataSource;
    private EventUtilities eventutilities;
    private boolean initialized = true;
    private int[] sortCols = new int[]{0};
    private boolean[] sortDir = new boolean[]{true};
    private TabbedView parent;
    private NodeModelDelegate nodeModel;
    private DwdmOpticalSetupModel opticalSetupModel;
    private static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "SppOnsPathPane");

    public ProvSpPathPane(String string, TabbedView tabbedView, DwdmOpticalSetupModel dwdmOpticalSetupModel) {
        super(string, tabbedView);
        this.parent = tabbedView;
        this.eventutilities = EventUtilities.getInstance((NodeModelDelegate)this.getUiModel().getNodeModel());
        this.opticalSetupModel = dwdmOpticalSetupModel;
    }

    private void init() {
        if (db.on()) {
            db.println("init");
        }
        this.setLayout(new BorderLayout());
        this.nodeModel = (NodeModelDelegate)this.opticalSetupModel.getNodeModel();
        this.dataSource = new AnsPathDataSource(this.opticalSetupModel);
        this.dataModel = new AnsPathTableModel(this.dataSource, this.sortCols, this.sortDir);
        this.table = new UTable((TableModel)((Object)this.dataModel));
        ((AnsPathTableModel)((Object)this.table.getModel())).initTable(this.table);
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
        this.add(this.makeControlPanel(), "South");
        this.add((Component)new UScrollPane((Component)this.table), "Center");
    }

    private JPanel makeControlPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        this.launchButton.addActionListener(this);
        this.launchButton.setEnabled(false);
        this.refreshButton.addActionListener(this);
        this.refreshButton.setEnabled(true);
        jPanel2.add(this.launchButton);
        jPanel2.add(this.refreshButton);
        jPanel3.add(this.label);
        jPanel3.add(new CSHelpButton(CSHelpConst.ProvSpPathPane));
        this.enableComponent(this.launchButton, this.nodeModel, SecurityLevel.SUPERUSER);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.launchButton) {
            if (!CerentDialog.yesNoDialog((Component)this.parent, (String)"If there are circuits the operation could be traffic affecting.\nDo you want to continue?", (String)"Apply Launch ANS")) {
                return;
            }
            String string = "";
            try {
                this.dataSource.startONS();
                CerentDialog.infoDialog((Component)((Object)this), (String)"ANS Completed", (String)LAUNCH);
            }
            catch (MissingEquipment missingEquipment) {
                SDebug.printStackTrace((Throwable)missingEquipment);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_EQPT_NOT_PLUG);
            }
            catch (FeatureUnsupported featureUnsupported) {
                SDebug.printStackTrace((Throwable)featureUnsupported);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CANNOT_PERFORM);
            }
            catch (Busy busy) {
                SDebug.printStackTrace((Throwable)busy);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_ANS_BUSY);
            }
            catch (CannotPerform cannotPerform) {
                SDebug.printStackTrace((Throwable)cannotPerform);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_ANS_CANT_PERF);
            }
            finally {
                this.dataSource.getOpticalLinkList();
                this.updateLabel(" node");
            }
        } else if (object == this.refreshButton) {
            try {
                this.dataSource.getOpticalLinkList();
                this.updateLabel(" node");
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_ANS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.dataSource == null) {
                this.init();
            }
            if (this.initialized) {
                this.dataSource.getOpticalLinkList();
                this.updateLabel(" node");
                this.initialized = false;
            }
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    public void updateLabel(String string) {
        long l = this.eventutilities.convertSecondsToMilliSeconds(this.opticalSetupModel.getAnsLastTimeStamp());
        timeFmt.setTimeZone(this.nodeModel.getCtcTimeZone());
        Date date = new Date(l);
        timeFmt.format(date);
        String string2 = "Launched: Not Available from " + string;
        if (l != 0L) {
            string2 = "Launched: " + timeFmt.format(date) + " from " + string;
        }
        this.setLabel(string2);
    }

    public void clearLabel() {
        this.setLabel(" ");
    }

    private void setLabel(String string) {
        this.labelText = string;
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    public void run() {
        this.label.setText(this.labelText);
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.initialized = true;
    }

    public void refresh() {
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
        if (this.dataSource != null) {
            this.dataSource.dispose();
            this.dataSource = null;
        }
    }
}

