/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IIpAddr;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.RadiusServer;
import cerent.cms.model.RadiusServerModel;
import cerent.cms.ui.shelf.RadiusServerInfoPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.gui.FixedLengthDocument;
import cerent.util.gui.IntegerDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RadiusServerMaintDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private static final String OK = "OK";
    private static final String CANCEL = "Cancel";
    private static final int MARGIN = 5;
    private static final int PORT_LENGTH = 5;
    public static final String CREATE_TITLE = "Create RADIUS Server Entry";
    public static final String EDIT_TITLE = "Edit RADIUS Server Entry";
    private JButton okButton;
    private JButton cancelButton;
    private JTextField ipTF;
    private JTextField sharedSecretTF;
    private JTextField authPortTF;
    private JTextField acctPortTF;
    private JLabel acctPortLabel;
    private RadiusServerInfoPane parent;
    private RadiusServerModel radiusServerModel;
    private boolean ok = false;
    private static final SDebug db = new SDebug("RadiusServerMaintDialog");

    public RadiusServerMaintDialog(RadiusServerInfoPane radiusServerInfoPane, RadiusServerModel radiusServerModel) {
        this(radiusServerInfoPane, radiusServerModel, null);
    }

    public RadiusServerMaintDialog(RadiusServerInfoPane radiusServerInfoPane, RadiusServerModel radiusServerModel, RadiusServer radiusServer) {
        this(JOptionPane.getFrameForComponent((Component)((Object)radiusServerInfoPane)), radiusServerInfoPane, radiusServerModel, radiusServer, radiusServer == null ? CREATE_TITLE : EDIT_TITLE);
    }

    private RadiusServerMaintDialog(Frame frame, RadiusServerInfoPane radiusServerInfoPane, RadiusServerModel radiusServerModel, RadiusServer radiusServer, String string) {
        super(frame, string, true);
        this.radiusServerModel = radiusServerModel;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RadiusServerMaintDialog.this.dispose();
            }
        });
        this.parent = radiusServerInfoPane;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getAttrsPanel(), "North");
        container.add((Component)this.getButtonPanel(), "South");
        if (radiusServer != null) {
            this.refreshFromModel(radiusServer);
        } else {
            this.putDefaultAuthPort();
            this.putDefaultAcctPort();
        }
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private String helpPutDefault(String string, String string2) {
        try {
            string2 = this.radiusServerModel.getNodeModel().getDefaultValue(string);
        }
        catch (NoSuchDefault noSuchDefault) {
            db.severe("helpPutDefault(): no such default " + string);
        }
        catch (Exception exception) {
            db.severe("helpPutDefault():unexpected exception from getDefaultValue():" + exception);
        }
        return string2;
    }

    private void putDefaultAuthPort() {
        if (this.authPortTF != null) {
            this.authPortTF.setText(this.helpPutDefault("NODE.security.radiusServer.AuthenticationPort", "1812"));
        }
    }

    private void putDefaultAcctPort() {
        if (this.acctPortTF != null) {
            this.acctPortTF.setText(this.helpPutDefault("NODE.security.radiusServer.AccountingPort", "1813"));
        }
    }

    private void refreshFromModel(RadiusServer radiusServer) {
        this.ipTF.setText(InetUtil.makeDottedString(radiusServer.getIpAddr()));
        this.sharedSecretTF.setText(new String(radiusServer.getSecret()));
        this.authPortTF.setText(String.valueOf(radiusServer.getAuthPort()));
        this.acctPortTF.setText(String.valueOf(radiusServer.getAcctPort()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.validateFields()) {
                this.ok = true;
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    public RadiusServer getRadiusServer() {
        IIpAddr iIpAddr = this.getIpAddr();
        int n = this.getAuthPort();
        int n2 = this.getAcctPort();
        byte[] byArray = this.getSharedSecret().getBytes();
        return new RadiusServer(iIpAddr, n, n2, byArray);
    }

    public boolean isOk() {
        return this.ok;
    }

    private JPanel getAttrsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add(this.createLabel("IP Address:", 140, 20));
        this.ipTF = new JTextField();
        jPanel.add(this.ipTF);
        jPanel.add(this.createLabel("Shared Secret:", 140, 20));
        this.sharedSecretTF = new JTextField();
        jPanel.add(this.sharedSecretTF);
        jPanel.add(this.createLabel("Authentication Port:", 140, 20));
        this.authPortTF = new JTextField();
        jPanel.add(this.authPortTF);
        this.acctPortLabel = this.createLabel("Accounting Port:", 140, 20);
        jPanel.add(this.acctPortLabel);
        this.acctPortTF = new JTextField();
        jPanel.add(this.acctPortTF);
        this.ipTF.getDocument().addDocumentListener(this);
        this.sharedSecretTF.setDocument(new FixedLengthDocument(RadiusServerModel.getMaxSecretLength()));
        this.sharedSecretTF.getDocument().addDocumentListener(this);
        this.authPortTF.setDocument(new IntegerDocument(0, 65535, 5));
        this.authPortTF.getDocument().addDocumentListener(this);
        this.acctPortTF.setDocument(new IntegerDocument(0, 65535, 5));
        this.acctPortTF.getDocument().addDocumentListener(this);
        return jPanel;
    }

    private JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        return jLabel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        this.okButton.setEnabled(false);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private IIpAddr getIpAddr() {
        return InetUtil.makeIpAddr(this.ipTF.getText());
    }

    private String getSharedSecret() {
        return this.sharedSecretTF.getText();
    }

    private int getAuthPort() {
        return this.getPort(this.authPortTF.getText());
    }

    private int getAcctPort() {
        return this.getPort(this.acctPortTF.getText());
    }

    private int getPort(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return n;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.okButton.setEnabled(true);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.okButton.setEnabled(true);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.okButton.setEnabled(true);
    }

    private boolean validateFields() {
        try {
            IIpAddr iIpAddr = this.getIpAddr();
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_INVALID_IP_ADDR_PARAM_1, (Object)this.ipTF.getText());
            return false;
        }
        if (this.sharedSecretTF.getText().length() == 0) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_FIELD_IS_REQUIRED_PARAM_1, (Object)"Shared Secret");
            return false;
        }
        if (this.authPortTF.getText().length() == 0) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_FIELD_IS_REQUIRED_PARAM_1, (Object)"Authentication Port");
            return false;
        }
        if (this.acctPortTF.getText().length() == 0) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_FIELD_IS_REQUIRED_PARAM_1, (Object)"Accounting Port");
            return false;
        }
        return true;
    }
}

