/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IRipAddressSummary;
import cerent.cms.model.IRipAddressSummaryModel;
import cerent.cms.model.RipAddressSummaryModel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfEditTablePane;
import cerent.cms.ui.shelf.RipAddressSummaryCreateDialog;
import cerent.cms.ui.shelf.RipAddressSummaryEditDialog;
import cerent.cms.ui.shelf.SppNetworkPane;
import cerent.util.IObservableManager;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JTable;

public class RipAddressSummaryPane
extends AbstractShelfEditTablePane {
    public static final int SUMMARY_ADDRESS = 0;
    public static final int MASK_LENGTH = 1;
    public static final int COST = 2;
    private IRipAddressSummaryModel rasModel = null;
    private static final SDebug db = new SDebug((KDebug)SppNetworkPane.db, "RipAddressSummaryPane");
    static /* synthetic */ Class class$cerent$cms$model$IRipAddressSummary;

    public RipAddressSummaryPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.ENTRY_TYPE = "Summary Pane";
    }

    protected void initModels() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new SummaryAddressColumnRenderer(), new MaskLengthColumnRenderer(), new CostColumnRenderer()};
        RipAddressRowSource ripAddressRowSource = new RipAddressRowSource();
        this.model = new SortableRowTableModel((RowDataSource)ripAddressRowSource, columnRendererArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateTableData() {
        ArrayList arrayList = this.tableData;
        synchronized (arrayList) {
            IRipAddressSummary[] iRipAddressSummaryArray = this.rasModel.getRipAddressSummaryTable();
            for (int i = 0; i < iRipAddressSummaryArray.length; ++i) {
                this.tableData.add(iRipAddressSummaryArray[i]);
            }
        }
    }

    public void destroy() {
        if (this.rasModel != null) {
            ((RipAddressSummaryModel)this.rasModel).deleteObserver((Observer)((Object)this));
            this.rasModel = null;
        }
        super.destroy();
        this.nodeModel = null;
    }

    protected void createTableEntry() {
        RipAddressSummaryCreateDialog ripAddressSummaryCreateDialog = RipAddressSummaryCreateDialog.instance(this);
        ripAddressSummaryCreateDialog.show();
        ripAddressSummaryCreateDialog.dispose();
    }

    protected void editSelectedTableEntry(int n) {
        IRipAddressSummary iRipAddressSummary = (IRipAddressSummary)this.model.getValueAt(n, 0);
        RipAddressSummaryEditDialog ripAddressSummaryEditDialog = RipAddressSummaryEditDialog.instance(this);
        if (iRipAddressSummary != null) {
            ripAddressSummaryEditDialog.setSummary(iRipAddressSummary);
        }
        ripAddressSummaryEditDialog.show();
        ripAddressSummaryEditDialog.dispose();
    }

    protected void deleteSelectedTableEntry(int n) {
        IRipAddressSummary iRipAddressSummary = (IRipAddressSummary)this.model.getValueAt(n, 0);
        if (CerentDialog.yesNoDialog((Component)((Object)this), (String)"Are you sure you want to delete this summary address?", (String)"Confirmation Dialog")) {
            this.setEditDeleteEnabled(false);
            if (this.rasModel != null) {
                this.rasModel.deleteRipAddressSummary(iRipAddressSummary.getSummaryAddress());
            }
        }
    }

    protected void registerWithModels() {
        if (this.rasModel == null) {
            this.rasModel = this.nodeModel.getRipAddressSummaryModel();
            this.getObservableManager().addObservable((Observable)this.rasModel);
            if (this.uiModel instanceof Observable) {
                this.getObservableManager().addObservable((Observable)this.uiModel);
            }
        }
    }

    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    class CostColumnRenderer
    extends BaseColumnRenderer {
        CostColumnRenderer() {
        }

        public int getWidth() {
            return 50;
        }

        public String getName() {
            return "Cost";
        }
    }

    class MaskLengthColumnRenderer
    extends BaseColumnRenderer {
        MaskLengthColumnRenderer() {
        }

        public String getName() {
            return "Mask Length";
        }
    }

    class SummaryAddressColumnRenderer
    extends BaseColumnRenderer {
        SummaryAddressColumnRenderer() {
        }

        public String getName() {
            return "Summary Addr";
        }
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        BaseColumnRenderer() {
        }

        public int getWidth() {
            return 150;
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        protected String getStringValue(IRipAddressSummary iRipAddressSummary, int n) {
            String string = "???";
            if (iRipAddressSummary != null) {
                switch (n) {
                    case 0: {
                        string = InetUtil.makeDottedString(iRipAddressSummary.getSummaryAddress());
                        break;
                    }
                    case 1: {
                        string = InetUtil.makeDottedString(InetUtil.makeNetMask(iRipAddressSummary.getMaskLength()));
                        break;
                    }
                    case 2: {
                        Integer n2 = new Integer(iRipAddressSummary.getCost());
                        string = n2.toString();
                    }
                }
            }
            return string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            IRipAddressSummary iRipAddressSummary = (IRipAddressSummary)jTable.getValueAt(n, 0);
            String string = this.getStringValue(iRipAddressSummary, n2);
            JLabel jLabel = new JLabel(string);
            jLabel.setOpaque(true);
            jLabel.setForeground(Color.black);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(Color.white);
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(Color.black);
            }
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = this.getStringValue((IRipAddressSummary)object, n);
            String string2 = this.getStringValue((IRipAddressSummary)object2, n);
            return string.compareTo(string2);
        }
    }

    class RipAddressRowSource
    extends AbstractRowDataSource {
        RipAddressRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            ArrayList arrayList = RipAddressSummaryPane.this.tableData;
            synchronized (arrayList) {
                var2_2 = RipAddressSummaryPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            ArrayList arrayList = RipAddressSummaryPane.this.tableData;
            synchronized (arrayList) {
                n = RipAddressSummaryPane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            ArrayList arrayList = RipAddressSummaryPane.this.tableData;
            synchronized (arrayList) {
                return RipAddressSummaryPane.this.tableData;
            }
        }

        public Class getRowObjectClass() {
            return class$cerent$cms$model$IRipAddressSummary == null ? (class$cerent$cms$model$IRipAddressSummary = RipAddressSummaryPane.class$("cerent.cms.model.IRipAddressSummary")) : class$cerent$cms$model$IRipAddressSummary;
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        boolean initedOM = false;

        private void initObservableManager() {
            RipAddressSummaryPane.this.resetObservableManager();
            RipAddressSummaryPane.this.registerWithModels();
            RipAddressSummaryPane.this.setObservableManagerActive();
            this.initedOM = true;
            if (db.on()) {
                db.println("initObservabledManager() done");
            }
        }

        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            if (!this.initedOM) {
                this.initObservableManager();
            } else if (db.on()) {
                db.println("did not call initObservableManager()");
            }
            RipAddressSummaryPane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)RipAddressSummaryPane.this), true);
            }
            return this.dscObservableManager;
        }
    }
}

