/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IIpAddr;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.ISecureIpConfig;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.ui.WizardPane;
import cerent.cms.ui.shelf.SecurityConfigDialog;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.gui.SpinPropertyEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ScdIpAddrPane
extends WizardPane
implements PropertyChangeListener {
    private SecurityConfigDialog parent;
    private JTextField ipAddrTF;
    private JTextField defRouterTF;
    private static String IP_ADDR_LB = "IP Address";
    private static String DEF_ROUTER_LB = "Default Router";
    private JLabel defRouterLB = new JLabel(DEF_ROUTER_LB);
    private JLabel ipAddrLB = new JLabel(IP_ADDR_LB);
    private JLabel netmaskLB = new JLabel("255.255.255.252");
    private JLabel maskLB = new JLabel(" Mask: ");
    private JPanel ipPanel;
    private SpinPropertyEditor netmaskEdit;
    private boolean nodeIpPage;
    protected IIpAddr ipAddr;
    protected IIpAddr defRouterAddr;
    protected short mask;
    private static SDebug db = new SDebug("ScdIpAddrPane");

    public ScdIpAddrPane(String string, SecurityConfigDialog securityConfigDialog, boolean bl, JLabel jLabel) {
        super(string, securityConfigDialog);
        this.parent = securityConfigDialog;
        this.nodeIpPage = bl;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints((Component)((Object)this), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        if (jLabel != null) {
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.ipPanel = ScdIpAddrPane.createHorizontalPanel("");
        int n = 4;
        this.ipPanel.setLayout(new GridLayout(n, 1, 5, 5));
        Dimension dimension = new Dimension(80, 20);
        this.ipAddrTF = this.addTextPanel(this.ipPanel, this.ipAddrLB, 13);
        this.netmaskEdit = new SpinPropertyEditor(" Net/Subnet Mask Length: ", 1, 8, 30);
        this.netmaskEdit.addPropertyChangeListener(this);
        this.ipPanel.add(ScdIpAddrPane.createAttributePanel(null, null, dimension, this.netmaskEdit));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(this.maskLB);
        jPanel2.add(this.netmaskLB);
        this.ipPanel.add(jPanel2);
        if (!this.nodeIpPage) {
            this.defRouterTF = this.addTextPanel(this.ipPanel, this.defRouterLB, 13);
        }
        this.ipPanel.setAlignmentX(0.0f);
        jPanel.add((Component)this.ipPanel, gridBagConstraints);
        jPanel.setAlignmentX(0.0f);
        this.add(jPanel);
    }

    private static JPanel createAttributePanel(String string, String string2, Dimension dimension, JComponent jComponent) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        if (string != null) {
            JLabel jLabel = new JLabel(string);
            jLabel.setPreferredSize(dimension);
            jPanel.add(jLabel);
        }
        jPanel.add(jComponent);
        if (string2 != null) {
            jPanel.add(new JLabel(string2));
        }
        return jPanel;
    }

    private JTextField addTextPanel(JPanel jPanel, JLabel jLabel, int n) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        jPanel2.add(jLabel);
        JTextField jTextField = new JTextField(n);
        jTextField.setMaximumSize(jTextField.getPreferredSize());
        jPanel2.add(jTextField);
        jPanel.add(jPanel2);
        return jTextField;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object == this.netmaskEdit) {
            this.updateMaskLabel();
        }
    }

    private void updateMaskLabel() {
        try {
            int n = Integer.parseInt((String)this.netmaskEdit.getValue());
            int n2 = InetUtil.makeNetMask(n);
            this.netmaskLB.setText(InetUtil.makeDottedString(n2));
        }
        catch (NumberFormatException numberFormatException) {
            db.finer("NumberFormatException in updateMaskLabel() " + numberFormatException);
        }
    }

    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = InetUtil.makeDottedString(this.getIpAddr());
        String string2 = Short.toString(this.mask);
        String string3 = this.netmaskLB.getText();
        String string4 = "";
        String string5 = "";
        if (!this.nodeIpPage) {
            string5 = InetUtil.makeDottedString(this.getDefaultRouterAddr());
            string4 = "Backplane LAN IP Address: \n";
        } else {
            string4 = "Node IP Address: \n";
        }
        stringBuffer.append(string4 + string + "\n");
        stringBuffer.append("Net/Subnet Mask Length: " + string2 + "\n");
        stringBuffer.append("Mask: " + string3 + "\n");
        if (!this.nodeIpPage) {
            stringBuffer.append("Default Router: " + string5 + "\n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void validatePage() throws Exception {
        IIpAddr iIpAddr;
        String string;
        if (db.on()) {
            db.println(" entering validate page");
        }
        if ((string = this.ipAddrTF.getText()) == null) {
            throw new Exception("Please enter an IP address");
        }
        if (db.on()) {
            db.println("ipAddr " + string);
        }
        try {
            iIpAddr = InetUtil.makeIpAddr(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (db.on()) {
                db.println("Invalid IP Address" + numberFormatException);
            }
            throw new Exception("Invalid IP Address");
        }
        this.setIpAddr(iIpAddr);
        String string2 = (String)this.netmaskEdit.getValue();
        if (string2 == null) {
            throw new Exception("Please enter a value for the Net mask");
        }
        short s = 0;
        try {
            s = Short.valueOf(string2);
            this.setMask(s);
        }
        catch (NumberFormatException numberFormatException) {
            if (db.on()) {
                db.println("Invalid netmask" + numberFormatException);
            }
            throw new Exception("Invalid netmask");
        }
        IIpAddr iIpAddr2 = null;
        String string3 = "Host ";
        if (!this.nodeIpPage) {
            string3 = "Backplane LAN port";
            String string4 = this.defRouterTF.getText();
            if (string4 == null) {
                throw new Exception("Please enter the default router address");
            }
            try {
                iIpAddr2 = InetUtil.makeIpAddr(string4);
            }
            catch (NumberFormatException numberFormatException) {
                if (db.on()) {
                    db.println("Invalid netmask" + numberFormatException);
                }
                throw new Exception("Please enter the default router address");
            }
            this.setDefaultRouterAddr(iIpAddr2);
        }
        this.parent.validateConfig(this.getName());
    }

    private void setMask(short s) {
        this.mask = s;
    }

    private void setDefaultRouterAddr(IIpAddr iIpAddr) {
        this.defRouterAddr = iIpAddr;
    }

    public IIpAddr getDefaultRouterAddr() {
        return this.defRouterAddr;
    }

    private void setIpAddr(IIpAddr iIpAddr) {
        this.ipAddr = iIpAddr;
    }

    public short getMask() {
        return this.mask;
    }

    public IIpAddr getIpAddr() {
        return this.ipAddr;
    }

    private String helpPutDefault(String string, String string2) {
        try {
            string2 = this.parent.getNodeModel().getDefaultValue(string);
        }
        catch (NoSuchDefault noSuchDefault) {
            db.severe("helpPutDefault(): no such default " + string);
        }
        catch (Exception exception) {
            db.severe("helpPutDefault(): unexpected exception from getDefaultValue() " + exception);
        }
        return string2;
    }

    public void refresh() {
        IIpConfig iIpConfig = this.parent.getIpConfig();
        if (this.nodeIpPage) {
            db.fine("refresh(): nodeIpPage");
            this.ipAddrTF.setText(this.helpPutDefault("NODE.security.dataComm.DefaultTCCEthernetIP", "10.0.0.1"));
            this.netmaskEdit.setValue(this.helpPutDefault("NODE.security.dataComm.DefaultTCCEthernetIPNetmask", "24"));
            this.updateMaskLabel();
        } else {
            db.fine("refresh(): !nodeIpPage");
            this.defRouterTF.setText(InetUtil.makeDottedString(iIpConfig.getDefaultRouter()));
            ISecureIpConfig iSecureIpConfig = this.parent.getSecureIpConfig();
            IIpAddr iIpAddr = iSecureIpConfig.getIpAddress();
            this.ipAddrTF.setText(InetUtil.makeDottedString(iIpAddr));
            short s = iSecureIpConfig.getNetMaskPrefixLength();
            this.netmaskEdit.setValue(String.valueOf(s));
            this.updateMaskLabel();
        }
    }

    public void setIp(boolean bl, boolean bl2) {
        IIpConfig iIpConfig = this.parent.getIpConfig();
        if (bl2) {
            IIpAddr iIpAddr = iIpConfig.getIpAddress();
            this.ipAddrTF.setText(InetUtil.makeDottedString(iIpAddr));
            short s = iIpConfig.getNetMaskPrefixLength();
            this.netmaskEdit.setValue(String.valueOf(s));
            this.updateMaskLabel();
            this.defRouterTF.setText("");
        } else if (bl) {
            this.ipAddrTF.setText("");
            this.netmaskEdit.setValue("");
            this.updateMaskLabel();
            this.defRouterTF.setText("");
        } else {
            ISecureIpConfig iSecureIpConfig = this.parent.getSecureIpConfig();
            IIpAddr iIpAddr = iSecureIpConfig.getIpAddress();
            this.ipAddrTF.setText(InetUtil.makeDottedString(iIpAddr));
            short s = iSecureIpConfig.getNetMaskPrefixLength();
            this.netmaskEdit.setValue(String.valueOf(s));
            this.updateMaskLabel();
            this.defRouterTF.setText(InetUtil.makeDottedString(iIpConfig.getDefaultRouter()));
        }
    }

    public void setComponentsEnabled(boolean bl) {
        this.ipAddrLB.setEnabled(bl);
        this.ipAddrTF.setEnabled(bl);
        this.defRouterLB.setEnabled(bl);
        this.defRouterTF.setEnabled(bl);
        this.netmaskLB.setEnabled(bl);
        this.netmaskEdit.setEnabled(bl);
        this.maskLB.setEnabled(bl);
    }
}

