/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IIpAddr;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.ISecureIpConfig;
import cerent.cms.model.IpConfig;
import cerent.cms.model.IpConfigError;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProxyXlator;
import cerent.cms.model.SecureIpConfig;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.WizardDialog;
import cerent.cms.ui.shelf.ScdIntroPane;
import cerent.cms.ui.shelf.ScdIpAddrPane;
import cerent.cms.ui.shelf.ScdIpSelectionPane;
import cerent.cms.ui.shelf.ScdProxySettingPane;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.DialogCache;
import cerent.util.gui.MultiLineLabelUI;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.plaf.LabelUI;

public class SecurityConfigDialog
extends WizardDialog {
    protected ScdIntroPane introPane;
    protected ScdIpAddrPane nodeIpAddrPane;
    protected ScdIpAddrPane secureIpAddrPane;
    protected ScdProxySettingPane proxySettingPane;
    protected ScdIpSelectionPane ipSelectionPane;
    public static final int VIGN_WIDTH = 175;
    public static final int HEIGHT = 325;
    public static final int WIDTH = 550;
    public String NODE_IP_PAGE;
    public String BACKPLANE_IP;
    public static final String NODE_IP_SELECTION = "Node IP Address";
    public String NODE_IP_DISPLAY;
    public String SECURE_IP_DISPLAY;
    public String IP_SELECT_DISPLAY;
    public static final String PROXY_SECURE_DISPLAY = "Proxy server and firewall must be enabled for the secure mode.\n";
    public static final String PROXY_DISPLAY = " If needed, change the proxy server settings, or click finish.\n";
    private JLabel nodeIpLbl;
    private JLabel secureIpLbl;
    private JLabel ipSelectLbl;
    private JLabel proxyLbl;
    protected static NodeModelDelegate nodeModel;
    protected IIpConfig nodeIpConfig;
    protected ISecureIpConfig secureIpConfig;
    protected IIpAddr nodeIpAddr;
    protected int nodeNetmask;
    protected boolean isSecureModeSelected;
    protected boolean isNodeSecureMode;
    private TDMTerminology terms;
    private static SDebug db;

    public static SecurityConfigDialog instance(JComponent jComponent, String string, boolean bl) {
        Frame frame = JOptionPane.getFrameForComponent(jComponent);
        SecurityConfigDialog securityConfigDialog = (SecurityConfigDialog)DialogCache.getRecycledDialog((Window)frame, (Class)SecurityConfigDialog.class);
        nodeModel = (NodeModelDelegate)((AbstractPane)((Object)jComponent)).getUiModel().getNodeModel();
        if (db.on()) {
            db.println(" Security Config dialog IsSecureMode: " + bl);
        }
        if (securityConfigDialog == null) {
            securityConfigDialog = new SecurityConfigDialog(frame, string, bl);
        } else {
            securityConfigDialog.reset();
            securityConfigDialog.setConfig(nodeModel);
            securityConfigDialog.setSelectedMode(bl);
            securityConfigDialog.setSize(new Dimension(550, 325));
            securityConfigDialog.createPanes();
            securityConfigDialog.setLocationRelativeTo(frame);
        }
        return securityConfigDialog;
    }

    private SecurityConfigDialog(Frame frame, String string, boolean bl) {
        super(frame, string, true, true);
        this.nodeIpLbl = new JLabel(this.NODE_IP_DISPLAY);
        this.proxyLbl = new JLabel();
        this.isSecureModeSelected = bl;
        this.terms = nodeModel.getTDMTerminology();
        this.reset();
        this.setConfig(nodeModel);
        this.setSize(new Dimension(550, 325));
        this.createPanes();
        this.setLocationRelativeTo(frame);
    }

    private void createPanes() {
        if (db.on()) {
            db.println(" createPanes() called, mode: " + this.isSecureModeSelected);
        }
        this.addStatusPanel(new WizardDialog.StatusPanel(this, "/images/CTC_dialogVignette.gif", new Dimension(175, 325)));
        this.introPane = new ScdIntroPane(" ", this, this.isSecureModeSelected, this.terms);
        this.addPage(this.introPane);
        String string = this.getControlCardName();
        this.NODE_IP_PAGE = string + " Ethernet Port";
        this.NODE_IP_DISPLAY = "Enter the new node IP address.\nThis IP address will be assigned to the " + string + " Ethernet Port.\n";
        this.BACKPLANE_IP = this.terms.getBackplaneTerm(true);
        String string2 = this.terms.getBackplaneTerm(false);
        this.SECURE_IP_DISPLAY = "If needed, edit the " + string2 + " LAN port IP address, \n" + "or click next to proceed\n";
        this.IP_SELECT_DISPLAY = "Choose the node IP address. This address will be \nassigned to the " + string2 + " LAN port and " + string + " Ethernet port.";
        this.ipSelectLbl = new JLabel(this.IP_SELECT_DISPLAY);
        this.secureIpLbl = new JLabel(this.SECURE_IP_DISPLAY);
        if (this.isSecureModeSelected) {
            this.secureIpLbl.setUI((LabelUI)new MultiLineLabelUI());
            this.nodeIpLbl.setUI((LabelUI)new MultiLineLabelUI());
            this.nodeIpAddrPane = new ScdIpAddrPane(this.NODE_IP_PAGE, this, true, this.nodeIpLbl);
            this.addPage(this.nodeIpAddrPane);
            this.secureIpAddrPane = new ScdIpAddrPane(this.BACKPLANE_IP, this, false, this.secureIpLbl);
            this.addPage(this.secureIpAddrPane);
            this.proxyLbl.setText("Proxy server and firewall must be enabled for the secure mode.\n If needed, change the proxy server settings, or click finish.\n");
        } else {
            this.ipSelectLbl.setUI((LabelUI)new MultiLineLabelUI());
            this.ipSelectionPane = new ScdIpSelectionPane(NODE_IP_SELECTION, this, this.ipSelectLbl, this.terms);
            this.addPage(this.ipSelectionPane);
            this.proxyLbl.setText(PROXY_DISPLAY);
        }
        this.proxyLbl.setUI((LabelUI)new MultiLineLabelUI());
        this.proxySettingPane = new ScdProxySettingPane("Proxy Server Settings", this, this.proxyLbl, this.isSecureModeSelected);
        this.addPage(this.proxySettingPane);
    }

    private void setSelectedMode(boolean bl) {
        this.isSecureModeSelected = bl;
    }

    private void setConfig(NodeModelDelegate nodeModelDelegate) {
        this.nodeIpConfig = nodeModelDelegate.getIpConfig();
        this.secureIpConfig = nodeModelDelegate.getSecureIpConfig();
        this.isNodeSecureMode = this.secureIpConfig.isSecureMode();
    }

    public void apply() throws Exception {
        short s;
        if (db.on()) {
            db.println("apply: start");
        }
        IpConfig ipConfig = (IpConfig)nodeModel.getIpConfig();
        SecureIpConfig secureIpConfig = (SecureIpConfig)nodeModel.getSecureIpConfig();
        secureIpConfig.setMode(this.isSecureModeSelected);
        IIpAddr iIpAddr = null;
        IIpAddr iIpAddr2 = null;
        if (this.isSecureModeSelected) {
            iIpAddr = this.nodeIpAddrPane.getIpAddr();
            iIpAddr2 = this.secureIpAddrPane.getDefaultRouterAddr();
            s = this.nodeIpAddrPane.getMask();
            if (db.on()) {
                db.println("Node Ip Address: " + InetUtil.makeDottedString(iIpAddr));
                db.println("Node Mask: " + s);
            }
            secureIpConfig.setIpAddress(this.secureIpAddrPane.getIpAddr());
            secureIpConfig.setNetMaskPrefixLength(this.secureIpAddrPane.getMask());
            if (db.on()) {
                db.println("Secure Ip Address: " + InetUtil.makeDottedString(this.secureIpAddrPane.getIpAddr()));
                db.println("Secure Mask: " + this.secureIpAddrPane.getMask());
            }
        } else {
            iIpAddr = this.ipSelectionPane.getIpAddr();
            s = this.ipSelectionPane.getMask();
            iIpAddr2 = this.ipSelectionPane.getDefRouterAddr();
        }
        ipConfig.setIpAddress(iIpAddr);
        ipConfig.setDefaultRouter(iIpAddr2);
        ipConfig.setNetMaskPrefixLength(s);
        if (this.proxySettingPane.getCurrentNodeProxyProfile() != this.proxySettingPane.getUserProxyProfile()) {
            ProxyXlator.setProxy(nodeModel, this.proxySettingPane.getUserProxyProfile());
        }
        nodeModel.setSecureIpConfig(ipConfig, secureIpConfig);
        if (db.on()) {
            db.println("applyChangesToModel: end");
        }
    }

    public NodeModelDelegate getNodeModel() {
        return nodeModel;
    }

    public boolean isNodeSecureMode() {
        return this.isNodeSecureMode;
    }

    public boolean isSecureModeSelected() {
        return this.isSecureModeSelected;
    }

    public IIpConfig getIpConfig() {
        return this.nodeIpConfig;
    }

    public ISecureIpConfig getSecureIpConfig() {
        return this.secureIpConfig;
    }

    public String getControlCardName() {
        return nodeModel.getPlatform().getControlCardName();
    }

    public void reset() {
        if (SecurityConfigDialog.db.on) {
            db.println("reset() called");
        }
        if (this.getStatusPanel() != null) {
            this.getStatusPanel().reset();
        }
        this.setFinishEnabled(false);
        super.reset();
    }

    public void showPage(String string, boolean bl) {
        this.setSize(new Dimension(550, 325));
        super.showPage(string, bl);
    }

    protected void validateConfig(String string) throws IpConfigError {
        IIpAddr iIpAddr = null;
        String string2 = this.getControlCardName();
        if (string == this.NODE_IP_PAGE) {
            this.setNodeIpAddr(this.nodeIpAddrPane.getIpAddr());
            this.setNodeNetmask(InetUtil.makeNetMask(this.nodeIpAddrPane.getMask()));
            InetUtil.validateConfig(this.nodeIpAddr, null, this.nodeNetmask, string2 + " LAN port");
        } else if (string == this.BACKPLANE_IP) {
            IIpAddr iIpAddr2 = this.secureIpAddrPane.getIpAddr();
            int n = InetUtil.makeNetMask(this.secureIpAddrPane.getMask());
            iIpAddr = this.secureIpAddrPane.getDefaultRouterAddr();
            InetUtil.validateConfig(iIpAddr2, iIpAddr, n, "BackPlane LAN port");
            InetUtil.checkForSameSubnet(iIpAddr2, n, this.nodeIpAddr, this.nodeNetmask);
        } else if (string == NODE_IP_SELECTION) {
            this.setNodeIpAddr(this.ipSelectionPane.getIpAddr());
            this.setNodeNetmask(InetUtil.makeNetMask(this.ipSelectionPane.getMask()));
            iIpAddr = this.ipSelectionPane.getDefRouterAddr();
            InetUtil.validateConfig(this.nodeIpAddr, iIpAddr, this.nodeNetmask, "Node IP");
        }
    }

    public void setNodeIpAddr(IIpAddr iIpAddr) {
        this.nodeIpAddr = iIpAddr;
    }

    public void setNodeNetmask(int n) {
        this.nodeNetmask = n;
    }

    static {
        db = new SDebug("SecurityConfigDialog");
    }
}

