/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.model.AdminState;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.InvalidState;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PimModel;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SlotModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ObserverProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.shelf.CardBehavior;
import cerent.cms.ui.shelf.ShelfInventoryColumnRenderer;
import cerent.cms.ui.shelf.ShelfInventoryDataSource;
import cerent.cms.ui.shelf.ShelfInventoryModel;
import cerent.cms.ui.shelf.ShelfInventoryRowObject;
import cerent.cms.ui.shelf.ShelfTabbedView;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;

public class ShelfInventoryPane
extends ObserverProvPane
implements CellEditorListener,
ActionListener,
ListSelectionListener,
TableModelListener,
KeyListener {
    private ShelfInventoryRowObject selectedItem;
    protected ShelfInventoryModel model;
    private JButton resetCardButton;
    private JButton hardResetCardButton;
    private JButton softResetCardButton;
    private JButton deleteCardButton;
    private static ColumnRenderer[] colRenderers = ShelfInventoryColumnRenderer.createColumnRenderers();
    protected static final SDebug db = new SDebug((KDebug)ShelfTabbedView.db, "ShelfInventoryPane");
    protected CardBehavior cardBehavior;
    private ShelfInventoryDataSource dataSource;
    private boolean hasInventoryUserCode;
    private IPlatform pci;
    private NodeModelDelegate nmd;

    public ShelfInventoryPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        Serializable serializable;
        AdminState[] adminStateArray;
        TableColumn tableColumn;
        IChassisModel iChassisModel;
        if (this.getUiModel() instanceof IChassisModel) {
            iChassisModel = (IChassisModel)this.getUiModel();
            this.nmd = (NodeModelDelegate)iChassisModel.getNodeModel();
            this.dataSource = new ShelfInventoryDataSource(this.nmd, iChassisModel);
        } else {
            this.nmd = (NodeModelDelegate)this.getUiModel().getNodeModel();
            this.dataSource = new ShelfInventoryDataSource(this.nmd);
        }
        this.pci = this.nmd.getPlatform();
        this.cardBehavior = this.pci.getCardBehavior(this.nmd, db);
        this.hasInventoryUserCode = this.pci.hasInventoryUserCode();
        this.setDataSourceControl(this.dataSource);
        this.model = new ShelfInventoryModel((RowDataSource)this.dataSource, colRenderers, ShelfInventoryRowObject.class, this.nmd);
        this.model.addTableModelListener(this);
        this.table = new JTable((TableModel)((Object)this.model)){

            public TableCellEditor getCellEditor(int n, int n2) {
                ShelfInventoryPane.this.selectedItem = (ShelfInventoryRowObject)ShelfInventoryPane.this.model.getValueAt(n, n2);
                if (null == ShelfInventoryPane.this.selectedItem) {
                    db.config("selectedItem NULL during getCellEditor call");
                }
                return super.getCellEditor(n, n2);
            }
        };
        iChassisModel = new UScrollPane((Component)this.table, 20, 30);
        this.model.initTable(this.table);
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setUpdateTableInRealTime(false);
        if (this.hasInventoryUserCode) {
            tableColumn = this.table.getColumn("User Code");
            adminStateArray = new JTextField();
            adminStateArray.addKeyListener(this);
            serializable = new InventoryTableCellEditor((JTextField)adminStateArray);
            ((AbstractCellEditor)serializable).addCellEditorListener(this);
            tableColumn.setCellEditor((TableCellEditor)((Object)serializable));
        } else {
            tableColumn = this.table.getColumn("User Code");
            adminStateArray = this.table.getColumnModel();
            adminStateArray.removeColumn(tableColumn);
        }
        tableColumn = this.table.getColumn(ShelfInventoryColumnRenderer.columnNames[2]);
        adminStateArray = AdminState.getEquipmentAdminStates(AdminState.isANSI(this.nmd.getFramingType()));
        serializable = new JComboBox<AdminState>(adminStateArray);
        ((JComboBox)serializable).setEditable(false);
        tableColumn.setCellEditor(new DefaultCellEditor((JComboBox<?>)serializable));
        tableColumn.setPreferredWidth(tableColumn.getWidth());
        this.table.sizeColumnsToFit(-1);
        this.table.getSelectionModel().setSelectionMode(0);
        this.add((Component)((Object)iChassisModel), "Center");
        this.table.sizeColumnsToFit(-1);
        this.table.getSelectionModel().setSelectionMode(0);
        this.add((Component)((Object)iChassisModel), "Center");
        if (this.isUserAuthorized(SecurityLevel.MAINTENANCE)) {
            this.add(this.getSouthPanel(), "South");
            this.table.getSelectionModel().addListSelectionListener(this);
        }
    }

    private JPanel getSouthPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 5));
        this.deleteCardButton = this.makeActionButton("Delete Card", SecurityLevel.PROVISIONING);
        this.resetCardButton = this.makeActionButton("Reset Card", SecurityLevel.MAINTENANCE);
        this.hardResetCardButton = this.makeActionButton("Hard-reset Card", SecurityLevel.MAINTENANCE);
        this.softResetCardButton = this.makeActionButton("Soft-reset Card", SecurityLevel.MAINTENANCE);
        jPanel.add(this.deleteCardButton);
        jPanel.add(this.resetCardButton);
        jPanel.add(this.hardResetCardButton);
        jPanel.add(this.softResetCardButton);
        return jPanel;
    }

    private JButton makeActionButton(String string, SecurityLevel securityLevel) {
        JButton jButton = new JButton(string);
        if (this.isUserAuthorized(securityLevel)) {
            jButton.addActionListener(this);
        } else {
            jButton.setEnabled(false);
        }
        return jButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object == this.deleteCardButton) {
            if (this.cardBehavior.deleteCard((Component)((Object)this), this.selectedItem.entity)) {
                this.table.clearSelection();
            }
        } else if (string == "Reset Card") {
            this.cardBehavior.resetCard((Component)((Object)this), (ModuleModel)this.selectedItem.entity);
        } else if (string == "Hard-reset Card") {
            if (this.selectedItem.entity instanceof PimModel) {
                this.cardBehavior.hardResetPim((Component)((Object)this), (PimModel)this.selectedItem.entity);
            } else {
                this.cardBehavior.hardResetCard((Component)((Object)this), (ModuleModel)this.selectedItem.entity);
            }
        } else if (string == "Soft-reset Card") {
            this.cardBehavior.softResetCard((Component)((Object)this), (ModuleModel)this.selectedItem.entity);
        }
    }

    protected void displayErrorDialog(Pane pane, Exception exception, EID eID) {
        if (exception instanceof InvalidState) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ADMIN_STATE_CANNOT_BE_APPLIED);
        } else {
            super.displayErrorDialog(pane, exception, eID);
        }
    }

    private void toggleButtons() {
        boolean bl = this.selectionIsCard();
        boolean bl2 = this.selectionIsPpm();
        if (this.showOldResetCardButton()) {
            this.resetCardButton.setVisible(true);
            this.hardResetCardButton.setVisible(false);
            this.softResetCardButton.setVisible(false);
        } else {
            this.resetCardButton.setVisible(false);
            this.hardResetCardButton.setVisible(true);
            this.softResetCardButton.setVisible(true);
        }
        if (this.selectedItem != null && (bl || bl2)) {
            if (bl2) {
                this.deleteCardButton.setText("Delete PPM");
            } else {
                this.deleteCardButton.setText("Delete Card");
            }
            PluggableModel pluggableModel = (PluggableModel)this.selectedItem.entity;
            this.deleteCardButton.setEnabled(this.isUserAuthorized(SecurityLevel.PROVISIONING) && pluggableModel.isDeletable());
            if (this.resetCardButton.isVisible() && pluggableModel.isResettable()) {
                this.resetCardButton.setEnabled(this.isUserAuthorized(SecurityLevel.MAINTENANCE));
            } else {
                this.resetCardButton.setEnabled(false);
            }
            if (pluggableModel.isHardResettable()) {
                this.hardResetCardButton.setEnabled(this.isUserAuthorized(SecurityLevel.MAINTENANCE));
            } else {
                this.hardResetCardButton.setEnabled(false);
            }
            if (this.softResetCardButton.isVisible() && pluggableModel.isSoftResettable()) {
                this.softResetCardButton.setEnabled(this.isUserAuthorized(SecurityLevel.MAINTENANCE));
            } else {
                this.softResetCardButton.setEnabled(false);
            }
        } else {
            this.deleteCardButton.setText("Delete Card");
            this.deleteCardButton.setEnabled(false);
            this.resetCardButton.setEnabled(false);
            this.hardResetCardButton.setEnabled(false);
            this.softResetCardButton.setEnabled(false);
        }
    }

    private boolean showOldResetCardButton() {
        int n = -1;
        if (this.selectedItem != null && this.selectedItem.entity instanceof PluggableModel) {
            PluggableModel pluggableModel = (PluggableModel)this.selectedItem.entity;
            n = pluggableModel.getEqType();
        }
        return CardBehavior.supportsGenericResetCard(this.pci, n);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.table.getSelectedRow();
        final JTable jTable = this.table;
        if (n >= 0) {
            this.selectedItem = (ShelfInventoryRowObject)this.model.getValueAt(n, 0);
            if (ShelfInventoryPane.db.on) {
                db.println("valueChanged: selectedItem.entity = " + this.selectedItem.entity);
            }
        } else {
            this.selectedItem = null;
            if (ShelfInventoryPane.db.on) {
                db.println("valueChanged: = null");
            }
        }
        this.toggleButtons();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Component component;
                int n = jTable.getSelectedRow();
                if (n < 0) {
                    return;
                }
                int n2 = jTable.getSelectedColumn();
                if (n2 < 0) {
                    return;
                }
                if (jTable.editCellAt(n, n2) && (component = jTable.getEditorComponent()) != null) {
                    component.requestFocus();
                    if (component instanceof JTextField) {
                        ((JTextField)component).selectAll();
                    }
                }
            }
        });
    }

    private boolean selectionIsCard() {
        PluggableModel pluggableModel;
        int n;
        boolean bl;
        boolean bl2;
        block3: {
            bl2 = this.selectedItem != null && this.selectedItem.entity instanceof PluggableModel && !(this.selectedItem.entity instanceof PpmModel);
            bl = true;
            try {
                bl = Model.getFramingType(this.nmd).isSdh();
            }
            catch (AnnotatedException annotatedException) {
                db.println("Caught exception in selectionIsCard!");
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)annotatedException);
            }
        }
        if (bl && bl2 && ((n = ((SlotModel)(pluggableModel = (PluggableModel)this.selectedItem.entity).getParent()).getEqType()) == 78 || n == 79 || n == 80)) {
            bl2 = false;
        }
        return bl2;
    }

    private boolean selectionIsPpm() {
        return this.selectedItem != null && this.selectedItem.entity instanceof PpmModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("enteringPage: calling super ...");
        }
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            super.enteringPage();
            if (db.on()) {
                db.println("refreshing button states ...");
            }
            if (this.deleteCardButton != null) {
                this.valueChanged(null);
            }
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
            if (this.dataSource != null) {
                this.dataSource.refreshFromModel();
            }
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.selectedItem = null;
        super.destroy();
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataSource != null && this.dataSource.isDirty()) {
            this.setDirty();
        }
        this.cancelTableCellEditing();
    }

    public void keyTyped(KeyEvent keyEvent) {
        JTextField jTextField;
        Object object = keyEvent.getSource();
        if (object instanceof JTextField && (jTextField = (JTextField)object).getText().length() >= 20) {
            try {
                Toolkit.getDefaultToolkit().beep();
                jTextField.setCaretPosition(jTextField.getSelectionStart());
                jTextField.setText(jTextField.getText(0, 19));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void editingCanceled(ChangeEvent changeEvent) {
    }

    public void editingStopped(ChangeEvent changeEvent) {
        db.fine("editingStopped invoked: " + changeEvent.getSource());
        this.setDirty();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.ShelfInventoryPane;
    }

    class InventoryTableCellEditor
    extends DefaultCellEditor {
        private JTextField editor;

        public InventoryTableCellEditor(JTextField jTextField) {
            super(jTextField);
            this.editor = jTextField;
            this.editor.setColumns(20);
            this.setClickCountToStart(1);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ShelfInventoryRowObject shelfInventoryRowObject = (ShelfInventoryRowObject)object;
            if (shelfInventoryRowObject == null) {
                this.editor.setText("<null info>");
                return this.editor;
            }
            this.editor.setText(shelfInventoryRowObject.mfgData.userCode);
            return this.editor;
        }
    }
}

