/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.ElementEventStore;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.MainTabbedView;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.event.NodeAlarmPane;
import cerent.cms.ui.event.NodeConditionsPane;
import cerent.cms.ui.event.NodeHistoryPane;
import cerent.cms.ui.event.ShelfAlarmPane;
import cerent.cms.ui.event.ShelfConditionsPane;
import cerent.cms.ui.shelf.ShelfInventoryPane;
import cerent.util.EID;
import cerent.util.SDebug;
import java.awt.Component;

public class ShelfTabbedView
extends MainTabbedView
implements ITabName {
    private IEventPanelController myController;
    private IGuestPaneFactory gpf;
    private IPlatform pci;
    protected static final SDebug db = new SDebug("ShelfTabbedView");

    public Pane getAlarmTab() {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.uiModel.getNodeModel();
        ElementAlarmStore elementAlarmStore = (ElementAlarmStore)((ChassisModel)this.uiModel).getShelfAlarmStore();
        if (nodeModelDelegate.isMultishelf()) {
            return new ShelfAlarmPane("Alarms", nodeModelDelegate, (TabbedView)this, elementAlarmStore, this.myController);
        }
        return new NodeAlarmPane("Alarms", nodeModelDelegate, (TabbedView)this, elementAlarmStore, this.myController);
    }

    public Pane getEventTab() {
        ElementEventStore elementEventStore = (ElementEventStore)((ChassisModel)this.uiModel).getShelfEventStore();
        return new NodeHistoryPane("History", this, elementEventStore, this.myController);
    }

    public Pane getCircuitTab() {
        return (Pane)this.gpf.getGuestPane(1, (TabbedView)this);
    }

    public ShelfTabbedView(IChassisModel iChassisModel, IEventPanelController iEventPanelController, IGuestPaneFactory iGuestPaneFactory) {
        super((IModel)iChassisModel);
        this.myController = iEventPanelController;
        this.gpf = iGuestPaneFactory;
        this.pci = iChassisModel.getPlatform();
        this.addTab("Alarms", (Component)this.getAlarmTab());
        this.addTab("Conditions", (Component)this.getConditionsTab());
        this.addTab("History", (Component)this.getEventTab());
        this.addTab("Circuits", (Component)this.getCircuitTab());
        this.addTab("Provisioning", (Component)this.getProvisioningTab());
        this.addTab("Inventory", (Component)this.getInventoryTab());
        this.addTab("Maintenance", (Component)this.getMaintenanceTab());
    }

    public Pane getProvisioningTab() {
        return this.pci.getShelfProvPane("Provisioning", this, this.gpf);
    }

    public Pane getInventoryTab() {
        return new ShelfInventoryPane("Inventory", this);
    }

    public Pane getMaintenanceTab() {
        return this.pci.getShelfMaintenancePane("Maintenance", this);
    }

    public Pane getConditionsTab() {
        IChassisModel iChassisModel = (IChassisModel)this.uiModel;
        if (iChassisModel.isMultishelf()) {
            return new ShelfConditionsPane("Conditions", iChassisModel, this, this.myController);
        }
        return new NodeConditionsPane("Conditions", iChassisModel.getNodeModelDelegate(), this, this.myController);
    }

    public void destroy() {
        this.myController = null;
        this.gpf = null;
        super.destroy();
    }

    public void displayErrorDialog(TabbedView tabbedView, Exception exception, EID eID) {
    }
}

