/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IpConfig;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecureIpConfig;
import cerent.cms.ui.VitalStatsPane;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import java.text.DateFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class ShelfVitalStatsPane
extends VitalStatsPane
implements Observer {
    private EventDispatcher dispatcher;
    private IChassisModel chassis;
    private NodeModelDelegate nodeM;
    private List slots;
    private HashSet cards = new HashSet();
    private String[] apcStatusLabels = new String[]{"APC state : Not Applicable - Network Type\n", "APC state : Enable\n", "APC state : Disable - Internal\n", "APC state : Disable - User\n"};
    private boolean isApcSite = false;
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
    private static final SDebug db = new SDebug("ShelfVitalStatsPane");

    public ShelfVitalStatsPane(IChassisModel iChassisModel) {
        super(iChassisModel.getShelfAlarmStore());
        this.chassis = iChassisModel;
        this.nodeM = (NodeModelDelegate)iChassisModel.getNodeModel();
        this.isApcSite = iChassisModel.getPlatform().supportsDWDM();
        if (this.isApcSite) {
            this.dispatcher = iChassisModel.getDispatcher();
            if (this.dispatcher != null) {
                this.dispatcher.addObserver(ObjectType.ObjectDwdmOpticalSetup, 2, (Observer)this);
            }
        }
        if (this.nodeM.isMultishelf()) {
            EntityModel entityModel = (EntityModel)iChassisModel.getChildren().get(0);
            this.slots = entityModel.getChildren();
            Iterator iterator = this.slots.iterator();
            while (iterator.hasNext()) {
                EntityModel entityModel2 = (EntityModel)iterator.next();
                entityModel2.addObserver(this);
            }
        } else {
            this.nodeM.addObserver(this);
        }
        this.updateTextArea(null);
    }

    public void update(Observable observable, Object object) {
        this.updateTextArea(object);
        if (this.cards.contains(observable) && object == ModelUpdateType.DELETED) {
            observable.deleteObserver(this);
            this.cards.remove(observable);
        }
    }

    private void updateTextArea(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = "";
        String string9 = null;
        if (!this.nodeM.isMultishelf()) {
            if (object != ModelUpdateType.DELETED) {
                string = this.nodeM.getName();
                if (string == null) {
                    string = "unknown node";
                }
                string2 = this.getNodeIpAddr();
                if (this.nodeM.getPlatform().isSecureModeSupported() && this.nodeM.isSecureMode()) {
                    string3 = this.getSecureIpAddr();
                }
                string4 = this.nodeM.getUserName();
                string5 = ElementDefaults.securityLevelToString(this.nodeM.getSecurityLevel());
                try {
                    string6 = this.nodeM.getSwVersion();
                }
                catch (Exception exception) {
                    db.fine("Exception received when getting node sw version");
                }
                try {
                    string7 = this.nodeM.getDefaultsDescription();
                }
                catch (Exception exception) {
                    db.fine("Exception received when getting defaults description: " + exception);
                }
                try {
                    string9 = dateFormat.format(this.nodeM.getBootTime());
                }
                catch (Exception exception) {
                    db.fine("Exception received when getting boot time: " + exception);
                }
                if (this.isApcSite && (this.nodeM.getNodeType() == 2 || this.nodeM.getNodeType() == 1)) {
                    try {
                        int n = this.nodeM.getDwdmOpticalSetupModel().getApcState();
                        if (n != 0) {
                            string8 = this.apcStatusLabels[n];
                        }
                    }
                    catch (Exception exception) {
                        db.fine("Caught " + exception);
                    }
                }
            }
            if (string2 == null) {
                string2 = "unavailable";
            }
            if (string3 == null) {
                string3 = "unavailable";
            }
            if (string4 == null) {
                string4 = "unavailable";
            }
            if (string5 == null) {
                string5 = "unavailable";
            }
            if (string6 == null) {
                string6 = "unavailable";
            }
            if (string7 == null) {
                string7 = "unavailable";
            }
            if (string9 == null) {
                string9 = "unknown";
            }
            boolean bl = false;
            if (this.nodeM != null) {
                if (this.nodeM.getPlatform().isSecureModeSupported() && this.nodeM.isSecureMode() && this.nodeM.allowIpDisplayed(false)) {
                    if (this.nodeM.allowIpDisplayed(true)) {
                        stringBuffer.append("IP Addr          : ").append(string2).append('\n');
                    }
                    stringBuffer.append("Backplane IP Addr: ").append(string3).append('\n');
                    bl = true;
                } else if (this.nodeM.allowIpDisplayed(true)) {
                    stringBuffer.append("IP Addr   : ").append(string2).append('\n');
                }
            }
            if (bl) {
                stringBuffer.append("Booted           : ").append(string9).append('\n').append("User             : ").append(string4).append('\n').append("Authority        : ").append(string5).append('\n').append("SW Version       : ").append(string6).append('\n').append("Defaults         : ").append(string7).append('\n').append(string8);
            } else {
                stringBuffer.append("Booted    : ").append(string9).append('\n').append("User      : ").append(string4).append('\n').append("Authority : ").append(string5).append('\n').append("SW Version: ").append(string6).append('\n').append("Defaults  : ").append(string7).append('\n').append(string8);
            }
        } else {
            string = this.nodeM.getName() + ", Shelf " + this.chassis.getShelfId();
            if (string == null) {
                string = "Unknown, Shelf " + this.chassis.getShelfId();
            }
            Iterator iterator = this.slots.iterator();
            while (iterator.hasNext()) {
                EntityModel entityModel = (EntityModel)iterator.next();
                if (entityModel.getChildren().size() != 1) continue;
                EntityModel entityModel2 = (EntityModel)entityModel.getChildren().get(0);
                int n = entityModel.getSlot();
                stringBuffer.append("\nSlot " + (n < 10 ? " " : "") + Integer.toString(n) + ": " + entityModel2.getEqTypeName());
                entityModel2.addObserver(this);
                this.cards.add(entityModel2);
            }
        }
        this.setTitle(string);
        this.setText(stringBuffer.toString());
    }

    private String getSecureIpAddr() {
        SecureIpConfig secureIpConfig;
        String string = null;
        if (this.nodeM != null && (secureIpConfig = (SecureIpConfig)this.nodeM.getSecureIpConfig()) != null) {
            string = InetUtil.makeDottedString(secureIpConfig.getIpAddress());
        }
        return string;
    }

    private String getNodeIpAddr() {
        String string = null;
        if (this.nodeM != null) {
            IpConfig ipConfig = (IpConfig)this.nodeM.getIpConfig();
            string = InetUtil.makeDottedString(ipConfig.getIpAddress());
        }
        return string;
    }

    public void dispose() {
        EntityModel entityModel;
        Iterator iterator;
        if (this.slots != null) {
            iterator = this.slots.iterator();
            while (iterator.hasNext()) {
                entityModel = (EntityModel)iterator.next();
                entityModel.deleteObserver(this);
            }
            this.slots = null;
        }
        if (this.cards != null) {
            iterator = this.cards.iterator();
            while (iterator.hasNext()) {
                entityModel = (EntityModel)iterator.next();
                entityModel.deleteObserver(this);
            }
            this.cards = null;
        }
        if (this.nodeM != null) {
            this.nodeM.deleteObserver(this);
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectDwdmOpticalSetup, 2, (Observer)this);
        }
        super.dispose();
    }
}

