/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Alarm.sAlarmMessage;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.event.ElementEventStore;
import cerent.cms.model.event.EventInfo;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.event.EventPanel;
import cerent.cms.ui.event.FilterDialog;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;

public class SmpAlarmLogPane
extends AbstractPane
implements ActionListener,
PropertyChangeListener {
    private static final String TT_RETRIEVE = "<html>Retrieve all current conditions from node(s)</html>";
    private static final String TT_FILTER = "<html>Show Alarm Filter<P>Allows filtering of conditions</html>";
    private JToggleButton filterIndicator;
    private JButton filterButton;
    private JButton getButton;
    private EventPanel histPanel;
    private ElementEventStore store;
    private JCheckBox alarmCB;
    private JCheckBox eventCB;
    private NodeModelDelegate nodeModel;
    private int slot;
    private int shelf;
    private JLabel retrievalTime;
    private IEventPanelController controller;
    private final ImageIcon FILTER_ENABLE_IMG = new ImageIcon(this.getClass().getResource("/images/icons/Toolbar-Filter.gif"));
    private final ImageIcon FILTER_DISABLE_IMG = new ImageIcon(this.getClass().getResource("/images/icons/Toolbar-Filter-Gray.gif"));
    private static final SDebug db = new SDebug("SmpAlarmLogPane");
    private static final String[] DEF_HIDECOL = new String[]{"Num", "Ref"};

    public SmpAlarmLogPane(String string, TabbedView tabbedView, IEventPanelController iEventPanelController) {
        super(string, tabbedView);
        this.controller = iEventPanelController;
        this.setDefaultPrivilegeLevel(SecurityLevel.RETRIEVE);
        TablePropertyMgr.getColumnPrefs(this.getTable(), this.getClass().getName());
    }

    private void init() {
        Serializable serializable;
        if (db.on()) {
            db.println("init: start");
        }
        IModel iModel = this.getUiModel();
        int n = 17;
        if (iModel instanceof NodeModelDelegate) {
            this.nodeModel = (NodeModelDelegate)iModel;
            this.slot = 0;
            this.shelf = 0;
        } else if (iModel instanceof IChassisModel) {
            this.nodeModel = (NodeModelDelegate)iModel.getNodeModel();
            n |= 0x400;
            this.slot = 0;
            this.shelf = ((IChassisModel)iModel).getShelfId();
        } else if (iModel instanceof ModuleModel) {
            serializable = (ModuleModel)iModel;
            this.nodeModel = ((EntityModel)serializable).getNodeModelDelegate();
            this.slot = ((EntityModel)serializable).getSlot();
            this.shelf = ((EntityModel)serializable).getChassis().getShelfId();
            n |= 0x408;
            if (!this.nodeModel.getPlatform().isEqTypeShown()) {
                n |= 4;
            }
        }
        this.setLayout(new BorderLayout());
        this.store = new ElementEventStore(this.nodeModel, "AlarmLog");
        this.histPanel = new EventPanel((RowDataSource)this.store, this.controller, n);
        this.add(this.histPanel, "Center");
        serializable = new JPanel(new BorderLayout(0, 0));
        this.add((Component)serializable, "South");
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        this.getButton = new JButton("Retrieve");
        this.enableComponent(this.getButton);
        this.getButton.addActionListener(this);
        jPanel.add(this.getButton);
        this.filterButton = new JButton("Filter...");
        this.enableComponent(this.filterButton);
        this.filterButton.addActionListener(this);
        jPanel.add(this.filterButton);
        this.alarmCB = new JCheckBox("Alarms", true);
        this.enableComponent(this.alarmCB);
        jPanel.add(this.alarmCB);
        this.eventCB = new JCheckBox("Events", false);
        this.enableComponent(this.eventCB);
        jPanel.add(this.eventCB);
        this.filterIndicator = new JToggleButton(this.FILTER_DISABLE_IMG);
        this.filterIndicator.setSelectedIcon(this.FILTER_ENABLE_IMG);
        this.filterIndicator.setFocusPainted(false);
        this.filterIndicator.setPreferredSize(new Dimension(27, 25));
        this.filterIndicator.addActionListener(this);
        this.getButton.setToolTipText(TT_RETRIEVE);
        this.filterButton.setToolTipText(TT_FILTER);
        this.filterIndicator.setToolTipText("Turn on/off alarm filter");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 5, 5));
        this.retrievalTime = new JLabel();
        this.retrievalTime.setHorizontalAlignment(0);
        jPanel2.add(this.retrievalTime);
        jPanel2.add(this.filterIndicator);
        jPanel2.add(new CSHelpButton(CSHelpConst.HistoryPane));
        ((Container)serializable).add(jPanel, "West");
        ((Container)serializable).add(jPanel2, "East");
        int n2 = this.getTable().getColumn("Date").getModelIndex();
        int[] nArray = new int[]{n2};
        boolean[] blArray = new boolean[nArray.length];
        if (this.histPanel.getModel() instanceof SortableRowTableModel) {
            ((SortableRowTableModel)((Object)this.histPanel.getModel())).setDefaultColSetting(nArray, blArray, DEF_HIDECOL);
        }
        this.store.getEventFilter().addObserver((Observer)((Object)this));
        this.store.getEventFilter().setType(3);
        Preferences.instance().addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected void showFilterDialog() {
        try {
            INodeModel[] iNodeModelArray = new INodeModel[1];
            IModel iModel = this.getUiModel();
            if (iModel instanceof NodeModelDelegate) {
                iNodeModelArray[0] = (NodeModelDelegate)iModel;
            } else if (iModel instanceof IChassisModel) {
                iNodeModelArray[0] = (NodeModelDelegate)iModel.getNodeModel();
            } else if (iModel instanceof ModuleModel) {
                ModuleModel moduleModel = (ModuleModel)iModel;
                iNodeModelArray[0] = moduleModel.getNodeModelDelegate();
            }
            this.store.getEventFilter().setNodeModel(iNodeModelArray);
            new FilterDialog(this, this.store.getEventFilter(), "History Filter").show();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private void setFilterActive(boolean bl) {
        if (this.store.getEventFilter().isEnabled()) {
            this.store.getEventFilter().setActive(bl);
            this.store.setFilterActive(bl);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.isShowing() && (string.equals("useNeTimeZone") || string.equals("dateFormat"))) {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        try {
            this.setCursor(3);
            if (this.nodeModel != null && object == this.getButton) {
                sAlarmMessage[] sAlarmMessageArray = this.nodeModel.getAlarmHistory();
                if (sAlarmMessageArray != null) {
                    ArrayList arrayList = new ArrayList();
                    EventDispatcher eventDispatcher = this.nodeModel.getDispatcher();
                    eventDispatcher.convertAlarmsToEventInfo(arrayList, sAlarmMessageArray, System.currentTimeMillis(), this.eventCB.isSelected(), this.alarmCB.isSelected(), this.eventCB.isSelected(), true, false);
                    this.store.flushStore();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        EventInfo eventInfo = (EventInfo)arrayList.get(i);
                        if (this.shelf != 0 && (this.slot != 0 || eventInfo.getShelfId() != this.shelf) && (eventInfo.getShelfId() != this.shelf || eventInfo.getSlot() != this.slot)) continue;
                        this.store.storeEvent(eventInfo);
                    }
                    this.retrievalTime.setText("Retrieved: " + SmpAlarmLogPane.getFormattedDateTime());
                    this.store.updateView();
                }
            } else if (object == this.filterButton) {
                this.showFilterDialog();
            } else if (object == this.filterIndicator) {
                this.setFilterActive(this.filterIndicator.isSelected());
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_COMMUNICATION_ERROR_PARAM_1, (Object)exception.getMessage());
        }
        finally {
            this.setCursor(0);
        }
    }

    public JTable getTable() {
        JTable jTable = null;
        if (this.histPanel != null) {
            jTable = this.histPanel.getTable();
        }
        return jTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.store == null && this.histPanel == null) {
                this.init();
            }
            TablePropertyMgr.getColumnPrefs(this.getTable(), this.getClass().getName());
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
        this.store.getEventFilter().refreshCriteria();
        TablePropertyMgr.getColumnPrefs(this.getTable(), this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
    }

    public void update(Observable observable, Object object) {
        if (this.filterIndicator != null && object instanceof Boolean) {
            this.filterIndicator.setSelected((Boolean)object);
        }
        super.update(observable, object);
    }

    public void refresh() {
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        if (this.histPanel != null && this.store != null) {
            this.filterButton.removeActionListener(this);
            this.filterIndicator.removeActionListener(this);
            this.filterButton = null;
            this.filterIndicator = null;
            this.histPanel.dispose();
            this.histPanel = null;
            this.store.getEventFilter().deleteObserver((Observer)((Object)this));
            this.store.destroy();
            this.store = null;
        }
        Preferences.instance().removePropertyChangeListener((PropertyChangeListener)this);
        super.destroy();
    }
}

