/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.model.AuditTrail;
import cerent.cms.model.AuditTrailArchiveJob;
import cerent.cms.model.ISecurityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.Operation;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.event.AuditStore;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.event.AuditPanel;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UFileChooser;
import cerent.util.gui.UTable;
import cerent.util.gui.row.RowDataSource;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobListener;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobProgressDialog;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class SmpAuditPane
extends AbstractPane
implements ActionListener,
IJobListener,
PropertyChangeListener {
    private boolean inited;
    public static final String ARCHIVED_LABEL = "Archived: ";
    private JButton retrieveB;
    private JButton archiveB;
    private JLabel getLabel;
    private AuditPanel auditPanel;
    private AuditStore auditStore;
    private int minSequenceNumber;
    private static File dir;
    private JobProgressDialog progressDlg;
    private NodeModelDelegate nodeModel;
    private ISecurityModel secModel;
    private static final SDebug db;
    private final int MAX_CMS_AUDIT_EVENTS;

    public SmpAuditPane(String string, TabbedView tabbedView, IPlatform iPlatform) {
        super(string, tabbedView);
        dir = null;
        this.progressDlg = null;
        this.inited = false;
        this.MAX_CMS_AUDIT_EVENTS = iPlatform.getMaxCmsAuditEvents();
    }

    private void init() {
        this.inited = true;
        if (db.on()) {
            db.println("init: start");
        }
        this.nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
        this.secModel = this.nodeModel.getSecurityModel();
        this.minSequenceNumber = 0;
        this.setLayout(new BorderLayout());
        this.auditStore = new AuditStore("Audit");
        this.auditPanel = new AuditPanel((RowDataSource)this.auditStore);
        this.add(this.auditPanel, "Center");
        this.table = this.auditPanel.getTable();
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.SmpAuditPane);
        this.retrieveB = new JButton("Retrieve");
        this.archiveB = new JButton("Archive");
        this.getLabel = new JLabel("");
        cSHelpButtonPane.addLeft(this.retrieveB);
        cSHelpButtonPane.addLeft(this.archiveB);
        this.enableOperationButton(this.retrieveB, Operation.RETRIEVE_AUDIT);
        this.retrieveB.addActionListener(this);
        if (this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            this.archiveB.addActionListener(this);
        } else {
            this.archiveB.setEnabled(false);
        }
        cSHelpButtonPane.addRight(this.getLabel);
        this.add(cSHelpButtonPane, "South");
        if (this.secModel != null) {
            this.secModel.addObserver((Observer)((Object)this));
        }
        if (db.on()) {
            db.println("init: finish");
        }
    }

    protected void enableOperationButton(JComponent jComponent, Operation operation) {
        if (this.nodeModel.isInited() && this.secModel != null) {
            SecurityLevel securityLevel = this.secModel.getOperationPrivilege(operation);
            this.enableComponent(jComponent, this.nodeModel, securityLevel);
            ((UTable)this.table).setExportable(jComponent.isEnabled());
        }
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: start");
        }
        this.requestRefresh(this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (db.on()) {
            db.println("actionPerformed " + actionEvent);
        }
        Object object = actionEvent.getSource();
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        try {
            if (object == this.retrieveB) {
                int n;
                AuditTrail[] auditTrailArray;
                if (this.uiToolkit != null) {
                    this.uiToolkit.setCursor(3);
                }
                int n2 = (auditTrailArray = nodeModelDelegate.getAuditTrailList(this.minSequenceNumber)) != null ? auditTrailArray.length : 0;
                int n3 = n = this.auditStore != null ? this.auditStore.size() : 0;
                if (n2 + n > this.MAX_CMS_AUDIT_EVENTS) {
                    if (this.minSequenceNumber > 0 || n > 0) {
                        this.auditStore.dispose();
                        this.minSequenceNumber = 0;
                        this.actionPerformed(actionEvent);
                    }
                    return;
                }
                int n4 = 0;
                if (n2 - n4 > this.MAX_CMS_AUDIT_EVENTS - n) {
                    n4 = n2 - (this.MAX_CMS_AUDIT_EVENTS - n);
                }
                if (n4 < n2) {
                    for (int i = 0; i < n2; ++i) {
                        this.auditStore.storeEvent(auditTrailArray[i]);
                    }
                    this.minSequenceNumber = auditTrailArray[n2 - 1].getSequenceNumber() + 1;
                    this.auditStore.updateView();
                }
                this.getLabel.setText("Retrieved: " + SmpAuditPane.getFormattedDateTime());
            } else if (object == this.archiveB) {
                if (this.uiToolkit != null) {
                    this.uiToolkit.setCursor(3);
                }
                this.getTargetFileAndSpawnArchiveJob();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_COMMUNICATION_ERROR_PARAM_1, (Object)exception.getMessage());
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    public JTable getTable() {
        if (db.on()) {
            db.println("getTable");
        }
        JTable jTable = null;
        if (this.auditPanel != null) {
            jTable = this.auditPanel.getTable();
        }
        return jTable;
    }

    public void enteringPage() {
        if (db.on()) {
            db.println("enteringPage");
        }
        if (!this.inited) {
            this.init();
        }
        Preferences.instance().addPropertyChangeListener((PropertyChangeListener)this);
        if (this.table != null) {
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
    }

    public void leavingPage() throws Exception {
        if (db.on()) {
            db.println("leavingPage");
        }
        Preferences.instance().removePropertyChangeListener((PropertyChangeListener)this);
        if (this.table != null) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("dateFormat")) {
            this.repaint();
        }
    }

    public void refresh() {
        this.enableOperationButton(this.retrieveB, Operation.RETRIEVE_AUDIT);
    }

    public void destroy() {
        if (db.on()) {
            db.println("destroy");
        }
        if (this.table != null) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        if (this.retrieveB != null) {
            this.retrieveB.removeActionListener(this);
        }
        if (this.archiveB != null) {
            this.archiveB.removeActionListener(this);
        }
        if (this.auditPanel != null) {
            this.auditPanel.dispose();
        }
        if (this.auditStore != null) {
            this.auditStore.dispose();
        }
        if (this.secModel != null) {
            this.secModel.deleteObserver((Observer)((Object)this));
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTargetFileAndSpawnArchiveJob() {
        UFileChooser uFileChooser = new UFileChooser();
        uFileChooser.setDialogTitle("Archive Audit Trail");
        try {
            if (dir != null) {
                uFileChooser.setCurrentDirectory(dir);
            }
            if (uFileChooser.showSaveDialog((Component)((Object)this)) != 0) {
                return;
            }
            dir = uFileChooser.getCurrentDirectory();
            String string = uFileChooser.getName(uFileChooser.getSelectedFile());
            File file = new File(dir.getAbsolutePath(), string);
            String string2 = file.getAbsolutePath();
            if (db.on()) {
                db.println("archiveFile.exists(): " + file.exists());
                db.println("archiveFile.isFile(): " + file.isFile());
                db.println("archiveFile.canWrite(): " + file.canWrite());
            }
            if (file.exists()) {
                if (!file.isFile()) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NOT_NORMAL_FILE_PARAM_1, (Object)string2);
                    return;
                }
                if (!file.canWrite()) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NOT_WRITEABLE_FILE_PARAM_1, (Object)string2);
                    return;
                }
                if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("The file " + string2 + " already exists.\nDo you want to replace it?"), (String)"Archive Audit Trail")) {
                    return;
                }
            }
            this.archiveAuditTrail(string2);
        }
        finally {
            uFileChooser.dispose();
        }
    }

    private void archiveAuditTrail(String string) {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        this.progressDlg = new JobProgressDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), "Archive Audit Trail", "Archiving audit trail...", false, true);
        JobController jobController = JobControllerFactory.createJC((int)1);
        AuditTrailArchiveJob auditTrailArchiveJob = new AuditTrailArchiveJob(nodeModelDelegate, string, (IJobProgressControl)this.progressDlg);
        this.progressDlg.setJob((IJobControl)auditTrailArchiveJob);
        this.progressDlg.setProgressText(nodeModelDelegate.getName() + ": Archiving audit trail ...");
        jobController.submitJob(new JobGroup((IJobControl)auditTrailArchiveJob, (IJobListener)this, (Object)jobController));
    }

    public void jobWaiting(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobRunning(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobFinished(JobGroup jobGroup, IJobControl iJobControl, final JobStatus jobStatus, final Object object) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SmpAuditPane.this.finishJob(jobStatus, (JobController)object);
            }
        });
    }

    private void finishJob(JobStatus jobStatus, JobController jobController) {
        String string = this.progressDlg.getTitle();
        this.progressDlg.dispose();
        this.progressDlg = null;
        if (jobStatus.value() == 3) {
            CerentDialog.infoDialog((Component)((Object)this), (String)(string + " aborted"), (String)string);
        } else if (jobStatus.value() == 2) {
            Exception exception = (Exception)jobStatus.getResult();
            if (exception != null) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_JOB_FAIL_EXCEPTION_PARAM_1, (Object)exception.toString());
            }
        } else {
            CerentDialog.infoDialog((Component)((Object)this), (String)(string + " complete"), (String)string);
            this.getLabel.setText(ARCHIVED_LABEL + SmpAuditPane.getFormattedDateTime());
        }
        if (jobController != null && jobController.isIdle()) {
            JobControllerFactory.disposeJC((JobController)jobController);
        }
    }

    static {
        db = new SDebug((KDebug)AbstractShelfMaintenancePane.db, "SmpAuditPane");
    }
}

