/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.EtherBridgeModel;
import cerent.cms.model.EtherPmStatsSeries;
import cerent.cms.model.IChassisModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ether.EtherStatsTableModel;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.TransmitReceive;
import cerent.util.gui.TransmitReceivePercentCellRenderer;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SmpEtherStatsPane
extends AbstractPane
implements ActionListener,
PropertyChangeListener {
    private int[] widths = new int[]{100, 50, 120};
    private JButton retrieveButton;
    private JLabel retrievalTime;
    private UComboBox seriesCB;
    private EtherStatsTableModel dataModel;
    private EtherPmStatsSeries[] etherPmStatsSeriesList;
    private IChassisModel chassis;
    private JTable table2;
    private JViewport rowHeader;
    private static final SDebug db = new SDebug((KDebug)AbstractShelfMaintenancePane.db, "SmpEtherStatsPane");

    public SmpEtherStatsPane(String string, TabbedView tabbedView, IChassisModel iChassisModel) {
        super(string, tabbedView);
        this.chassis = iChassisModel;
        this.etherPmStatsSeriesList = new EtherPmStatsSeries[0];
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    private void init() {
        if (db.on()) {
            db.println("init: start");
        }
        this.setLayout(new BorderLayout());
        this.dataModel = new EtherStatsTableModel(this, this.chassis);
        this.table = new UTable((TableModel)this.dataModel);
        this.table.getTableHeader().setUpdateTableInRealTime(true);
        this.table.setDefaultRenderer(TransmitReceive.class, new TransmitReceivePercentCellRenderer());
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table2 = new UTable((TableModel)this.dataModel);
        ((UTable)this.table2).setExportable(false);
        this.table2.getTableHeader().setUpdateTableInRealTime(false);
        this.table2.setDefaultRenderer(TransmitReceive.class, new TransmitReceivePercentCellRenderer());
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        this.table.setRowHeight(new JTextArea().getPreferredSize().height * 2 + 1);
        this.table2.setRowHeight(new JTextArea().getPreferredSize().height * 2 + 1);
        for (int i = 0; i < this.widths.length; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(0);
            tableColumnModel.removeColumn(tableColumn);
            tableColumn.setPreferredWidth(this.widths[i]);
            tableColumn.setResizable(true);
            tableColumn.setMinWidth(this.widths[i]);
            if (i == 2) {
                tableColumn.addPropertyChangeListener(this);
            }
            defaultTableColumnModel.addColumn(tableColumn);
        }
        this.table.setColumnModel(tableColumnModel);
        this.table2.setColumnModel(defaultTableColumnModel);
        this.table2.setPreferredScrollableViewportSize(this.table2.getPreferredSize());
        this.table2.getTableHeader().setReorderingAllowed(false);
        this.table2.setAutoCreateColumnsFromModel(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(false);
        this.table2.setCellSelectionEnabled(false);
        this.table2.setRowSelectionAllowed(false);
        uScrollPane.setRowHeaderView((Component)this.table2);
        this.rowHeader = uScrollPane.getRowHeader();
        uScrollPane.setCorner("UPPER_LEFT_CORNER", (Component)this.table2.getTableHeader());
        JPanel jPanel = SmpEtherStatsPane.createVerticalPanel(null);
        uScrollPane.setAlignmentX(0.0f);
        jPanel.add((Component)uScrollPane);
        this.add(jPanel, "Center");
        this.add(this.makeControlPanel(), "South");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Dimension dimension = this.table2.getPreferredSize();
        this.table2.setPreferredScrollableViewportSize(dimension);
        int n = (int)dimension.getWidth();
        Dimension dimension2 = this.rowHeader.getPreferredSize();
        dimension2 = new Dimension(n, (int)dimension2.getHeight());
        this.rowHeader.setPreferredSize(dimension2);
    }

    public void fixedUpColumn() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < 3; ++i) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        this.table.repaint();
    }

    private JPanel makeControlPanel() {
        this.etherPmStatsSeriesList = ((EtherBridgeModel)this.chassis.getEtherBridgeModel()).getEtherPmModel().getEtherPmStatsSeries();
        this.seriesCB = new UComboBox(this.statsSeriesToVector(this.etherPmStatsSeriesList));
        if (this.etherPmStatsSeriesList.length > 0) {
            this.seriesCB.setSelectedIndex(0);
            this.dataModel.refreshCols(this.etherPmStatsSeriesList[this.seriesCB.getSelectedIndex()]);
        }
        this.retrieveButton = new JButton("Refresh");
        this.retrieveButton.addActionListener(this);
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.SmpEtherStatsPane);
        cSHelpButtonPane.addLeft(new JLabel("Interval:"));
        cSHelpButtonPane.addLeft((Component)this.seriesCB);
        cSHelpButtonPane.addLeft(this.retrieveButton);
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.retrievalTime = new JLabel("Refreshed (never)");
        jPanel.add(this.retrievalTime);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)cSHelpButtonPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    private Vector statsSeriesToVector(EtherPmStatsSeries[] etherPmStatsSeriesArray) {
        Vector<String> vector = new Vector<String>();
        if (etherPmStatsSeriesArray != null) {
            for (int i = 0; i < etherPmStatsSeriesArray.length; ++i) {
                vector.add(etherPmStatsSeriesArray[i].getSeriesDescription());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.retrieveButton) {
            try {
                this.setCursor(3);
                if (this.seriesCB.getSelectedIndex() != -1) {
                    EtherPmStatsSeries etherPmStatsSeries = this.etherPmStatsSeriesList[this.seriesCB.getSelectedIndex()];
                    this.dataModel.refresh(etherPmStatsSeries);
                    String string = this.dataModel.getLastIntervalTimeStamp();
                    if (string.length() > 0) {
                        this.retrievalTime.setText("The " + etherPmStatsSeries.getSeriesDescription() + " interval labeled \"PREV\" ended " + string);
                    }
                }
            }
            catch (Exception exception) {
                db.println("Caught exception in SmpEtherStatsPane.actionPerformed: " + exception);
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_STATS);
            }
            finally {
                this.setCursor(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.dataModel == null) {
                this.init();
            }
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    public void leavingPage() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    public void refresh() {
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }
}

