/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.SonetTopology.eTestAccessMode;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.HoTapModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.LoDefModel;
import cerent.cms.model.LoTapModel;
import cerent.cms.model.TapModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.shelf.SmpTestAccessPane;
import cerent.util.EnumStrings;
import cerent.util.HoLoHelper;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;

class SmpTestAccessRowObject {
    static final String[] modeStrings = EnumStrings.getStrings((Class)eTestAccessMode.class);
    static final EntityCellRenderer renderer = new EntityCellRenderer();
    int framingType;
    String tapNumber;
    String tapMode;
    String type;
    String tapA;
    String tapB;
    String pathE;
    String pathF;
    private static final SDebug db = new SDebug((KDebug)SmpTestAccessPane.db, "SmpTestAccessRowObject");

    public SmpTestAccessRowObject(TapModel tapModel) {
        INodeModel iNodeModel = tapModel.getNodeModel();
        this.framingType = iNodeModel.getFramingType();
        TDMTerminology tDMTerminology = iNodeModel.getTDMTerminology();
        this.tapNumber = Short.toString(tapModel.getTapNumber());
        this.tapMode = modeStrings[tapModel.getTapMode().value()];
        if (tapModel instanceof HoTapModel) {
            this.type = tDMTerminology.getGeneralTerms(0);
            HoTapModel hoTapModel = (HoTapModel)tapModel;
            this.tapA = this.getHoString(hoTapModel.getTapA());
            this.tapB = this.getHoString(hoTapModel.getTapB());
            this.pathE = this.getHoString(hoTapModel.getPathE());
            this.pathF = this.getHoString(hoTapModel.getPathF());
        } else {
            this.type = tDMTerminology.getGeneralTerms(1);
            LoTapModel loTapModel = (LoTapModel)tapModel;
            this.tapA = this.getLoString(loTapModel.getTapA());
            this.tapB = this.getLoString(loTapModel.getTapB());
            this.pathE = this.getLoString(loTapModel.getPathE());
            this.pathF = this.getLoString(loTapModel.getPathF());
        }
    }

    private String getHoString(IHoPathDefModel iHoPathDefModel) {
        if (iHoPathDefModel == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            IEntityModel iEntityModel = iHoPathDefModel.getPool().getEntityModel();
            int n = iEntityModel.getSlot();
            stringBuffer.append('s');
            stringBuffer.append(n);
            if (iEntityModel instanceof IPortModel) {
                stringBuffer.append("/p");
                stringBuffer.append(renderer.getPortString(iEntityModel, false, true));
            }
            if (this.framingType == 0) {
                if (iEntityModel instanceof IPortModel && ((IPortModel)iEntityModel).isOptical() && ((IPortModel)iEntityModel).getMediumType() == 0) {
                    stringBuffer.append("/vc3-");
                } else {
                    stringBuffer.append("/S");
                }
            } else {
                stringBuffer.append("/vc4-");
            }
            IHoNum iHoNum = iHoPathDefModel.getStartingHo();
            stringBuffer.append(LoDefModel.physicalHo(iHoPathDefModel));
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            stringBuffer.append("<error>");
        }
        return stringBuffer.toString();
    }

    private String getLoString(ILoDefModel iLoDefModel) {
        if (iLoDefModel == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHoString(iLoDefModel.getLoAdit().getHo()));
        ILoNum iLoNum = iLoDefModel.getLoNum();
        if (this.framingType == 0) {
            stringBuffer.append("/V");
            stringBuffer.append(iLoNum.groupString());
        } else {
            stringBuffer.append("/");
            stringBuffer.append(HoLoHelper.getDisplay(iLoNum, "/", true));
        }
        return stringBuffer.toString();
    }

    private String getTapType(HoTapModel hoTapModel) {
        short s = CircuitSize.getCircuitSize((int)hoTapModel.getTapA().getPathWidth()).size2widthOfHoCircuit();
        return ElementDefaults.getAttributeMap((IModel)hoTapModel.getNodeModel()).getAttributeForVal(ElementDefaults.CIRCUIT_SIZE_STRING, (int)s).getKey();
    }
}

