/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SmpTimingReportPane
extends AbstractPane
implements ActionListener,
Runnable {
    private JButton resetB = null;
    private SynchronizationModel syncModel = null;
    private SyncReport syncReport;
    private static final SDebug db = new SDebug("SmpTimingReportPane");

    public SmpTimingReportPane(String string, TabbedView tabbedView, SynchronizationModel synchronizationModel) {
        super(string, tabbedView);
        this.syncModel = synchronizationModel;
        if (synchronizationModel == null) {
            db.severe("Synchronization Model is null");
            return;
        }
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.resetB = new JButton("Refresh");
        this.resetB.addActionListener(this);
        this.add(this.createSyncReport());
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.SmpTimingReportPane);
        cSHelpButtonPane.addLeft(this.resetB);
        this.add(cSHelpButtonPane, "South");
    }

    private JPanel createSyncReport() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.syncReport = new SyncReport();
        UScrollPane uScrollPane = new UScrollPane((Component)this.syncReport);
        jPanel.add((Component)uScrollPane, "Center");
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.resetB) {
            this.refresh();
        }
    }

    public void enteringPage() {
        this.requestRefresh(this, null);
    }

    public void leavingPage() {
    }

    public void run() {
        this.resetB.setEnabled(true);
    }

    public void refresh() {
        this.resetB.setEnabled(false);
        this.syncReport.refresh();
        SwingUtilities.invokeLater(this);
    }

    public String getHtmlReport() {
        return this.syncReport.getHtmlSyncReport();
    }

    private class SyncReport
    extends JEditorPane {
        private String htmlSyncReport;

        SyncReport() {
            super("text/html", "<html><center>Uninitialized</center></html>");
            this.setEditable(false);
        }

        private void refresh() {
            db.info("SyncReport.refresh()");
            try {
                this.htmlSyncReport = SmpTimingReportPane.this.syncModel.getSyncReport();
            }
            catch (NoSuchEquipment noSuchEquipment) {
                db.println("Caught unexpected exception in refresh!");
                if (db.on()) {
                    db;
                    SDebug.printStackTrace((Throwable)noSuchEquipment);
                }
                this.htmlSyncReport = null;
            }
            if (this.htmlSyncReport == null) {
                db.severe("No sync report available!");
                this.htmlSyncReport = "<html>Unavailable</html>";
            }
            db.fine(this.htmlSyncReport);
            this.setText(this.htmlSyncReport);
            this.setCaretPosition(0);
        }

        private String getHtmlSyncReport() {
            return this.htmlSyncReport;
        }
    }
}

