/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Node.sSnmpTrapDestination;
import cerent.cms.model.AlreadyInUse;
import cerent.cms.model.ConfigError;
import cerent.cms.model.InvalidData;
import cerent.cms.model.MaxSnmpDestinations;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.shelf.SnmpAttrsPane;
import cerent.cms.ui.shelf.SppSnmpPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Iterator;

public class SnmpCreatePane
extends SnmpAttrsPane {
    private static final SDebug snmpCreateDb = new SDebug((KDebug)SppSnmpPane.db, "SnmpCreatePane");

    public SnmpCreatePane(SppSnmpPane sppSnmpPane) {
        super(snmpCreateDb, "CreatePane", sppSnmpPane);
        this.setComponentsEnabled(true);
    }

    public boolean hasSubTabs() {
        return true;
    }

    public void apply() throws InvalidData, AlreadyInUse, MaxSnmpDestinations, ConfigError {
        this.validateFields();
        this.applyChangesToModel();
    }

    public void applyChangesToModel() throws AlreadyInUse, MaxSnmpDestinations, ConfigError {
        NodeModelDelegate nodeModelDelegate = this.parent.getNMD();
        if (nodeModelDelegate != null) {
            Iterator iterator = nodeModelDelegate.getSnmpTrapDestinations().iterator();
            while (iterator.hasNext()) {
                sSnmpTrapDestination sSnmpTrapDestination2 = (sSnmpTrapDestination)iterator.next();
                if (!Arrays.equals(this.ipAddr.addr, sSnmpTrapDestination2.ipAddress.addr)) continue;
                throw new AlreadyInUse("IP address must not match another trap receiver's IP address");
            }
            nodeModelDelegate.setSnmpTrapDestination(new sSnmpTrapDestination(this.ipAddr, this.commName, (short)this.udpPort, this.version, this.trapRate, this.relayIpAddr, this.relayCommName));
        }
    }

    protected boolean hasProxyPanel() {
        return this.parent.getNMD().getPlatform().isSnmpProxyCapable() && this.parent.getNMD().allowSnmpProxy() && this.isUserAuthorized(SecurityLevel.SUPERUSER);
    }
}

