/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eQualityLevel;
import cerent.cms.idl.Ds123Media.eLineCoding;
import cerent.cms.idl.Ds123Media.eLineType;
import cerent.cms.idl.Ds123Media.eSaBit;
import cerent.cms.idl.Synchronization.eBits;
import cerent.cms.idl.Synchronization.eBitsLBO;
import cerent.cms.idl.Synchronization.eCableType;
import cerent.cms.idl.Synchronization.sBitsConfig;
import cerent.cms.model.Attribute;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractBitsProvPane;
import cerent.cms.ui.shelf.AbstractSppTimingBitsPane;
import cerent.util.SONETTDMTerminology;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;

public class SonetBitsProvPane
extends AbstractBitsProvPane {
    private static final String[] bitsInChoices = new String[]{"DS1", "64Khz+8Khz"};
    private static final String[] bitsOutChoices = new String[]{"DS1", "6Mhz"};
    private static final String[] codingChoices = new String[]{"B8ZS", "AMI"};
    private static final String[] framingChoices = new String[]{"SF (D4)", "ESF", NA};
    private static final String[] lboChoices = new String[]{"0-133 ft", "134-266 ft", "267-399 ft", "400-533 ft", "534-655 ft"};
    protected static final String[] stateChoices = new String[]{SONETTDMTerminology.instance().getTermForPrimaryState(1), SONETTDMTerminology.instance().getTermForPrimaryState(0)};
    private SynchronizationModel syncModel;

    public SonetBitsProvPane(String string, TabbedView tabbedView, AbstractSppTimingBitsPane abstractSppTimingBitsPane, eBits eBits2, SynchronizationModel synchronizationModel) {
        super(string, tabbedView, abstractSppTimingBitsPane, eBits2);
        this.syncModel = synchronizationModel;
    }

    protected String[] getStateChoices() {
        return stateChoices;
    }

    private eAdminState getAdminStateFromSelection(int n) {
        return n == 0 ? eAdminState.ADMIN_OOS_DSBLD : eAdminState.ADMIN_IS;
    }

    private eLineCoding getCodingFromSelection(int n) {
        return n == 0 ? eLineCoding.B8ZS : eLineCoding.AMI;
    }

    private eLineType getFramingFromSelection(int n) {
        eLineType eLineType2 = eLineType.LINETYPE_NOT_APPLICABLE;
        if (n == 0) {
            eLineType2 = eLineType.D4;
        } else if (n == 1) {
            eLineType2 = eLineType.ESF;
        }
        return eLineType2;
    }

    private int getFramingIndex(eLineType eLineType2) {
        switch (eLineType2.value()) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 15: {
                return 2;
            }
        }
        db.println("Invalid framing type " + eLineType2.value());
        return 0;
    }

    public String[] getFacilityChoices(int n) {
        if (n == 0) {
            return bitsInChoices;
        }
        return bitsOutChoices;
    }

    protected String[] getCodingChoices() {
        return codingChoices;
    }

    protected String[] getFramingChoices() {
        return framingChoices;
    }

    public Attribute[] getQualityChoices() {
        return attrMap.getAttributeArray("timingSonetSsmQuality");
    }

    private Attribute getQualityAttribute(int n) {
        return attrMap.getAttributeForVal("timingSonetSsmQuality", n);
    }

    public JComboBox createBitsOutLBO() {
        this.lboCB = new JComboBox<String>(lboChoices);
        this.lboCB.setName("LBO");
        this.lboCB.addActionListener(this);
        this.enableComponent(this.lboCB);
        return this.lboCB;
    }

    public void updateBitsInValues() {
        if (this.parent.isBits64K(0)) {
            this.codingBitsInCB.setSelectedIndex(1);
        }
        super.updateBitsInValues();
    }

    public void updateBitsOutValues() {
        if (this.parent.isBits64K(1)) {
            this.codingBitsOutCB.setSelectedIndex(1);
        }
        super.updateBitsOutValues();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
    }

    public void applyChangesToModel() throws Exception {
        sBitsConfig sBitsConfig2 = new sBitsConfig();
        if (db.on()) {
            db.println("enter SBPP.applyChangesToModel");
        }
        sBitsConfig2.facilityType = this.parent.getFacilityTypeSelection(this.parent.getBitsInFacilityType());
        sBitsConfig2.adminState = this.getAdminStateFromSelection(this.stateBitsInCB.getSelectedIndex());
        sBitsConfig2.coding = this.getCodingFromSelection(this.codingBitsInCB.getSelectedIndex());
        sBitsConfig2.framing = this.getFramingFromSelection(this.framingBitsInCB.getSelectedIndex());
        sBitsConfig2.syncMessageIn = this.ssmEnabledBitsInCB.isSelected();
        sBitsConfig2.assumedQuality = this.pci.showAdminSSM() ? this.getQualitySelection((Attribute)this.adminSsmBitsInCB.getSelectedItem()) : eQualityLevel.STU;
        sBitsConfig2.facilityTypeBitsOut = this.parent.getFacilityTypeSelection(this.parent.getBitsOutFacilityType());
        if (this.pci.isBitsOutStateProvisionable()) {
            sBitsConfig2.adminStateBitsOut = this.getAdminStateFromSelection(this.stateBitsOutCB.getSelectedIndex());
        }
        sBitsConfig2.codingBitsOut = this.getCodingFromSelection(this.codingBitsOutCB.getSelectedIndex());
        sBitsConfig2.framingBitsOut = this.getFramingFromSelection(this.framingBitsOutCB.getSelectedIndex());
        sBitsConfig2.aisThreshold = this.pci.isAISThresholdProvisionable() ? this.getQualitySelection((Attribute)this.qualityCB.getSelectedItem()) : eQualityLevel.STU;
        sBitsConfig2.bitsLBO = eBitsLBO.from_int(this.lboCB.getSelectedIndex());
        sBitsConfig2.saBit = eSaBit.SA_NONE;
        sBitsConfig2.cableSelection = eCableType.PAUSE_100_OHM;
        this.dumpData(sBitsConfig2);
        this.syncModel.setBitsConfig(this.bitsPort, sBitsConfig2);
        if (db.on()) {
            db.println("leave SBPP.applyChangesToModel");
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("enter SBPP.refreshFromModel (bitsPort=" + this.bitsPort.value() + ")");
        }
        sBitsConfig sBitsConfig2 = null;
        sBitsConfig2 = this.syncModel.getBitsConfig(this.bitsPort);
        this.dumpData(sBitsConfig2);
        this.stateBitsInCB.setSelectedIndex(this.getAdminStateIndex(sBitsConfig2.adminState));
        this.codingBitsInCB.setSelectedIndex(this.getCodingIndex(sBitsConfig2.coding));
        this.framingBitsInCB.setSelectedIndex(this.getFramingIndex(sBitsConfig2.framing));
        this.ssmEnabledBitsInCB.setSelected(sBitsConfig2.syncMessageIn);
        if (this.pci.showAdminSSM()) {
            this.adminSsmBitsInCB.setSelectedItem(this.getQualityAttribute(sBitsConfig2.assumedQuality.value()));
        }
        if (this.pci.isBitsOutStateProvisionable()) {
            this.stateBitsOutCB.setSelectedIndex(this.getAdminStateIndex(sBitsConfig2.adminStateBitsOut));
        }
        this.framingBitsOutCB.setSelectedIndex(this.getFramingIndex(sBitsConfig2.framingBitsOut));
        this.codingBitsOutCB.setSelectedIndex(this.getCodingIndex(sBitsConfig2.codingBitsOut));
        if (this.pci.isAISThresholdProvisionable()) {
            this.qualityCB.setSelectedItem(this.getQualityAttribute(sBitsConfig2.aisThreshold.value()));
        }
        if (this.pci.isAISThresholdProvisionable()) {
            this.qualityCB.setSelectedIndex(sBitsConfig2.aisThreshold.value());
        }
        this.lboCB.setSelectedIndex(sBitsConfig2.bitsLBO.value());
        this.enableBitsInComponents();
        this.enableBitsOutComponents();
        if (db.on()) {
            db.println("leave SBPP.refreshFromModel");
        }
    }

    protected boolean isSyncMsgFraming(int n) {
        if (n == 0) {
            return this.framingBitsInCB.getSelectedIndex() != 0;
        }
        return this.framingBitsOutCB.getSelectedIndex() != 0;
    }
}

