/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SpanCheckModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class SpanCheckTableModel
extends AbstractTableModel
implements Observer {
    protected boolean[][] isDirty = null;
    protected String[] sideVal = null;
    protected String[] expMinSpanLossVal = null;
    protected String[] expMaxSpanLossVal = null;
    protected String[] measSpanLossVal = null;
    protected String[] resolutionVal = null;
    public static final String[] columnNames = new String[]{"Side ", "Min Exp. Span Loss (dB)", "Max Exp. Span Loss (dB)", "Meas. Span Loss (dB)", "Resolution (dB)"};
    public static final int SIDE_INDEX = 0;
    public static final int EXP_MIN_SL_INDEX = 1;
    public static final int EXP_MAX_SL_INDEX = 2;
    public static final int MEAS_SL_INDEX = 3;
    public static final int RESOL_INDEX = 4;
    protected NodeModelDelegate model;
    protected EntityCellRenderer myPortRenderer;
    private static final SDebug db = new SDebug("SpanCheckTableModel");

    public SpanCheckTableModel(NodeModelDelegate nodeModelDelegate) {
        this.model = nodeModelDelegate;
        this.regNotify();
        this.init();
    }

    private ArrayList getLineModels() {
        return this.model.getSpanCheckModels().getSpanCheckModel();
    }

    private int getNumLines() {
        return this.getLineModels().size();
    }

    private void init() {
        this.myPortRenderer = new EntityCellRenderer(false);
        this.isDirty = new boolean[this.getRowCount()][this.getColumnCount()];
        this.sideVal = new String[this.getRowCount()];
        this.expMinSpanLossVal = new String[this.getRowCount()];
        this.expMaxSpanLossVal = new String[this.getRowCount()];
        this.measSpanLossVal = new String[this.getRowCount()];
        this.resolutionVal = new String[this.getRowCount()];
        this.resetDirtyBits();
    }

    private void regNotify() {
        this.model.getSpanCheckModels().addObserver(this);
    }

    private void unRegNotify() {
        this.model.getSpanCheckModels().deleteObserver(this);
    }

    String getSide(int n) {
        if (this.sideVal[n] == null) {
            this.sideVal[n] = ((SpanCheckModel)this.getLineModels().get(n)).getSide();
        }
        return this.sideVal[n];
    }

    String getMinExpectedSpanLoss(int n) {
        if (this.expMinSpanLossVal[n] == null) {
            this.expMinSpanLossVal[n] = ((SpanCheckModel)this.getLineModels().get(n)).getMinExpectedSpanLoss();
        }
        return this.expMinSpanLossVal[n];
    }

    String getMaxExpectedSpanLoss(int n) {
        if (this.expMaxSpanLossVal[n] == null) {
            this.expMaxSpanLossVal[n] = ((SpanCheckModel)this.getLineModels().get(n)).getMaxExpectedSpanLoss();
        }
        return this.expMaxSpanLossVal[n];
    }

    String getMeasuredSpanLoss(int n) {
        if (this.measSpanLossVal[n] == null) {
            this.measSpanLossVal[n] = ((SpanCheckModel)this.getLineModels().get(n)).getMeasuredSpanLoss();
        }
        return this.measSpanLossVal[n];
    }

    String getResolution(int n) {
        if (this.resolutionVal[n] == null) {
            this.resolutionVal[n] = ((SpanCheckModel)this.getLineModels().get(n)).getResolution();
        }
        return this.resolutionVal[n];
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 1: {
                if (this.expMinSpanLossVal[n] == (String)object) break;
                this.expMinSpanLossVal[n] = (String)object;
                break;
            }
            case 2: {
                if (this.expMaxSpanLossVal[n] == (String)object) break;
                this.expMaxSpanLossVal[n] = (String)object;
                break;
            }
            default: {
                return;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.getNumLines();
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public boolean isCellEditable(int n, int n2) {
        return this.model != null && this.getRowCount() > 0 && (n2 == 1 || n2 == 2);
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 1: {
                    return this.getMinExpectedSpanLoss(n);
                }
                case 2: {
                    return this.getMaxExpectedSpanLoss(n);
                }
                case 0: {
                    return this.getSide(n);
                }
                case 3: {
                    return this.getMeasuredSpanLoss(n);
                }
                case 4: {
                    return this.getResolution(n);
                }
            }
        }
        catch (Exception exception) {
            db.severe("Error in getting values " + exception);
        }
        return null;
    }

    private void resetLineCache(int n) {
        this.sideVal[n] = null;
        this.expMinSpanLossVal[n] = null;
        this.expMaxSpanLossVal[n] = null;
        this.measSpanLossVal[n] = null;
        this.resolutionVal[n] = null;
        this.resetDirtyBits();
    }

    public void refreshLineFromModel(int n) {
        db.fine("refreshing line " + n + " from model");
        this.resetLineCache(n);
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        db.fine("refreshing table from model");
        this.init();
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    public boolean isDirty() {
        int n = this.getColumnCount();
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < n; ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDirtyBits() {
        int n = this.getColumnCount();
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < n; ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.isDirty[i][1]) {
                ((SpanCheckModel)this.getLineModels().get(i)).setMinExpectedSpanLoss(this.expMinSpanLossVal[i]);
            }
            if (!this.isDirty[i][2]) continue;
            ((SpanCheckModel)this.getLineModels().get(i)).setMaxExpectedSpanLoss(this.expMaxSpanLossVal[i]);
        }
        this.refreshFromModel();
        this.resetDirtyBits();
    }

    public void update(Observable observable, Object object) {
        this.refreshFromModel();
    }
}

