/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OptLinkModel;
import cerent.cms.model.OpticalPatchCordModel;
import cerent.cms.model.ParserIfName;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ans.AnsConnDataSource;
import cerent.cms.ui.ans.AnsConnTableModel;
import cerent.cms.ui.ans.AnsPathCreateDialog;
import cerent.cms.ui.ans.OptLinkStats;
import cerent.util.AnnotatedException;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class SppAnsConnPane
extends AbstractPane
implements ActionListener,
ListSelectionListener {
    private static final SDebug db = new SDebug("SppOnsConnPane");
    private final ImageIcon FILTER_ENABLE_IMG = new ImageIcon(this.getClass().getResource("/images/icons/Toolbar-Filter.gif"));
    private final ImageIcon FILTER_DISABLE_IMG = new ImageIcon(this.getClass().getResource("/images/icons/Toolbar-Filter-Gray.gif"));
    private static final String CREATE = "Create...";
    private static final String DELETE = "Delete";
    private static final String COMMIT = "Commit";
    private static final String EDIT = "Edit...";
    private static final String CALC_CONN = "Default Patchcords";
    private JButton createButton = new JButton("Create...");
    private JButton editButton = new JButton("Edit...");
    private JButton deleteButton = new JButton("Delete");
    private JButton commButton = new JButton("Commit");
    private JButton calcConnButton = new JButton("Default Patchcords");
    private JComboBox filterCB;
    private ListCellRenderer connCellRend;
    private JToggleButton filterTButton;
    private AnsConnTableModel dataModel;
    private AnsConnDataSource dataSource;
    private boolean initialized = true;
    private int[] sortCols = new int[]{0, 1, 2};
    private boolean[] sortDir = new boolean[]{true, true, true};
    private TabbedView parent;
    private NodeModelDelegate nodeModel;
    private OpticalPatchCordModel optPatchModel;
    private OptLinkStats localFilterStat = OptLinkStats.LINK_UNDEFINED;

    public SppAnsConnPane(String string, TabbedView tabbedView, OpticalPatchCordModel opticalPatchCordModel) {
        super(string, tabbedView);
        this.parent = tabbedView;
        this.optPatchModel = opticalPatchCordModel;
    }

    private void init() {
        if (db.on()) {
            db.println("init");
        }
        this.setLayout(new BorderLayout());
        this.nodeModel = (NodeModelDelegate)this.optPatchModel.getNodeModel();
        this.dataSource = new AnsConnDataSource(this.optPatchModel);
        this.dataModel = new AnsConnTableModel(this.dataSource, this.sortCols, this.sortDir);
        this.table = new UTable((TableModel)((Object)this.dataModel));
        this.table.setSelectionMode(2);
        ((AnsConnTableModel)((Object)this.table.getModel())).initTable(this.table);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.add(this.makeControlPanel(), "South");
        this.add((Component)new UScrollPane((Component)this.table), "Center");
    }

    private JPanel makeControlPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 5));
        this.createButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.commButton.addActionListener(this);
        this.editButton.addActionListener(this);
        this.calcConnButton.addActionListener(this);
        jPanel2.add(this.createButton);
        jPanel2.add(this.editButton);
        jPanel2.add(this.deleteButton);
        jPanel2.add(this.commButton);
        jPanel2.add(this.calcConnButton);
        this.filterCB = new JComboBox<Object>(new Object[]{OptLinkStats.LINK_UNDEFINED, OptLinkStats.LINK_CONNECTED, OptLinkStats.LINK_UNCOMMITTED, OptLinkStats.LINK_FAIL});
        this.filterCB.addActionListener(this);
        this.enableComponent(this.filterCB, this.nodeModel, SecurityLevel.PROVISIONING);
        this.connCellRend = new ConnectionCellRenderer();
        this.filterCB.setRenderer(this.connCellRend);
        jPanel3.add(this.filterCB);
        this.filterTButton = new JToggleButton(this.FILTER_DISABLE_IMG);
        this.filterTButton.setSelectedIcon(this.FILTER_ENABLE_IMG);
        this.filterTButton.setFocusPainted(false);
        this.filterTButton.setPreferredSize(new Dimension(27, 25));
        this.filterTButton.setToolTipText("Turn on/off Optical Link filter");
        this.filterTButton.addActionListener(this);
        jPanel3.add(this.filterTButton);
        jPanel3.add(new CSHelpButton(CSHelpConst.SppAnsConnPane));
        this.createButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.commButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.filterCB.setEnabled(false);
        this.filterTButton.setEnabled(false);
        this.enableComponent(this.createButton, this.nodeModel, SecurityLevel.PROVISIONING);
        this.enableComponent(this.deleteButton, this.nodeModel, SecurityLevel.PROVISIONING);
        this.enableComponent(this.commButton, this.nodeModel, SecurityLevel.PROVISIONING);
        this.enableComponent(this.calcConnButton, this.nodeModel, SecurityLevel.PROVISIONING);
        this.enableComponent(this.filterCB, this.nodeModel, SecurityLevel.PROVISIONING);
        this.enableComponent(this.filterTButton, this.nodeModel, SecurityLevel.PROVISIONING);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.commButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
        this.editButton.setEnabled(false);
        if (object == this.createButton) {
            AnsPathCreateDialog ansPathCreateDialog = new AnsPathCreateDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), this.parent.getUiModel(), this.dataModel);
        } else if (object == this.deleteButton) {
            int[] nArray = this.table.getSelectedRows();
            if (nArray.length == 0) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_OPTICAL_LINK_SEL);
                return;
            }
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)"Really delete selected Optical Links?", (String)"Delete Optical Link")) {
                return;
            }
            this.deleteOptLink();
        } else if (object == this.commButton) {
            this.createOptLink();
        } else if (object == this.editButton) {
            this.editPatchcord();
        } else if (object == this.filterCB) {
            this.localFilterStat = (OptLinkStats)this.filterCB.getSelectedItem();
            if (SppAnsConnPane.db.on) {
                db.println("filter Index=" + this.filterCB.getSelectedIndex());
            }
        } else if (object == this.calcConnButton) {
            try {
                this.dataSource.calculateAutomaticOpticalLinkList();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)this.parent, (EID)EMC.EID_ERROR_CALCAUTOMATIC_OPTLINK);
                return;
            }
        } else if (object == this.filterTButton) {
            if (this.filterTButton.isSelected()) {
                this.dataSource.setFilter(this.localFilterStat);
            } else {
                this.dataSource.setFilter(OptLinkStats.LINK_UNDEFINED);
            }
        }
    }

    private void editPatchcord() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length != 1) {
            return;
        }
        OptLinkModel optLinkModel = (OptLinkModel)this.dataModel.getValueAt(nArray[0], 0);
        AnsPathCreateDialog ansPathCreateDialog = new AnsPathCreateDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), this.parent.getUiModel(), this.dataModel, optLinkModel.getFrom(), optLinkModel.getTo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.dataSource == null) {
                this.init();
            }
            if (this.initialized) {
                this.dataSource.init();
                this.initialized = false;
            }
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
            this.table.getSelectionModel().addListSelectionListener(this);
        }
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.table.getSelectionModel().removeListSelectionListener(this);
    }

    public void refresh() {
    }

    public void createOptLink() {
        Object object;
        int n;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < nArray.length; ++n) {
            object = (OptLinkModel)this.dataModel.getValueAt(nArray[n], 0);
            arrayList.add(object);
        }
        n = 0;
        object = arrayList.iterator();
        while (object.hasNext()) {
            try {
                boolean bl = false;
                Object var6_8 = null;
                OptLinkModel optLinkModel = (OptLinkModel)object.next();
                try {
                    this.dataSource.createOptLink(optLinkModel);
                }
                catch (CTCUserException cTCUserException) {
                    DetailedLog detailedLog;
                    String string;
                    if (arrayList.size() > 1) {
                        if (n == 0) {
                            n = CerentDialog.yesNoDialog((Component)((Object)this), (String)"Unable to Create All Optical Links, Continue?", (String)"Create Optical Link Warning", (int)0) ? 1 : 0;
                        }
                        string = ErrorMsg.getString((EID)EMC.EID_FAIL_CREATE_OPTICAL_LINK);
                        detailedLog = new DetailedLog(2, string + "\n" + cTCUserException.getMessage());
                        detailedLog.setException((Exception)((Object)cTCUserException));
                        EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
                        if (n != 0) {
                            if (!SppAnsConnPane.db.on) continue;
                            db.println("exception in create patch select yes -> continue");
                            continue;
                        }
                        if (!SppAnsConnPane.db.on) break;
                        db.println("exception in create patch select no-> break");
                        break;
                    }
                    string = ErrorMsg.getString((EID)EMC.EID_FAIL_CREATE_OPTICAL_LINK);
                    detailedLog = new DetailedLog(2, string + "\n" + cTCUserException.getMessage());
                    detailedLog.setException((Exception)((Object)cTCUserException));
                    EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
                }
            }
            catch (Exception exception) {
                db.finest("exception in createOptLink" + exception);
            }
        }
        try {
            this.dataSource.updateAll();
        }
        catch (AnnotatedException annotatedException) {
            // empty catch block
        }
    }

    public void deleteOptLink() {
        int[] nArray = this.table.getSelectedRows();
        boolean bl = false;
        if (nArray.length == 0) {
            return;
        }
        ArrayList<OptLinkModel> arrayList = new ArrayList<OptLinkModel>();
        Object[] objectArray = new String[]{"Continue", "No more messages", "Cancel"};
        for (int i = 0; i < nArray.length; ++i) {
            OptLinkModel optLinkModel = (OptLinkModel)this.dataModel.getValueAt(nArray[i], 0);
            arrayList.add(optLinkModel);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                boolean bl2 = false;
                int n = 0;
                Object var8_12 = null;
                OptLinkModel optLinkModel = (OptLinkModel)iterator.next();
                try {
                    this.dataSource.deleteOptLink(optLinkModel);
                }
                catch (Exception exception) {
                    if (arrayList.size() > 1) {
                        if (!bl) {
                            String string = "Unable to Delete Optical Link\r\nfrom port " + this.getPortName(optLinkModel.getFromModel()) + " to port " + this.getPortName(optLinkModel.getToModel()) + ".";
                            if (exception instanceof Busy) {
                                string = string + "\r\nOCHNC circuits/OSC Terminations/Synchronization sources\r\nhave to be removed prior to remove this link.";
                            }
                            n = CerentDialog.optionDialog((Component)((Object)this), (String)string, (String)"Delete Optical Link Warning", (Object[])objectArray, (Object)"Continue");
                        }
                        if (n == 0) {
                            if (!SppAnsConnPane.db.on) continue;
                            db.println("exception in delete patch select yes -> continue");
                            continue;
                        }
                        if (n == 1) {
                            bl = true;
                            continue;
                        }
                        if (!SppAnsConnPane.db.on) break;
                        db.println("exception in delete patch select no-> break");
                        break;
                    }
                    if (exception instanceof Busy) {
                        ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_DEL_OPTICAL_LINK, "OCHNC circuits/OSC Terminations/Synchronization sources have to be removed prior to remove this link.");
                        continue;
                    }
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_DEL_OPTICAL_LINK);
                }
            }
            catch (Exception exception) {
                db.finest("exception in createOptLink" + exception);
            }
        }
        try {
            this.dataSource.updateAll();
        }
        catch (AnnotatedException annotatedException) {
            SDebug.printStackTrace((Throwable)annotatedException);
        }
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
        if (this.dataSource != null) {
            this.dataSource.dispose();
            this.dataSource = null;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.editButton.setEnabled(false);
        this.filterCB.setEnabled(true);
        if (!listSelectionEvent.getValueIsAdjusting()) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int[] nArray = this.table.getSelectedRows();
            if (nArray.length > 0) {
                block5: for (int i = 0; i < nArray.length; ++i) {
                    OptLinkModel optLinkModel = (OptLinkModel)this.dataModel.getValueAt(nArray[i], 0);
                    switch (optLinkModel.getOptLnkState().value()) {
                        case 3: {
                            ++n;
                            continue block5;
                        }
                        case 2: {
                            ++n2;
                            continue block5;
                        }
                        case 1: {
                            ++n3;
                            continue block5;
                        }
                        default: {
                            ++n4;
                        }
                    }
                }
                if (SppAnsConnPane.db.on) {
                    db.println("valueChanged");
                }
            } else {
                Object var2_9 = null;
                if (SppAnsConnPane.db.on) {
                    db.println("valueChanged: selectedItem = null");
                }
            }
            if (n2 > 0 && n3 == 0 && n == 0 && n4 == 0) {
                this.commButton.setEnabled(true);
            } else if (n == 1 && nArray.length == 1) {
                this.editButton.setEnabled(true);
            } else if (n4 == 0) {
                this.commButton.setEnabled(false);
            }
            this.deleteButton.setEnabled(true);
        }
    }

    private String getPortName(EntityModel entityModel) {
        return new ParserIfName(entityModel).getAID();
    }

    class ConnectionCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ConnectionCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(((OptLinkStats)object).getString());
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }
}

