/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ObserverProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ans.ANSController;
import cerent.cms.ui.ans.ANSTableCellEditor;
import cerent.cms.ui.ans.ANSTableCellRenderer;
import cerent.cms.ui.ans.ANSTreeCellRenderer;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.SystemTime;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeSelectionModel;

public class SppAnsNeUpdatePane
extends ObserverProvPane
implements TreeSelectionListener,
ComponentListener,
Runnable {
    private static final String PROP_PREF = "ctc.defaults";
    private static final String PROP_DIVIDER = "divider";
    static final SimpleDateFormat timeFmt = new SimpleDateFormat("MMMMM d,yyyy H:mm:ss a,z");
    private boolean inited = false;
    private JButton exportButton;
    private ANSController dfc;
    private TreeSelectionModel tsm;
    private JSplitPane split;
    private JLabel label;
    private String labelText;
    private NodeModelDelegate nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
    private static final SDebug dbg = new SDebug("SppAnsNeUpdatePane");

    public SppAnsNeUpdatePane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
    }

    public void enteringPage() throws Exception {
        if (!this.inited) {
            try {
                this.init();
                this.inited = true;
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        int n = this.split.getDividerLocation() * 100 / (this.split.getWidth() - this.split.getDividerSize()) + 1;
        Preferences.instance().setInt(PROP_PREF, PROP_DIVIDER, n);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    private void init() {
        this.dfc = new ANSController(this, (NodeModelDelegate)this.getUiModel().getNodeModel(), dbg);
        this.setDataSourceControl(this.dfc);
        this.split = new JSplitPane(1);
        JTree jTree = new JTree(this.dfc.getTreeModel());
        jTree.setCellRenderer(new ANSTreeCellRenderer());
        jTree.setShowsRootHandles(true);
        jTree.setScrollsOnExpand(true);
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        this.tsm = jTree.getSelectionModel();
        this.tsm.setSelectionMode(1);
        this.tsm.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Selector"));
        this.split.setLeftComponent(jScrollPane);
        this.table = new UTable((TableModel)this.dfc.getTableModel());
        jScrollPane = new JScrollPane(this.table);
        this.split.setRightComponent(jScrollPane);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.split);
        this.label = new JLabel(" ");
        this.label.setHorizontalAlignment(4);
        jPanel.add((Component)this.label, "South");
        this.add(jPanel);
        ANSTableCellEditor aNSTableCellEditor = new ANSTableCellEditor();
        this.table.getColumnModel().getColumn(1).setCellEditor(aNSTableCellEditor);
        ANSTableCellRenderer aNSTableCellRenderer = new ANSTableCellRenderer();
        this.table.getColumnModel().getColumn(0).setCellRenderer(aNSTableCellRenderer);
        this.table.getColumnModel().getColumn(1).setCellRenderer(aNSTableCellRenderer);
        this.split.addComponentListener(this);
    }

    public TreeSelectionModel getTreeSelectionModel() {
        return this.tsm;
    }

    public void updateLabel(String string) {
        SystemTime systemTime = this.nodeModel.getSystemTime();
        timeFmt.setTimeZone(this.nodeModel.getCtcTimeZone());
        Date date = systemTime.getSystemCalendar().getTime();
        String string2 = "Retrieved: " + timeFmt.format(date) + " from " + string;
        this.setLabel(string2);
    }

    public void clearLabel() {
        this.setLabel(" ");
    }

    private void setLabel(String string) {
        this.labelText = string;
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getNewLeadSelectionPath() != null) {
            this.stopTableCellEditing();
            this.dfc.setTableContent(treeSelectionEvent.getNewLeadSelectionPath());
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        int n = Preferences.instance().getInt(PROP_PREF, PROP_DIVIDER, 0);
        if (n == 0) {
            this.split.setDividerLocation(-1);
        } else {
            this.split.setDividerLocation((double)n / 100.0);
        }
        this.split.removeComponentListener(this);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void run() {
        this.label.setText(this.labelText);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppAnsNeUpdatePane;
    }
}

