/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.model.EleNodeShelfModel;
import cerent.cms.model.IModel;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.ShelfTabbedView;
import cerent.cms.ui.shelf.SppDccPane;
import cerent.cms.ui.shelf.SppGccPane;
import cerent.cms.ui.shelf.SppLdccPane;
import cerent.cms.ui.shelf.SppOscPane;
import cerent.cms.ui.shelf.lmp.SppLmpPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Component;
import java.awt.GridLayout;

public class SppCommChannelsPane
extends AbstractPane
implements ITabName {
    private static final SDebug db = new SDebug((KDebug)ShelfTabbedView.db, "SppCommChannelsPane");
    protected IGuestPaneFactory gpf;

    public SppCommChannelsPane(String string, TabbedView tabbedView, IGuestPaneFactory iGuestPaneFactory) {
        super(string, tabbedView);
        this.gpf = iGuestPaneFactory;
        EleNodeShelfModel eleNodeShelfModel = (EleNodeShelfModel)tabbedView.getUiModel();
        this.subTabs = new SubTabbedView((IModel)eleNodeShelfModel, tabbedView);
        TDMTerminology tDMTerminology = eleNodeShelfModel.getTDMTerminology();
        String string2 = tDMTerminology.getGeneralTerms(8);
        String string3 = tDMTerminology.getGeneralTerms(10);
        this.subTabs.add((Component)((Object)new SppDccPane(string2, this.subTabs)));
        IPlatform iPlatform = eleNodeShelfModel.getPlatform();
        if (iPlatform.supportsLDCC()) {
            this.subTabs.add((Component)((Object)new SppLdccPane(string3, this.subTabs)));
        }
        if (iPlatform.supportsDWDM()) {
            this.subTabs.add((Component)((Object)new SppGccPane("GCC", this.subTabs)));
            this.subTabs.add((Component)((Object)new SppOscPane("OSC", this.subTabs)));
        }
        if (iPlatform.supportsPPC()) {
            this.subTabs.add((Component)iGuestPaneFactory.getGuestPane(12, this.subTabs));
        }
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.subTabs);
    }

    private boolean supportsLMP() {
        String string;
        EleNodeShelfModel eleNodeShelfModel = (EleNodeShelfModel)this.getUiModel();
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)eleNodeShelfModel.getNodeModel();
        IPlatform iPlatform = eleNodeShelfModel.getPlatform();
        if (iPlatform.supportsDWDM()) {
            string = "1";
            try {
                String string2 = nodeModelDelegate.getDefaultValue("NODE.lmp.general.Allowed");
                if (string2 != null && !string2.equals("UNKNOWN")) {
                    string = string2;
                }
            }
            catch (NoSuchDefault noSuchDefault) {}
        } else {
            string = "0";
        }
        return "1".equals(string);
    }

    public void refresh() {
    }

    public void enteringPage() {
        boolean bl = this.supportsLMP();
        int n = this.subTabs.indexOfTab("LMP");
        if (bl && n == -1) {
            this.subTabs.add((Component)((Object)new SppLmpPane("LMP", this.subTabs)));
        } else if (!bl && n != -1) {
            this.subTabs.removeTabAt(n);
        }
    }

    public void leavingPage() {
    }
}

