/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eMultishelfLanConfig;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.INodeType;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ShelfInfo;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SppMultishelfConfigPane
extends NodeProvPane
implements ActionListener {
    private ButtonGroup radioButtons;
    private JRadioButton disableButton;
    private JRadioButton scButton;
    private JRadioButton ncButton;
    private JComboBox lanConfigCB;
    private JComboBox shelfIdCB;
    private DefaultComboBoxModel lanCBModel;
    private IObservableManager om;
    private static final String DISABLE = "Disable Multishelf";
    private static final String SC = "Enable as Subtended Shelf";
    private static final String NC = "Enable as Node Controller";
    private static final String[] LAN_CFG = new String[]{"N/A", "Ethernet Switch", "Stand-alone"};
    private static final int MAX_SHELF = 8;
    private static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "SppMultishelfConfigPane");

    public SppMultishelfConfigPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppMultishelfConfigPane;
    }

    private void init() {
        db.info("init: start");
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        this.add((Component)uScrollPane);
        jPanel.add(this.createButtonPanel());
        this.registerWithModel();
        db.info("init: finish");
    }

    protected void registerWithModel() {
        IObservableManager iObservableManager = this.getObservableManager();
        iObservableManager.reset();
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        iObservableManager.addObservable((Observable)((Object)((EntityModel)((Object)iChassisModel))));
        iObservableManager.addObservable((Observable)((Object)iChassisModel.getNodeModelDelegate()));
        iObservableManager.setActive(true);
    }

    protected IObservableManager getObservableManager() {
        if (this.om == null) {
            this.om = new ObservableManager((Observer)((Object)this), true);
        }
        return this.om;
    }

    private JPanel createButtonPanel() {
        this.disableButton = new JRadioButton(DISABLE);
        this.disableButton.addActionListener(this);
        this.disableButton.setMnemonic(68);
        this.scButton = new JRadioButton(SC);
        this.scButton.addActionListener(this);
        this.scButton.setMnemonic(83);
        this.ncButton = new JRadioButton(NC);
        this.ncButton.addActionListener(this);
        this.ncButton.setMnemonic(78);
        this.radioButtons = new ButtonGroup();
        this.radioButtons.add(this.disableButton);
        this.radioButtons.add(this.scButton);
        this.radioButtons.add(this.ncButton);
        Short[] shortArray = new Short[7];
        for (int i = 1; i < 8; ++i) {
            shortArray[i - 1] = new Short((short)(i + 1));
        }
        this.shelfIdCB = new JComboBox<Short>(shortArray);
        this.shelfIdCB.addActionListener(this);
        this.shelfIdCB.setEnabled(false);
        this.lanCBModel = new DefaultComboBoxModel<String>(LAN_CFG);
        this.lanConfigCB = new JComboBox(this.lanCBModel);
        this.lanConfigCB.addActionListener(this);
        this.lanConfigCB.setEnabled(false);
        JPanel jPanel = new JPanel(new GridLayout(3, 3));
        jPanel.setBorder(BorderFactory.createTitledBorder("Multishelf Configuration"));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 1));
        jPanel2.add(this.disableButton);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 1));
        jPanel3.add(new JLabel(" "));
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 1));
        jPanel4.add(new JLabel(" "));
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 5, 1));
        jPanel5.add(this.scButton);
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel(new FlowLayout(2, 5, 1));
        jPanel6.add(new JLabel("Shelf ID:"));
        jPanel.add(jPanel6);
        JPanel jPanel7 = new JPanel(new FlowLayout(0, 5, 1));
        Dimension dimension = this.shelfIdCB.getPreferredSize();
        Dimension dimension2 = new Dimension((int)dimension.getWidth() + 15, (int)dimension.getHeight());
        this.shelfIdCB.setPreferredSize(dimension2);
        jPanel7.add(this.shelfIdCB);
        jPanel.add(jPanel7);
        JPanel jPanel8 = new JPanel(new FlowLayout(0, 5, 1));
        jPanel8.add(this.ncButton);
        jPanel.add(jPanel8);
        JPanel jPanel9 = new JPanel(new FlowLayout(2, 5, 1));
        jPanel9.add(new JLabel("LAN Config:"));
        jPanel.add(jPanel9);
        JPanel jPanel10 = new JPanel(new FlowLayout(0, 5, 1));
        jPanel10.add(this.lanConfigCB);
        jPanel.add(jPanel10);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null) {
            db.severe("Null actionPerformed source!");
            return;
        }
        if (object == this.disableButton) {
            if (this.lanCBModel.getSize() < LAN_CFG.length) {
                this.lanCBModel.insertElementAt(LAN_CFG[0], 0);
            }
            this.lanConfigCB.setSelectedIndex(0);
            this.lanConfigCB.setEnabled(false);
            this.shelfIdCB.setEnabled(false);
        } else if (object == this.scButton) {
            ShelfInfo shelfInfo;
            IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
            if (this.lanCBModel.getSize() < LAN_CFG.length) {
                this.lanCBModel.insertElementAt(LAN_CFG[0], 0);
            }
            this.lanConfigCB.setSelectedIndex(0);
            this.lanConfigCB.setEnabled(false);
            this.shelfIdCB.setSelectedIndex(0);
            if (iChassisModel.getNodeModel().isMultishelf() && (shelfInfo = iChassisModel.getShelfInfo()).getShelfRole() == ShelfInfo.IShelfRole.SHELF_ROLE_SC) {
                this.shelfIdCB.setSelectedIndex(iChassisModel.getShelfId() - 2);
            }
            this.shelfIdCB.setEnabled(true);
        } else if (object == this.ncButton) {
            ShelfInfo shelfInfo;
            IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
            this.shelfIdCB.setSelectedIndex(0);
            this.shelfIdCB.setEnabled(false);
            if (this.lanCBModel.getSize() > LAN_CFG.length - 1) {
                this.lanCBModel.removeElementAt(0);
            }
            this.lanConfigCB.setSelectedIndex(0);
            if (iChassisModel.getNodeModel().isMultishelf() && (shelfInfo = iChassisModel.getShelfInfo()).getShelfRole() == ShelfInfo.IShelfRole.SHELF_ROLE_NC) {
                this.lanConfigCB.setSelectedIndex(shelfInfo.getLanConfig().value() - 1);
            }
            this.lanConfigCB.setEnabled(true);
        }
        this.setDirty();
    }

    public void applyChangesToModel() throws Exception {
        db.info("applyChangesToModel: start");
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        if (this.isProvPaneDirty()) {
            ShelfInfo.IShelfRole iShelfRole = iChassisModel.getShelfInfo().getShelfRole();
            ShelfInfo.IShelfRole iShelfRole2 = this.ncButton.isSelected() ? ShelfInfo.IShelfRole.SHELF_ROLE_NC : (this.scButton.isSelected() ? ShelfInfo.IShelfRole.SHELF_ROLE_SC : ShelfInfo.IShelfRole.SHELF_ROLE_SINGLE);
            try {
                StringBuffer stringBuffer = new StringBuffer("CAUTION: This will cause your node to reboot.");
                db.fine("curRole = " + iShelfRole + ", newRole = " + iShelfRole2);
                if (iShelfRole != iShelfRole2) {
                    db.fine("applyChangesToModel: setting MS mode to " + (this.disableButton.isSelected() ? "disabled" : (this.scButton.isSelected() ? "sc" : "nc")));
                    if (this.scButton.isSelected()) {
                        stringBuffer = new StringBuffer(ErrorMsg.getString((EID)EMC.WID_MS_CONFIG_WARNING, (Object)this.shelfIdCB.getSelectedItem()));
                    }
                    stringBuffer.append("\n\nOK to continue?");
                    if (CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Multishelf Provisioning")) {
                        if (iShelfRole2 == ShelfInfo.IShelfRole.SHELF_ROLE_SC) {
                            iChassisModel.enableMultishelfAsSc((Short)this.shelfIdCB.getSelectedItem());
                        } else if (iShelfRole2 == ShelfInfo.IShelfRole.SHELF_ROLE_NC) {
                            iChassisModel.enableMultishelfAsNc(eMultishelfLanConfig.from_int(this.lanConfigCB.getSelectedIndex() + 1));
                        } else {
                            iChassisModel.disableMultishelf();
                        }
                        this.resetDirty();
                    }
                } else if (iShelfRole == ShelfInfo.IShelfRole.SHELF_ROLE_NC) {
                    stringBuffer.append("\n\nOK to continue?");
                    if (CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Multishelf Provisioning")) {
                        iChassisModel.setLanConfig(eMultishelfLanConfig.from_int(this.lanConfigCB.getSelectedIndex() + 1));
                        this.resetDirty();
                    }
                } else {
                    iChassisModel.setShelfId(((Short)this.shelfIdCB.getSelectedItem()).intValue());
                }
            }
            catch (NotSupportedOnEquipment notSupportedOnEquipment) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MS_NOT_SUPPORTED_ON_CHASSIS);
                this.refreshFromModel();
            }
            catch (ProvisionError provisionError) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)provisionError);
                }
                if (provisionError.getEID() != null) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)provisionError.getEID(), (Object[])provisionError.getEIDParams());
                } else {
                    ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_PROVISION_ERROR_PARAM_1, (Object)provisionError.getMessage());
                }
                this.refreshFromModel();
            }
        }
        db.info("applyChangesToModel: finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.radioButtons == null) {
                this.init();
            }
            IObservableManager iObservableManager = this.getObservableManager();
            iObservableManager.setPassing(true);
            super.enteringPage();
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    public void leavingPage() throws Exception {
        IObservableManager iObservableManager = this.getObservableManager();
        iObservableManager.setPassing(false);
        super.leavingPage();
    }

    public void refreshFromModel() throws Exception {
        db.info("refreshFromModel: start");
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        if (iChassisModel == null) {
            db.severe("Chassis is null in SppMultishelfConfigPane::refresh()");
            return;
        }
        if (iChassisModel.getNodeModel().isMultishelf()) {
            ShelfInfo shelfInfo = iChassisModel.getShelfInfo();
            this.disableButton.setEnabled(true);
            switch (shelfInfo.getShelfRole().value()) {
                case 0: 
                case 2: {
                    this.ncButton.setSelected(true);
                    this.ncButton.setEnabled(true);
                    this.scButton.setEnabled(false);
                    this.shelfIdCB.setSelectedIndex(0);
                    this.shelfIdCB.setEnabled(false);
                    if (this.lanCBModel.getSize() > LAN_CFG.length - 1) {
                        this.lanCBModel.removeElementAt(0);
                    }
                    this.lanConfigCB.setSelectedIndex(shelfInfo.getLanConfig().value() - 1);
                    this.lanConfigCB.setEnabled(true);
                    break;
                }
                case 1: {
                    this.scButton.setSelected(true);
                    this.scButton.setEnabled(true);
                    this.ncButton.setEnabled(false);
                    if (this.lanCBModel.getSize() < LAN_CFG.length) {
                        this.lanCBModel.insertElementAt(LAN_CFG[0], 0);
                    }
                    this.lanConfigCB.setSelectedIndex(0);
                    this.lanConfigCB.setEnabled(false);
                    this.shelfIdCB.setSelectedIndex(iChassisModel.getShelfId() - 2);
                    this.shelfIdCB.setEnabled(true);
                    break;
                }
                default: {
                    db.severe("Bad shelf role: " + shelfInfo.getShelfRole().value());
                    break;
                }
            }
        } else {
            this.disableButton.setSelected(true);
            if (this.lanCBModel.getSize() < LAN_CFG.length) {
                this.lanCBModel.insertElementAt(LAN_CFG[0], 0);
            }
            this.lanConfigCB.setSelectedIndex(0);
            this.lanConfigCB.setEnabled(false);
            this.shelfIdCB.setSelectedIndex(0);
            this.shelfIdCB.setEnabled(false);
            int n = iChassisModel.getNodeModel().getNodeType();
            db.fine("Node type is " + INodeType.NODE_TYPES[n]);
            if (n != 2 && n != 0) {
                this.disableButton.setEnabled(false);
                this.scButton.setEnabled(false);
                this.ncButton.setEnabled(false);
            } else {
                boolean bl = this.isUserAuthorized(SecurityLevel.SUPERUSER);
                this.disableButton.setEnabled(bl);
                this.scButton.setEnabled(bl);
                this.ncButton.setEnabled(bl);
            }
        }
        db.info("refreshFromModel: finish");
    }

    public boolean onValidate() {
        boolean bl = true;
        if (this.ncButton.isSelected() && this.lanCBModel.getSelectedItem().equals(LAN_CFG[0])) {
            bl = false;
        }
        return bl;
    }
}

