/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractProvPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.nodesetup.NodeSetupController;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.PersistentFileChooserPanel;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class SppNodeSetupPane
extends AbstractProvPane {
    private PersistentFileChooserPanel setupFile;
    private PersistentFileChooserPanel logFile;
    private NodeModelDelegate nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
    private NodeSetupController nsc;
    private static final SDebug db = new SDebug("SppNodeSetupPane");

    public SppNodeSetupPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.init();
    }

    protected void init() {
        if (db.on()) {
            db.println("init: start");
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.createXmlFilePanel());
        jPanel.add(this.createLogFilePanel());
        this.add(jPanel, "Center");
        if (db.on()) {
            db.println("init: finish");
        }
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        this.add((Component)uScrollPane, "Center");
        this.setupFile.clearCombo();
        this.logFile.clearCombo();
        this.setDirty(true);
    }

    public CSHelpID getHelpID() {
        return new CSHelpID("NodeSetup");
    }

    private JPanel createXmlFilePanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder("Xml"));
        this.setupFile = new PersistentFileChooserPanel("Select xml file: ", false, "", "", 10);
        jPanel.add((Component)this.setupFile);
        return jPanel;
    }

    private JPanel createLogFilePanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder("Log"));
        this.logFile = new PersistentFileChooserPanel("Select log file: ", false, "", "", 10);
        jPanel.add((Component)this.logFile);
        return jPanel;
    }

    public void enteringPage() {
        try {
            this.refreshFromModel();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void leavingPage() throws Exception {
    }

    protected AbstractLeavePageException createLeavePageException(String string) {
        return null;
    }

    private String getFileName() {
        return this.setupFile.getSelectedFileName();
    }

    private String getLogFileName() {
        return this.logFile.getSelectedFileName();
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void refreshFromModel() throws Exception {
    }

    public void customBehaviour() {
        this.setupFile.initCombo();
        this.logFile.initCombo();
        this.setDirty(true);
    }

    public void applyChangesToModel() throws Exception {
        String string = null;
        File file = null;
        String string2 = this.checkCombosContent();
        if (string2.equalsIgnoreCase("ok")) {
            String string3 = this.getFileName();
            File file2 = new File(string3);
            string = this.getLogFileName();
            file = new File(string);
            this.nsc = new NodeSetupController(this, this.nodeModel, file2, file, db);
        } else {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_NODESETUP_MISSING_INFO, (Object)string2);
        }
    }

    public String checkCombosContent() {
        if (this.getFileName().equals("") && this.getLogFileName().equals("")) {
            return "Please specify a log and xml file.";
        }
        if (!this.getFileName().equals("") && this.getLogFileName().equals("")) {
            return "Please specify a log file.";
        }
        if (this.getFileName().equals("") && !this.getLogFileName().equals("")) {
            return "Please specify an xml file.";
        }
        return "ok";
    }
}

