/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.DwdmRingModelDelegate;
import cerent.cms.model.EleNodeShelfModel;
import cerent.cms.model.OscTermConnectionModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.DwdmRingPane;
import cerent.cms.ui.shelf.OscTermPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JTable;

public class SppOscPane
extends AbstractPane {
    public static final String OSC_TERM_TAB = "OSC Terminations";
    public static final String DWDM_RING_ID_TAB = "DWDM Ring ID";
    private OscTermPane oscPane;
    private DwdmRingPane dwdmRingPane;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "SppOscPane");

    public SppOscPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    private void init() {
        if (db.on()) {
            db.println("init");
        }
        EleNodeShelfModel eleNodeShelfModel = (EleNodeShelfModel)this.parentTV.getUiModel();
        OscTermConnectionModel oscTermConnectionModel = (OscTermConnectionModel)eleNodeShelfModel.getOscTermConnectionModel();
        DwdmRingModelDelegate dwdmRingModelDelegate = eleNodeShelfModel.getDwdmRingModelDelegate();
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel.setPreferredSize(new Dimension(750, 250));
        this.oscPane = new OscTermPane(OSC_TERM_TAB, oscTermConnectionModel, this.parentTV);
        jPanel.add((Component)((Object)this.oscPane));
        this.dwdmRingPane = new DwdmRingPane(DWDM_RING_ID_TAB, dwdmRingModelDelegate);
        jPanel.add((Component)((Object)this.dwdmRingPane));
        this.setLayout(new BorderLayout(5, 5));
        this.add(jPanel);
    }

    public void enteringPage() throws Exception {
        if (this.oscPane == null || this.dwdmRingPane == null) {
            this.init();
        }
        this.oscPane.enteringPage();
        this.dwdmRingPane.enteringPage();
        this.refresh();
    }

    public void leavingPage() throws Exception {
    }

    public void refresh() throws Exception {
        this.oscPane.refresh();
        this.dwdmRingPane.refresh();
    }

    public void destroy() {
        super.destroy();
        if (this.oscPane != null) {
            this.oscPane.destroy();
        }
        if (this.dwdmRingPane != null) {
            this.dwdmRingPane.destroy();
        }
    }

    public JTable getTable() {
        return this.oscPane != null ? this.oscPane.getTable() : null;
    }
}

