/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Node.sPwrMonVoltage;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.PwrMonInvalidHi;
import cerent.cms.model.PwrMonInvalidInc;
import cerent.cms.model.PwrMonInvalidLo;
import cerent.cms.model.PwrMonOrderError;
import cerent.cms.model.PwrMonSavLimits;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.omg.CORBA.UNKNOWN;

public class SppPowerMonitorPane
extends NodeProvPane
implements ActionListener {
    protected static final double SCALE_FACTOR = -1000.0;
    protected static final double INCREMENT = -0.5;
    private static final String[] chassisVtgType = new String[]{"Unknown", "-48 Vdc", "-60 Vdc", "Unknown"};
    protected JComboBox elwCB;
    protected JComboBox lwCB;
    protected JComboBox ehwCB;
    protected JComboBox hwCB;
    protected JLabel voltageLB;
    protected boolean hasProvPrivilege = false;
    protected sPwrMonVoltage voltage;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "SppPowerMonitorPane");

    protected JPanel createPowerMonitorPanel() {
        JPanel jPanel = SppPowerMonitorPane.createHorizontalPanel("Voltage Thresholds");
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.anchorWest();
        gridBagPanel.inset(4, 1);
        int n = 0;
        gridBagPanel.add(new JLabel("ELWBATVG(Vdc):"), 0, n++, 1, 1);
        if (!this.pci.is455()) {
            gridBagPanel.add(new JLabel("LWBATVG(Vdc):"), 0, n++, 1, 1);
            gridBagPanel.add(new JLabel("HIBATVG(Vdc):"), 0, n++, 1, 1);
        }
        gridBagPanel.add(new JLabel("EHIBATVG(Vdc):"), 0, n++, 1, 1);
        gridBagPanel.fillBoth(100, 0);
        this.elwCB = new JComboBox();
        this.lwCB = new JComboBox();
        this.hwCB = new JComboBox();
        this.ehwCB = new JComboBox();
        n = 0;
        gridBagPanel.add((Component)this.elwCB, 1, n++);
        if (!this.pci.is455()) {
            gridBagPanel.add((Component)this.lwCB, 1, n++);
            gridBagPanel.add((Component)this.hwCB, 1, n++);
        }
        gridBagPanel.add((Component)this.ehwCB, 1, n++);
        jPanel.add(gridBagPanel);
        jPanel.add(Box.createHorizontalStrut(50));
        if (this.isUserAuthorized()) {
            this.elwCB.addActionListener(this);
            this.ehwCB.addActionListener(this);
            this.lwCB.addActionListener(this);
            this.hwCB.addActionListener(this);
        }
        this.elwCB.setEnabled(this.hasProvPrivilege);
        this.ehwCB.setEnabled(this.hasProvPrivilege);
        this.lwCB.setEnabled(this.hasProvPrivilege);
        this.hwCB.setEnabled(this.hasProvPrivilege);
        return jPanel;
    }

    protected void addListItems(double d, double d2) {
        while (d >= d2) {
            this.ehwCB.addItem(new Double(d));
            if (!this.pci.is455()) {
                this.hwCB.addItem(new Double(d));
                this.lwCB.addItem(new Double(d));
            }
            this.elwCB.addItem(new Double(d));
            d += -0.5;
        }
    }

    public SppPowerMonitorPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.init();
    }

    private void init() {
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
        this.hasProvPrivilege = this.isUserAuthorized(SecurityLevel.PROVISIONING);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBorder(BorderFactory.createTitledBorder("Voltage Thresholds"));
        jPanel.add(this.createPowerMonitorPanel());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)this.createVoltageDescPanel(), "South");
        this.add((Component)new UScrollPane((Component)jPanel2));
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        double d = 0.0;
        double d2 = 0.0;
        try {
            this.voltage = iChassisModel.getPowerMonitor();
            d = (double)this.voltage.low_limit / -1000.0;
            d2 = (double)this.voltage.high_limit / -1000.0;
        }
        catch (UNKNOWN uNKNOWN) {
            db.severe(uNKNOWN.toString());
        }
        this.addListItems(d, d2);
        this.registerWithModel();
    }

    private JPanel createVoltageDescPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 3));
        jPanel.add(new JLabel("Environment Type: "));
        this.voltageLB = new JLabel();
        jPanel.add(this.voltageLB);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setDirty();
    }

    public void refreshFromModel() throws Exception {
        IChassisModel iChassisModel;
        if (db.on()) {
            db.println("refreshFromModel: start");
        }
        if ((iChassisModel = (IChassisModel)this.getUiModel()) == null) {
            if (db.on()) {
                db.println("ChassisModel is null in SppPowerMonitorPane");
            }
            return;
        }
        this.voltage = iChassisModel.getPowerMonitor();
        this.setVoltage(this.voltage);
        this.resetDirty();
        if (db.on()) {
            db.println("refreshFromModel: finish");
        }
    }

    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("applyChangesToModel: start");
        }
        this.voltage.ex_high_voltage = this.convertVoltage((Double)this.ehwCB.getSelectedItem());
        if (!this.pci.is455()) {
            this.voltage.high_voltage = this.convertVoltage((Double)this.hwCB.getSelectedItem());
            this.voltage.low_voltage = this.convertVoltage((Double)this.lwCB.getSelectedItem());
        }
        this.voltage.ex_low_voltage = this.convertVoltage((Double)this.elwCB.getSelectedItem());
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        try {
            iChassisModel.setPowerMonitor(this.voltage);
        }
        catch (PwrMonOrderError pwrMonOrderError) {
            String string = this.pci.is455() ? "ELWBATVG < EHIBATVG" : "ELWBATVG <= LWBATVG < HIBATVG <= EHIBATVG";
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_POWMON_WRONG_ORDER_PARAM_1, (Object)string);
            this.refreshFromModel();
        }
        catch (PwrMonInvalidHi pwrMonInvalidHi) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_POWMON_WRONG_PARAMETER_PARAM_1, (Object)"HIBATVG");
            this.refreshFromModel();
        }
        catch (PwrMonInvalidLo pwrMonInvalidLo) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_POWMON_WRONG_PARAMETER_PARAM_1, (Object)"LWBATVG");
            this.refreshFromModel();
        }
        catch (PwrMonInvalidInc pwrMonInvalidInc) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_POWMON_WRONG_INCREMENT);
            this.refreshFromModel();
        }
        catch (PwrMonSavLimits pwrMonSavLimits) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_POWMON_WRONG_RANGE);
            this.refreshFromModel();
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Caught exception in setPowerMonitor: " + exception);
            }
            this.refreshFromModel();
        }
        if (db.on()) {
            db.println("applyChangesToModel: finish");
        }
    }

    public void destroy() {
        super.destroy();
    }

    protected void setVoltage(sPwrMonVoltage sPwrMonVoltage2) {
        if (!this.pci.is455()) {
            this.hwCB.setSelectedItem(this.convertVoltage(sPwrMonVoltage2.high_voltage));
            this.lwCB.setSelectedItem(this.convertVoltage(sPwrMonVoltage2.low_voltage));
        }
        this.ehwCB.setSelectedItem(this.convertVoltage(sPwrMonVoltage2.ex_high_voltage));
        this.elwCB.setSelectedItem(this.convertVoltage(sPwrMonVoltage2.ex_low_voltage));
        this.voltageLB.setText(chassisVtgType[sPwrMonVoltage2.voltage_type.value()]);
    }

    protected int convertVoltage(Double d) {
        int n = (int)(d * -1000.0);
        if (db.on()) {
            db.println("convertVoltage: vlt=" + d + " value=" + n);
        }
        return n;
    }

    protected Double convertVoltage(int n) {
        Double d = new Double((double)n / -1000.0);
        if (db.on()) {
            db.println("convertVoltage: vlt=" + n + " value=" + d);
        }
        return d;
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppPowerMonitorPane;
    }
}

