/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Security.NotAuthenticated;
import cerent.cms.idl.Security.eAccessState;
import cerent.cms.idl.Security.eSecurityLevel;
import cerent.cms.idl.Security.eSerialPortId;
import cerent.cms.model.AccessMechanism;
import cerent.cms.model.AccessState;
import cerent.cms.model.Attribute;
import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.ISecureIpConfig;
import cerent.cms.model.InvalidRange;
import cerent.cms.model.IpConfigError;
import cerent.cms.model.LANAccessMode;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.Operation;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SecurityModel;
import cerent.cms.model.enum.SecurityEnumStrings;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.IntegerDocument;
import cerent.util.gui.SpinPropertyEditor;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SppSecurityAccessPane
extends NodeProvPane
implements ActionListener,
PropertyChangeListener,
DocumentListener {
    protected static final int IIOP_DEFAULT_PORT = 57790;
    protected static final int SSLIOP_DEFAULT_PORT = 57791;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "SppSecurityAccessPane");
    private static final Dimension ROW_SIZE = new Dimension(TabbedView.TABBED_VIEW_DIM.width - 200, 25);
    private static final int PORT_LENGTH = 5;
    private static final Dimension lblDim = new Dimension(130, 20);
    private static final String TELNET_PORT = "Telnet Port:";
    private static final String SSH_PORT = "SSH Port:";
    private static final String SFTP_PORT = "SFTP Port:";
    private boolean bInit;
    private JComboBox lanAccessCB;
    private JComboBox tl1AccessCB;
    private JComboBox snmpAccessCB;
    private JComboBox shellAccessCB;
    private JComboBox emsAccessCB;
    private JLabel shellPortLabel;
    private JLabel sftpPortLabel;
    private SpinPropertyEditor restoreLanAccess;
    private JTextField shellPortTF;
    private JTextField sftpPortTF;
    private JButton useStandardTelnetB;
    private JCheckBox enforceShellPasswordCB;
    private JCheckBox enableCraftPortACB;
    private JCheckBox enableCraftPortBCB;
    private ButtonGroup shellAccessBG;
    private JComboBox pmClearingCB;
    private JPanel iiopPanel;
    private int iiopPortVal;
    private int oldPortVal;
    private boolean mustReboot = false;
    private SecurityModel secModel;
    private boolean lanAccessDirty = false;
    private JRadioButton tccPortRB;
    private JRadioButton omgPortRB;
    private JRadioButton customPortRB;
    private JTextField customPortTF;

    public SppSecurityAccessPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
    }

    public void destroy() {
        if (this.secModel != null) {
            this.secModel.deleteObserver((Observer)((Object)this));
        }
        if (this.pmClearingCB != null) {
            this.pmClearingCB.removeActionListener(this);
        }
        super.destroy();
    }

    public boolean hasSubTabs() {
        return false;
    }

    public boolean onValidate() {
        if (this.lanAccessDirty && this.secModel.getLANAccess().transitionMayDisconnect((LANAccessMode)this.lanAccessCB.getSelectedItem()) && !CerentDialog.yesNoDialog((Component)((Object)this), (String)"Changing the LAN Access may lead to loss of communication with the node.\nMake the change anyway?", (String)"Change LAN Access Mode")) {
            return false;
        }
        try {
            this.validateIiopPort();
        }
        catch (IpConfigError ipConfigError) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CONFIG_PARAM_1, (Object)ipConfigError.getMessage());
            return false;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_VALIDATION_ERROR);
            return false;
        }
        return !this.mustReboot || this.oldPortVal == this.iiopPortVal || CerentDialog.yesNoDialog((Component)((Object)this), (String)("Changing the " + this.pci.getControlCardName() + " CORBA listening port will cause a reboot or\n" + "protection switch of the active " + this.pci.getControlCardName() + " and may lead to loss\n" + "of communication with the node.\n\n" + "Make the change anyway?"), (String)("Change " + this.pci.getControlCardName() + " CORBA Listening Port"));
    }

    protected void validateIiopPort() throws Exception {
        AccessState accessState = this.getNewAccessState(this.emsAccessCB);
        if (this.tccPortRB.isSelected()) {
            this.iiopPortVal = accessState == AccessState.SECURE ? 57791 : 57790;
            return;
        }
        if (this.omgPortRB.isSelected()) {
            this.iiopPortVal = accessState == AccessState.SECURE ? 684 : 683;
            return;
        }
        try {
            this.iiopPortVal = Integer.parseInt(this.customPortTF.getText());
        }
        catch (Exception exception) {
            this.println("Invalid IIOP/SSLIOP Port");
            if (accessState == AccessState.SECURE) {
                throw new IpConfigError("SSLIOP Listener Port must be in the range  [1 - 65535].");
            }
            throw new IpConfigError("IIOP Listener Port must be in the range  [1 - 65535].");
        }
    }

    public void applyChangesToModel() throws Exception {
        Object object;
        AccessState accessState;
        AccessState accessState2;
        this.println("applyChangesToModel: start");
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        IIpConfig iIpConfig = nodeModelDelegate.getIpConfig();
        boolean bl = false;
        int n = this.getIntValue("LAN Access Restore", (String)this.restoreLanAccess.getValue());
        if (n != this.secModel.getLANAccessTimeout()) {
            this.secModel.setLANAccessTimeout(n);
        }
        boolean bl2 = this.enableCraftPortACB.isSelected();
        if (this.secModel.getSerialPortAccess(eSerialPortId.CRAFT_PORT_A) != bl2) {
            this.secModel.setSerialPortAccess(eSerialPortId.CRAFT_PORT_A, bl2);
        }
        if (this.enableCraftPortBCB != null) {
            bl2 = this.enableCraftPortBCB.isSelected();
            if (this.secModel.getSerialPortAccess(eSerialPortId.CRAFT_PORT_B) != bl2) {
                this.secModel.setSerialPortAccess(eSerialPortId.CRAFT_PORT_B, bl2);
            }
        }
        LANAccessMode lANAccessMode = (LANAccessMode)this.lanAccessCB.getSelectedItem();
        if (!this.secModel.getLANAccess().equals(lANAccessMode)) {
            this.secModel.setLANAccess(lANAccessMode);
        }
        if ((accessState2 = this.secModel.getAccessState(AccessMechanism.SHELL_ACCESS)) != (accessState = this.getNewAccessState(this.shellAccessCB))) {
            this.secModel.setAccessState(AccessMechanism.SHELL_ACCESS, accessState);
        }
        if (accessState == AccessState.NONSECURE && (n = this.getIntValue("Telnet port", this.shellPortTF.getText())) != this.secModel.getTelnetPort()) {
            this.secModel.setTelnetPort(n);
        }
        if (this.enforceShellPasswordCB.isSelected() != this.secModel.isEnforceShellPassword()) {
            if (this.enforceShellPasswordCB.isSelected()) {
                this.secModel.setEnforceShellPasswordOn();
            } else {
                object = CerentDialog.inputPasswordDialog((Component)((Object)this), (String)"Turn off enforce shell password, please enter the current shell password.", (String)"Disable Shell Password");
                if (object != null) {
                    try {
                        this.secModel.setEnforceShellPasswordOff((String)object);
                    }
                    catch (NotAuthenticated notAuthenticated) {
                        this.enforceShellPasswordCB.setSelected(true);
                        ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_AUTH_ERROR, notAuthenticated.toString());
                    }
                } else {
                    this.enforceShellPasswordCB.setSelected(true);
                }
            }
        }
        if ((accessState2 = this.secModel.getAccessState(AccessMechanism.TL1_ACCESS)) != (accessState = this.getNewAccessState(this.tl1AccessCB))) {
            this.secModel.setAccessState(AccessMechanism.TL1_ACCESS, accessState);
        }
        if ((accessState2 = this.secModel.getAccessState(AccessMechanism.SNMP_ACCESS)) != (accessState = this.getNewAccessState(this.snmpAccessCB))) {
            this.secModel.setAccessState(AccessMechanism.SNMP_ACCESS, accessState);
        }
        if ((accessState2 = this.secModel.getAccessState(AccessMechanism.EMS_ACCESS)) != (accessState = this.getNewAccessState(this.emsAccessCB))) {
            this.secModel.setAccessState(AccessMechanism.EMS_ACCESS, accessState);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    IgnorableDialog.infoDialog((Component)((Object)SppSecurityAccessPane.this), (String)"CTC will now change to network view.\n", (String)"EMS Access State Changed", (String)"NotifyEMSAccessStateChanged", (String)"Notify of change to network view when EMS Access State changed");
                }
            });
        }
        if (this.mustReboot && this.oldPortVal != this.iiopPortVal) {
            if (accessState == AccessState.NONSECURE) {
                iIpConfig.setIiopPort((short)this.iiopPortVal);
                this.println("setting IIOP port to " + this.iiopPortVal);
            } else if (accessState == AccessState.SECURE) {
                iIpConfig.setSsliopPort((short)this.iiopPortVal);
                this.println("setting SSLIOP port to " + this.iiopPortVal);
            } else {
                this.println("Invalid EMS Access state");
            }
            try {
                if (nodeModelDelegate.getPlatform().isSecureModeSupported() && nodeModelDelegate.isSecureMode()) {
                    object = nodeModelDelegate.getSecureIpConfig();
                    nodeModelDelegate.setSecureIpConfig(iIpConfig, (ISecureIpConfig)object);
                } else {
                    nodeModelDelegate.setIpConfig(iIpConfig);
                }
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("applyChangesToModel: Error setting IpConfig");
                }
                throw new Exception(exception.getMessage());
            }
        }
        if (((eSecurityLevel)(object = eSecurityLevel.from_int(((Attribute)this.pmClearingCB.getSelectedItem()).getValue()))).value() != this.secModel.getOperationPrivilege(Operation.CLEAR_PM).value()) {
            this.secModel.setOperationPrivilege(Operation.CLEAR_PM, SecurityLevel.from_int((int)((eSecurityLevel)object).value()));
        }
        this.println("applyChangesToModel: end");
    }

    private AccessState getNewAccessState(JComboBox jComboBox) {
        Attribute attribute = (Attribute)jComboBox.getSelectedItem();
        return AccessState.from_int(attribute.getIntValue());
    }

    private void println(String string) {
        if (db.on()) {
            db.println(string);
        }
    }

    public void refreshFromModel() throws Exception {
        try {
            this.refreshMe();
        }
        catch (CmsCommFailException cmsCommFailException) {
            // empty catch block
        }
    }

    private void refreshMe() throws Exception {
        boolean bl;
        this.println("refreshFromModel: start");
        this.lanAccessCB.setSelectedItem(this.secModel.getLANAccess());
        this.restoreLanAccess.setValue(Integer.toString(this.secModel.getLANAccessTimeout()));
        this.restoreLanAccess.setValue(Integer.toString(this.secModel.getLANAccessTimeout()));
        this.lanAccessDirty = false;
        AccessState accessState = this.secModel.getAccessState(AccessMechanism.SHELL_ACCESS);
        Attribute attribute = SecurityEnumStrings.get(eAccessState.class, accessState.intValue());
        if (attribute != null) {
            this.shellAccessCB.setSelectedItem(attribute);
        }
        if (bl = this.secModel.isEnforceShellPassword()) {
            this.enforceShellPasswordCB.setSelected(true);
        } else {
            this.enforceShellPasswordCB.setSelected(false);
        }
        boolean bl2 = this.secModel.getSerialPortAccess(eSerialPortId.CRAFT_PORT_A);
        this.enableCraftPortACB.setSelected(bl2);
        if (this.enableCraftPortBCB != null) {
            bl2 = this.secModel.getSerialPortAccess(eSerialPortId.CRAFT_PORT_B);
            this.enableCraftPortBCB.setSelected(bl2);
        }
        this.setShellAccessUI(accessState);
        accessState = this.secModel.getAccessState(AccessMechanism.EMS_ACCESS);
        attribute = SecurityEnumStrings.get(eAccessState.class, accessState.intValue());
        if (attribute != null) {
            this.emsAccessCB.setSelectedItem(attribute);
        }
        this.setEmsAccessUI(accessState);
        accessState = this.secModel.getAccessState(AccessMechanism.TL1_ACCESS);
        attribute = SecurityEnumStrings.get(eAccessState.class, accessState.intValue());
        if (attribute != null) {
            this.tl1AccessCB.setSelectedItem(attribute);
        }
        if ((attribute = SecurityEnumStrings.get(eAccessState.class, (accessState = this.secModel.getAccessState(AccessMechanism.SNMP_ACCESS)).intValue())) != null) {
            this.snmpAccessCB.setSelectedItem(attribute);
        }
        this.pmClearingCB.setSelectedItem(ElementDefaults.getAttributeMap((NodeModelDelegate)this.getUiModel().getNodeModel()).getAttributeForVal("superuserGrantPermission", this.secModel.getOperationPrivilege(Operation.CLEAR_PM).value()));
        this.println("refreshFromModel: finish");
    }

    private void setShellAccessUI(AccessState accessState) {
        if (accessState == AccessState.NONSECURE) {
            this.shellPortLabel.setVisible(true);
            this.shellPortTF.setVisible(true);
            this.shellPortTF.setEnabled(true);
            this.shellPortLabel.setText(TELNET_PORT);
            this.shellPortTF.setText(Integer.toString(this.secModel.getTelnetPort()));
            this.useStandardTelnetB.setVisible(true);
            this.sftpPortLabel.setVisible(false);
            this.sftpPortTF.setVisible(false);
        } else if (accessState == AccessState.SECURE) {
            this.shellPortLabel.setVisible(true);
            this.shellPortTF.setVisible(true);
            this.shellPortTF.setEnabled(false);
            this.shellPortLabel.setText(SSH_PORT);
            this.shellPortTF.setText(Integer.toString(this.secModel.getSshPort()));
            this.useStandardTelnetB.setVisible(false);
            this.sftpPortLabel.setVisible(true);
            this.sftpPortTF.setVisible(true);
            this.sftpPortTF.setText(Integer.toString(this.secModel.getSftpPort()));
        } else {
            this.shellPortLabel.setVisible(false);
            this.shellPortTF.setVisible(false);
            this.useStandardTelnetB.setVisible(false);
            this.sftpPortLabel.setVisible(false);
            this.sftpPortTF.setVisible(false);
        }
    }

    private void setEmsAccessUI(AccessState accessState) {
        if (this.iiopPanel == null) {
            return;
        }
        String string = this.pci.getControlCardName();
        if (accessState == AccessState.NONSECURE) {
            this.iiopPanel.setBorder(new TitledBorder(string + " CORBA (IIOP) Listener Port"));
            this.omgPortRB.setText("Standard Constant (683)");
        } else {
            this.iiopPanel.setBorder(new TitledBorder(string + " CORBA (SSLIOP) Listener Port"));
            this.omgPortRB.setText("Standard Constant (684)");
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        IIpConfig iIpConfig = nodeModelDelegate.getIpConfig();
        this.iiopPortVal = accessState == AccessState.SECURE ? iIpConfig.getSsliopPort() & 0xFFFF : iIpConfig.getIiopPort() & 0xFFFF;
        if (this.iiopPortVal == 57790 || this.iiopPortVal == 57791) {
            this.customPortTF.setText("");
            this.customPortTF.setEnabled(false);
            this.tccPortRB.setSelected(true);
        } else if (this.iiopPortVal == 683 || this.iiopPortVal == 684) {
            this.customPortTF.setText("");
            this.customPortTF.setEnabled(false);
            this.omgPortRB.setSelected(true);
        } else {
            this.customPortTF.setEnabled(true);
            this.customPortTF.setText(String.valueOf(this.iiopPortVal));
            this.customPortRB.setSelected(true);
        }
        this.oldPortVal = this.iiopPortVal;
        this.mustReboot = false;
    }

    public void update(Observable observable, Object object) {
        this.println("update: start");
        this.requestRefresh(this, null);
    }

    public void enteringPage() throws Exception {
        this.secModel = (SecurityModel)((NodeModelDelegate)this.getUiModel().getNodeModel()).getSecurityModel();
        if (!this.bInit) {
            this.init();
        }
        if (this.secModel != null) {
            this.secModel.addObserver((Observer)((Object)this));
        }
        super.enteringPage();
    }

    public void leavingPage() throws Exception {
        super.leavingPage();
        if (this.secModel != null) {
            this.secModel.deleteObserver((Observer)((Object)this));
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppSecurityAccessPane;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.useStandardTelnetB)) {
            this.shellPortTF.setText(Integer.toString(this.secModel.getStandardTelnetPort()));
        } else if (object.equals(this.lanAccessCB)) {
            this.lanAccessDirty = true;
        } else if (object.equals(this.shellAccessCB)) {
            AccessState accessState = this.getNewAccessState(this.shellAccessCB);
            AccessState accessState2 = this.secModel.getAccessState(AccessMechanism.SHELL_ACCESS);
            if (accessState == AccessState.DISABLED && accessState != accessState2) {
                String string = ErrorMsg.getString((EID)EMC.WID_DISABLE_SHELL_ACCESS_WARNING);
                IgnorableDialog.warningDialog((String)string, (String)"WarnShellAccessDisable", (String)"Warn Shell Access Disable");
            }
            this.setShellAccessUI(accessState);
        } else if (object.equals(this.emsAccessCB)) {
            this.setEmsAccessUI(this.getNewAccessState(this.emsAccessCB));
        } else if (object == this.tccPortRB || object == this.omgPortRB) {
            this.customPortTF.setEnabled(false);
            this.mustReboot = true;
        } else if (object == this.customPortRB) {
            this.customPortTF.setEnabled(true);
            this.mustReboot = true;
        }
        this.setDirty();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    private void updateLANAccessCB(boolean bl) {
        if (bl) {
            this.lanAccessCB.addItem(LANAccessMode.FRONT_ONLY);
        }
    }

    private void generalChanges(DocumentEvent documentEvent) {
        this.setDirty();
        if (this.customPortTF != null && documentEvent.getDocument() == this.customPortTF.getDocument()) {
            if (documentEvent.getType() != DocumentEvent.EventType.REMOVE) {
                this.customPortRB.setSelected(true);
            }
            this.mustReboot = true;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.generalChanges(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.generalChanges(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.generalChanges(documentEvent);
    }

    private void init() {
        JPanel jPanel = SppSecurityAccessPane.createVerticalPanel(null);
        this.add((Component)new UScrollPane((Component)jPanel));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(this.getLANAccessPanel());
        jPanel2.add(this.getSerialAccessPanel());
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(this.getShellAccessPanel());
        jPanel2.add(this.getEmsAccessPanel());
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(this.getTl1AccessPanel());
        jPanel2.add(this.getSnmpAccessPanel());
        jPanel.add(jPanel2);
        jPanel.add(this.getOtherInfoPanel());
        this.bInit = true;
    }

    private JPanel getLANAccessPanel() {
        JPanel jPanel = SppSecurityAccessPane.createVerticalPanel("LAN Access");
        this.lanAccessCB = new JComboBox<LANAccessMode>(this.pci.getSupportedLanAccessModes());
        jPanel.add(SppSecurityAccessPane.createAttributePanel("LAN Access:", null, lblDim, this.lanAccessCB));
        this.lanAccessCB.addActionListener(this);
        jPanel.add(Box.createVerticalStrut(5));
        this.restoreLanAccess = new SpinPropertyEditor("", 1, 0, 60);
        jPanel.add(SppSecurityAccessPane.createAttributePanel("Restore Timeout:", " minute(s)", lblDim, this.restoreLanAccess));
        this.restoreLanAccess.addPropertyChangeListener(this);
        return jPanel;
    }

    private JPanel getSerialAccessPanel() {
        JPanel jPanel = SppSecurityAccessPane.createVerticalPanel("Serial Craft Access");
        if (this.pci.is600() || this.pci.is310ma()) {
            this.enableCraftPortACB = new JCheckBox("Enable Craft Port A");
            this.enableCraftPortACB.addActionListener(this);
            jPanel.add(this.enableCraftPortACB);
            this.enableCraftPortBCB = new JCheckBox("Enable Craft Port B");
            this.enableCraftPortBCB.addActionListener(this);
            jPanel.add(this.enableCraftPortBCB);
        } else {
            this.enableCraftPortACB = new JCheckBox("Enable Craft Port");
            this.enableCraftPortACB.addActionListener(this);
            jPanel.add(this.enableCraftPortACB);
        }
        return jPanel;
    }

    private JPanel getShellAccessPanel() {
        JPanel jPanel = SppSecurityAccessPane.createVerticalPanel("Shell Access");
        this.shellAccessCB = new JComboBox<Attribute>(this.getTl1AccessStates());
        jPanel.add(SppSecurityAccessPane.createAttributePanel("Access State:", null, lblDim, this.shellAccessCB));
        this.shellAccessCB.addActionListener(this);
        this.useStandardTelnetB = new JButton("Use Standard Port");
        this.useStandardTelnetB.addActionListener(this);
        this.useStandardTelnetB.setActionCommand("useStandardTelnet");
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        this.shellPortLabel = new JLabel(TELNET_PORT);
        this.shellPortLabel.setPreferredSize(lblDim);
        this.shellPortTF = new JTextField(6);
        jPanel2.add(this.shellPortLabel);
        jPanel2.add(this.shellPortTF);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.useStandardTelnetB);
        jPanel.add(jPanel2);
        this.shellPortTF.setDocument(new IntegerDocument(0, 65535, 5));
        this.shellPortTF.getDocument().addDocumentListener(this);
        jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        this.sftpPortLabel = new JLabel(SFTP_PORT);
        this.sftpPortLabel.setPreferredSize(lblDim);
        this.sftpPortTF = new JTextField(6);
        jPanel2.add(this.sftpPortLabel);
        jPanel2.add(this.sftpPortTF);
        jPanel.add(jPanel2);
        this.sftpPortTF.setDocument(new IntegerDocument(0, 65535, 5));
        this.sftpPortTF.setEnabled(false);
        this.enforceShellPasswordCB = new JCheckBox("Enable Shell Password");
        jPanel.add(SppSecurityAccessPane.createAttributePanel(null, null, null, this.enforceShellPasswordCB));
        this.enforceShellPasswordCB.addActionListener(this);
        return jPanel;
    }

    private JPanel getEmsAccessPanel() {
        JPanel jPanel = SppSecurityAccessPane.createVerticalPanel("EMS Access");
        this.emsAccessCB = new JComboBox<Attribute>(this.getEmsAccessStates());
        jPanel.add(SppSecurityAccessPane.createAttributePanel("Access State:", null, lblDim, this.emsAccessCB));
        jPanel.add(this.createIiopPanel(this.pci.getControlCardName()));
        this.emsAccessCB.addActionListener(this);
        return jPanel;
    }

    private JPanel createIiopPanel(String string) {
        this.println("Adding " + string + " IIOP listener port pane");
        this.iiopPanel = new JPanel();
        this.iiopPanel.setLayout(new BoxLayout(this.iiopPanel, 1));
        this.iiopPanel.setBorder(new TitledBorder(string + " CORBA (IIOP) Listener Port"));
        this.iiopPanel.setPreferredSize(new Dimension(SppSecurityAccessPane.ROW_SIZE.width / 2 - 40, 100));
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean bl = this.isUserAuthorized();
        this.tccPortRB = this.addRadioButton(this.iiopPanel, buttonGroup, "Default - " + string + " Fixed", bl, this);
        this.omgPortRB = this.addRadioButton(this.iiopPanel, buttonGroup, "Standard Constant (683)", bl, this);
        this.customPortRB = this.addRadioButton(this.iiopPanel, buttonGroup, "Other Constant:", bl, this);
        this.customPortTF = new JTextField(6);
        this.customPortTF.setEnabled(bl);
        this.customPortTF.setDocument(new IntegerDocument(0, 65535, 5));
        this.customPortTF.getDocument().addDocumentListener(this);
        int n = this.iiopPanel.getComponentCount() - 1;
        JPanel jPanel = (JPanel)this.iiopPanel.getComponent(n);
        jPanel.add(this.customPortTF);
        return this.iiopPanel;
    }

    private JRadioButton addRadioButton(JPanel jPanel, ButtonGroup buttonGroup, String string, boolean bl, ActionListener actionListener) {
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.setAlignmentX(0.0f);
        jRadioButton.setEnabled(bl);
        jRadioButton.addActionListener(actionListener);
        jRadioButton.setSize(new Dimension(80, 20));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        jPanel2.add(jRadioButton);
        jPanel.add(jPanel2);
        buttonGroup.add(jRadioButton);
        return jRadioButton;
    }

    private JPanel getTl1AccessPanel() {
        JPanel jPanel = SppSecurityAccessPane.createVerticalPanel("TL1 Access");
        this.tl1AccessCB = new JComboBox<Attribute>(this.getTl1AccessStates());
        jPanel.add(SppSecurityAccessPane.createAttributePanel("Access State:", null, lblDim, this.tl1AccessCB));
        this.tl1AccessCB.addActionListener(this);
        return jPanel;
    }

    private JPanel getSnmpAccessPanel() {
        JPanel jPanel = SppSecurityAccessPane.createVerticalPanel("SNMP Access");
        this.snmpAccessCB = new JComboBox<Attribute>(this.getSnmpAccessStates());
        jPanel.add(SppSecurityAccessPane.createAttributePanel("Access State:", null, lblDim, this.snmpAccessCB));
        this.snmpAccessCB.addActionListener(this);
        return jPanel;
    }

    private Attribute[] getEmsAccessStates() {
        return SecurityEnumStrings.get(eAccessState.class, SecurityEnumStrings.EMS_ACCESS_STATES);
    }

    private Attribute[] getTl1AccessStates() {
        return SecurityEnumStrings.get(eAccessState.class, SecurityEnumStrings.TL1_ACCESS_STATES);
    }

    private Attribute[] getSnmpAccessStates() {
        return SecurityEnumStrings.get(eAccessState.class, SecurityEnumStrings.SNMP_ACCESS_STATES);
    }

    private JPanel getOtherInfoPanel() {
        JPanel jPanel = SppSecurityAccessPane.createVerticalPanel("Other");
        Dimension dimension = new Dimension(130, 20);
        this.pmClearingCB = new JComboBox<Attribute>(ElementDefaults.getAttributeMap((NodeModelDelegate)this.getUiModel().getNodeModel()).getAttributeArray("superuserGrantPermission"));
        jPanel.add(SppSecurityAccessPane.createAttributePanel("PM Clearing Privilege:", null, lblDim, this.pmClearingCB));
        this.pmClearingCB.addActionListener(this);
        return jPanel;
    }

    private static JPanel createAttributePanel(String string, String string2, Dimension dimension, JComponent jComponent) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        if (string != null) {
            JLabel jLabel = new JLabel(string);
            jLabel.setPreferredSize(dimension);
            jPanel.add(jLabel);
        }
        jPanel.add(jComponent);
        if (string2 != null) {
            jPanel.add(new JLabel(string2));
        }
        return jPanel;
    }

    private static JPanel createPortPanel(String string, JButton jButton, Dimension dimension, JComponent jComponent) {
        Object object;
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        if (string != null) {
            object = new JLabel(string);
            ((JComponent)object).setPreferredSize(dimension);
            jPanel.add((Component)object);
        }
        jPanel.add(jComponent);
        if (jButton != null) {
            object = jButton.getBorder();
            EmptyBorder emptyBorder = new EmptyBorder(0, 20, 0, 0);
            jButton.setBorder(new CompoundBorder(emptyBorder, (Border)object));
            jPanel.add(jButton);
        }
        jPanel.setAlignmentX(0.0f);
        return jPanel;
    }

    private int getIntValue(String string, String string2) throws Exception {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRange("Invalid range for " + string);
        }
    }
}

