/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Node.sSnmpTrapDestination;
import cerent.cms.model.ConfigError;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.InvalidData;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.MaxSnmpDestinations;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.SnmpComparator;
import cerent.cms.ui.shelf.SnmpCreationDialog;
import cerent.cms.ui.shelf.SnmpEditPane;
import cerent.cms.ui.shelf.SnmpListCellRenderer;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SppSnmpPane
extends NodeProvPane
implements ActionListener,
ListSelectionListener {
    public static final String CREATE = "Create...";
    public static final String DELETE = "Delete...";
    public static final String ALLOW_SNMP_SETS = "Allow SNMP Sets";
    public static final String ALLOW_SNMP_PROXY = "Allow SNMP Proxy";
    public static final String USE_GENERIC_MIB = "Use Generic Mib";
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "SppSnmpPane");
    private DefaultListModel tdListModel;
    private JList tdList;
    private JButton createPB;
    private JButton deletePB;
    private JCheckBox allowSetsCB;
    private JCheckBox allowProxyCB;
    private JCheckBox useGenericMibCB;
    private boolean remainDirty;
    private boolean allowSetsDirty;
    private boolean allowProxyDirty;
    private boolean useGenericMibDirty = false;
    private boolean isSecure = false;
    SnmpEditPane editPane;

    public SppSnmpPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    private void init() {
        NodeModelDelegate nodeModelDelegate;
        if (db.on()) {
            db.println("<init>: start");
        }
        if ((nodeModelDelegate = this.getNMD()).getPlatform().isSecureModeSupported()) {
            this.isSecure = nodeModelDelegate.isSecureMode();
        }
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagPanel.fillBoth();
        gridBagPanel.add((Component)this.createTrapDestPane(), 0, 1);
        gridBagPanel.fillBoth();
        gridBagPanel.add((Component)this.createEditPane(), 1, 1);
        gridBagPanel.fillHorizontal();
        gridBagPanel.anchorCenter();
        GridBagPanel gridBagPanel2 = new GridBagPanel();
        gridBagPanel2.inset(30, 0);
        gridBagPanel2.add((Component)this.createSNMPSetPane(), 0, 1);
        gridBagPanel2.add((Component)this.createSNMPProxyPane(), 1, 1);
        if (this.pci.is454() || this.pci.is455()) {
            gridBagPanel2.add((Component)this.createUseGenericMibPane(), 2, 1);
        }
        gridBagPanel.addRemainder(gridBagPanel2, 0, 2);
        this.add((Component)new UScrollPane((Component)gridBagPanel));
        this.registerWithModel();
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    private JPanel createTrapDestPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Trap Destinations"));
        this.tdListModel = new DefaultListModel();
        this.tdList = new JList(this.tdListModel);
        this.tdList.setCellRenderer(new SnmpListCellRenderer());
        this.tdList.setSelectionMode(0);
        this.tdList.setVisibleRowCount(6);
        this.tdList.setMinimumSize(new Dimension(100, 10));
        this.tdList.addListSelectionListener(this);
        jPanel.add((Component)new UScrollPane((Component)this.tdList), "Center");
        jPanel.add((Component)this.getButtonBar(), "South");
        return jPanel;
    }

    private JPanel createEditPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.editPane = new SnmpEditPane(this);
        jPanel.add((Component)this.editPane, "Center");
        jPanel.setBorder(BorderFactory.createTitledBorder("Selected Destination"));
        return jPanel;
    }

    private JPanel createSNMPSetPane() {
        this.allowSetsCB = new JCheckBox(ALLOW_SNMP_SETS);
        this.allowSetsCB.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.allowSetsCB, "Center");
        if (!this.canEdit()) {
            this.allowSetsCB.setEnabled(false);
        }
        return jPanel;
    }

    private JPanel createSNMPProxyPane() {
        this.allowProxyCB = new JCheckBox(ALLOW_SNMP_PROXY);
        this.allowProxyCB.addActionListener(this);
        JPanel jPanel = new JPanel();
        if (this.pci.isSnmpProxyCapable()) {
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.allowProxyCB, "Center");
            if (!this.canEdit()) {
                this.allowProxyCB.setEnabled(false);
            }
        }
        return jPanel;
    }

    private JPanel createUseGenericMibPane() {
        this.useGenericMibCB = new JCheckBox(USE_GENERIC_MIB);
        this.useGenericMibCB.addActionListener(this);
        JPanel jPanel = new JPanel();
        if (this.pci.is454() || this.pci.is455()) {
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.useGenericMibCB, "Center");
            if (!this.canEdit()) {
                this.useGenericMibCB.setEnabled(false);
            }
        }
        return jPanel;
    }

    private JPanel getButtonBar() {
        this.createPB = new JButton(CREATE);
        this.deletePB = new JButton(DELETE);
        JPanel jPanel = SppSnmpPane.createHorizontalPanel(null);
        if (this.canEdit()) {
            this.createPB.addActionListener(this);
            this.deletePB.addActionListener(this);
            this.deletePB.setEnabled(false);
            jPanel.setLayout(new FlowLayout(1, 5, 5));
            jPanel.add(this.createPB);
            jPanel.add(this.deletePB);
        }
        return jPanel;
    }

    private void enableDelete(int n) {
        this.deletePB.setEnabled(n >= 0 && this.canDisplay());
    }

    private void enableDelete() {
        this.enableDelete(this.tdList.getSelectedIndex());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.enableDelete();
            try {
                this.editPane.setTrapDest((sSnmpTrapDestination)this.tdList.getSelectedValue());
            }
            catch (Exception exception) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                this.tdList.setSelectedValue(this.editPane.getTrapDest(), true);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.createPB) {
            SnmpCreationDialog.instance(this).show();
        } else if (object == this.deletePB) {
            sSnmpTrapDestination sSnmpTrapDestination2 = (sSnmpTrapDestination)this.tdList.getSelectedValue();
            IIpAddr iIpAddr = IpAddrFactory.getIIpAddr(sSnmpTrapDestination2.ipAddress);
            String string = InetUtil.makeDottedString(iIpAddr);
            if (CerentDialog.yesNoDialog((Component)((Object)this), (String)("Really delete \"" + string + "\"?"), (String)"Delete Trap Destination?")) {
                try {
                    this.editPane.setTrapDest(null);
                    this.getNMD().deleteSnmpTrapDestination(IpAddrFactory.getIpAddr(iIpAddr));
                    this.tdListModel.removeElement(sSnmpTrapDestination2);
                }
                catch (Exception exception) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_DELETE_TRAP);
                }
            }
        } else if (object == this.allowSetsCB) {
            this.allowSetsDirty = true;
            this.setDirty();
        } else if (object == this.allowProxyCB) {
            this.allowProxyDirty = true;
            this.setDirty();
        } else if (object == this.useGenericMibCB) {
            this.useGenericMibDirty = true;
            this.setDirty();
        }
    }

    public boolean onValidate() {
        try {
            this.validateFields();
            return true;
        }
        catch (InvalidData invalidData) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_SNMP_DESTINATION_PARAM_1, (Object)invalidData.getMessage());
            return false;
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_VALIDATION_ERROR);
            return false;
        }
    }

    public void applyChangesToModel() throws MaxSnmpDestinations, UnsupportedOperation, ConfigError {
        boolean bl;
        if (db.on()) {
            db.println("applyChangesToModel");
        }
        NodeModelDelegate nodeModelDelegate = this.getNMD();
        boolean bl2 = this.allowSetsCB.isSelected();
        boolean bl3 = this.allowSetsDirty && bl2;
        boolean bl4 = this.allowSetsDirty && !bl2;
        boolean bl5 = this.allowProxyCB.isSelected();
        boolean bl6 = this.allowProxyDirty && bl5;
        boolean bl7 = this.allowProxyDirty && !bl5;
        boolean bl8 = false;
        if (this.pci.is454() || this.pci.is455()) {
            bl8 = this.useGenericMibCB.isSelected();
        }
        boolean bl9 = this.useGenericMibDirty && bl8;
        boolean bl10 = bl = this.useGenericMibDirty && !bl8;
        if (bl3) {
            nodeModelDelegate.allowSnmpSets(bl2);
            this.allowSetsDirty = false;
        } else if (bl4 && CerentDialog.yesNoDialog((Component)((Object)this), (String)"Warning: All SNMP sets will be disabled.\nApply changes anyway?", (String)"Confirmation Dialog")) {
            nodeModelDelegate.allowSnmpSets(bl2);
            this.allowSetsDirty = false;
        }
        if (bl6) {
            nodeModelDelegate.allowSnmpProxy(bl5);
            this.allowProxyDirty = false;
        } else if (bl7 && CerentDialog.yesNoDialog((Component)((Object)this), (String)"Warning: All SNMP proxies will be disabled.\nApply changes anyway?", (String)"Confirmation Dialog")) {
            nodeModelDelegate.allowSnmpProxy(bl5);
            this.allowProxyDirty = false;
        }
        if (bl9) {
            nodeModelDelegate.setGenericMib(bl8);
            this.useGenericMibDirty = false;
        } else if (bl && CerentDialog.yesNoDialog((Component)((Object)this), (String)"Warning: Use Generic Mib will be disabled.\nApply changes anyway?", (String)"Confirmation Dialog")) {
            nodeModelDelegate.setGenericMib(bl8);
            this.useGenericMibDirty = false;
        }
        this.remainDirty = this.allowSetsDirty || this.allowProxyDirty || this.useGenericMibDirty;
        this.editPane.applyChangesToModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        try {
            this.setCursor(3);
            if (this.createPB == null && this.deletePB == null) {
                this.init();
            }
        }
        finally {
            this.setCursor(0);
        }
        super.enteringPage();
    }

    public void refreshFromModel() throws InvalidData {
        NodeModelDelegate nodeModelDelegate = this.getNMD();
        if (nodeModelDelegate == null) {
            if (db.on()) {
                db.println("Node Model is null in SppSnmpPane::refresh()");
            }
            return;
        }
        if (!nodeModelDelegate.getConnectionState()) {
            if (db.on()) {
                db.println("SppSnmpPane::refresh(): node is disconnected");
            }
            return;
        }
        if (this.canDisplay()) {
            ArrayList arrayList = new ArrayList(nodeModelDelegate.getSnmpTrapDestinations());
            Collections.sort(arrayList, new SnmpComparator());
            this.tdListModel.setSize(arrayList.size());
            int n = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.tdListModel.setElementAt(iterator.next(), n++);
            }
            n = this.tdList.getSelectedIndex();
            this.enableDelete(n);
            try {
                this.editPane.setTrapDest(n >= 0 ? (sSnmpTrapDestination)arrayList.get(n) : null);
            }
            catch (Exception exception) {
                this.tdList.setSelectedValue(this.editPane.getTrapDest(), true);
            }
            this.editPane.refreshFromModel();
            this.allowSetsCB.setSelected(nodeModelDelegate.allowSnmpSets());
            if (this.pci.isSnmpProxyCapable()) {
                this.allowProxyCB.setSelected(nodeModelDelegate.allowSnmpProxy());
            }
            if (this.pci.is454() || this.pci.is455()) {
                this.useGenericMibCB.setSelected(nodeModelDelegate.getGenericMib());
            }
        }
        this.resetDirty();
    }

    private boolean canDisplay() {
        if (this.isUserAuthorized(SecurityLevel.SUPERUSER)) {
            return true;
        }
        if (this.isSecure) {
            return false;
        }
        return this.isUserAuthorized(SecurityLevel.PROVISIONING) || this.isUserAuthorized(SecurityLevel.MAINTENANCE) || this.isUserAuthorized(SecurityLevel.RETRIEVE);
    }

    private boolean canEdit() {
        if (this.isUserAuthorized(SecurityLevel.SUPERUSER)) {
            return true;
        }
        if (this.isSecure) {
            return false;
        }
        return this.isUserAuthorized(SecurityLevel.PROVISIONING);
    }

    protected boolean queryRemainDirty() {
        return this.remainDirty;
    }

    protected void validateFields() throws InvalidData {
        this.editPane.validateFields();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppSnmpPane;
    }

    public NodeModelDelegate getNMD() {
        return (NodeModelDelegate)this.getUiModel().getNodeModel();
    }
}

