/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IModel;
import cerent.cms.model.IStaticRoute;
import cerent.cms.ui.Pane;
import cerent.cms.ui.shelf.StaticRouteEditPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class StaticRouteEditDialog
extends UDialog
implements ActionListener {
    public static final String TITLE = "Edit Selected Static Route";
    private JButton okButton;
    private JButton cancelButton;
    StaticRouteEditPane attributesPane;

    public static StaticRouteEditDialog instance(Pane pane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        IModel iModel = pane.getUiModel();
        return new StaticRouteEditDialog(frame, iModel);
    }

    private StaticRouteEditDialog(Frame frame, Object object) {
        super(frame, TITLE, true, object);
    }

    public void setStaticRoute(IStaticRoute iStaticRoute) {
        this.attributesPane.setStaticRoute(iStaticRoute);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        jPanel.add((Component)this.getAttributesPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        this.attributesPane.setNodeModel(((IModel)object).getNodeModel());
    }

    public void dispose() {
        if (this.attributesPane != null) {
            this.attributesPane.destroy();
            this.attributesPane = null;
        }
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                if (this.attributesPane.onValidate()) {
                    this.apply();
                    this.dispose();
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_STATIC_ROUTE_FAIL);
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected void apply() throws Exception {
        this.attributesPane.setDirty();
        this.attributesPane.apply();
    }

    private JPanel getAttributesPanel() {
        this.attributesPane = new StaticRouteEditPane("StaticRouteEditPane");
        return this.attributesPane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

