/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.DefaultGreTunnelExists;
import cerent.cms.model.DefaultRouterConflict;
import cerent.cms.model.DestinationExists;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidMask;
import cerent.cms.model.InvalidNextHop;
import cerent.cms.model.InvalidStaticDefaultRouteMask;
import cerent.cms.model.InvalidStaticRouteToAllOnes;
import cerent.cms.model.InvalidStaticRouteToBroadcast;
import cerent.cms.model.InvalidStaticRouteToClassA;
import cerent.cms.model.InvalidStaticRouteToClassB;
import cerent.cms.model.InvalidStaticRouteToClassC;
import cerent.cms.model.InvalidStaticRouteToClassDE;
import cerent.cms.model.InvalidStaticRouteToInternalNet;
import cerent.cms.model.InvalidStaticRouteToLocalNet;
import cerent.cms.model.InvalidStaticRouteToSelf;
import cerent.cms.model.InvalidStaticRouteToSelfSubnet;
import cerent.cms.model.MaxStaticRoutes;
import cerent.cms.ui.shelf.StaticRouteAttributesPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;

public class StaticRouteEditPane
extends StaticRouteAttributesPane {
    private static SDebug db = new SDebug("StaticRouteEditPane");

    public StaticRouteEditPane(String string) {
        super(string, (INodeModel)null);
        this.destTF.setEnabled(false);
    }

    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("applyChangesToModel: start");
        }
        if (this.getStaticRoute() == null) {
            if (db.on()) {
                db.println("applyChangesToModel: IStaticRoute is null");
            }
            return;
        }
        try {
            this.nodeModel.setOspfStaticRoute(this.getStaticRoute());
        }
        catch (InvalidStaticRouteToSelf invalidStaticRouteToSelf) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_SELF_PARAM_1, (Object)"static");
        }
        catch (InvalidStaticRouteToSelfSubnet invalidStaticRouteToSelfSubnet) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_SELF_SUBNET_PARAM_1, (Object)"static");
        }
        catch (InvalidStaticRouteToAllOnes invalidStaticRouteToAllOnes) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_ALL_ONES_PARAM_1, (Object)"static");
        }
        catch (InvalidStaticRouteToLocalNet invalidStaticRouteToLocalNet) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_LOCAL_NET_PARAM_1, (Object)"static");
        }
        catch (InvalidMask invalidMask) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_INVALID_MASK);
        }
        catch (InvalidStaticDefaultRouteMask invalidStaticDefaultRouteMask) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DEFAULT_ROUTE_MASK);
        }
        catch (InvalidStaticRouteToInternalNet invalidStaticRouteToInternalNet) {
            ErrorMsg.displayError((Component)((Object)this), EMC.EID_ROUTE_TO_INTERNAL_NET_2, "static", this.formatInternalSubnets());
        }
        catch (InvalidStaticRouteToClassDE invalidStaticRouteToClassDE) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_CLASS_DE_PARAM_1, (Object)"static");
        }
        catch (InvalidStaticRouteToClassA invalidStaticRouteToClassA) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_CLASS_A_PARAM_1, (Object)"static");
        }
        catch (InvalidStaticRouteToClassB invalidStaticRouteToClassB) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_CLASS_B_PARAM_1, (Object)"static");
        }
        catch (InvalidStaticRouteToClassC invalidStaticRouteToClassC) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_CLASS_C_PARAM_1, (Object)"static");
        }
        catch (InvalidStaticRouteToBroadcast invalidStaticRouteToBroadcast) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTE_TO_BROADCAST_PARAM_1, (Object)"static");
        }
        catch (InvalidNextHop invalidNextHop) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_STATIC_ROUTE_INVALID_NEXT_HOP_1, (Object)this.formatInternalSubnets());
        }
        catch (DefaultRouterConflict defaultRouterConflict) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_STATIC_ROUTE_DEFROUTER_CONFLICT);
        }
        catch (MaxStaticRoutes maxStaticRoutes) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_STATIC_ROUTE_MAX_REACHED);
        }
        catch (DestinationExists destinationExists) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_STATIC_ROUTE_DST_EXISTS);
        }
        catch (DefaultGreTunnelExists defaultGreTunnelExists) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_DEFAULT_STATIC_ROUTE);
        }
        if (db.on()) {
            db.println("applyChangesToModel: finish");
        }
    }
}

