/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OSI.xDuplicateTDC;
import cerent.cms.idl.OSI.xMaxTdcEntries;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.MaxOutstandingTarpRequests;
import cerent.cms.model.TarpRequestInited;
import cerent.cms.ui.shelf.OsiTarpDataCachePane;
import cerent.cms.ui.shelf.TdcCreationPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class TdcCreationDialog
extends UDialog
implements ActionListener {
    private JButton okButton;
    private JButton cancelButton;
    TdcCreationPane creationPane;
    static Object model;

    public static TdcCreationDialog instance(OsiTarpDataCachePane osiTarpDataCachePane) {
        return new TdcCreationDialog(osiTarpDataCachePane);
    }

    private TdcCreationDialog(OsiTarpDataCachePane osiTarpDataCachePane) {
        super(JOptionPane.getFrameForComponent((Component)((Object)osiTarpDataCachePane)), osiTarpDataCachePane.isProvision ? "Add Static Entry" : "TID to NSAP", true, (Object)osiTarpDataCachePane);
        model = osiTarpDataCachePane.getUiModel();
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        jPanel.add((Component)this.createAttributesPanel((OsiTarpDataCachePane)object), "Center");
        jPanel.add((Component)this.getButtonPanel(((OsiTarpDataCachePane)object).isProvision), "South");
    }

    public void dispose() {
        this.creationPane = null;
        super.dispose();
        model = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                this.creationPane.onValidate();
                this.apply();
                this.dispose();
            }
            catch (TarpRequestInited tarpRequestInited) {
                if (OsiTarpDataCachePane.db.on()) {
                    SDebug.printStackTrace((Throwable)tarpRequestInited);
                }
                ErrorMsg.displayWarning((Component)((Object)this), (EID)EMC.WID_TARP_REQUEST_INITED);
                this.dispose();
            }
            catch (MaxOutstandingTarpRequests maxOutstandingTarpRequests) {
                if (OsiTarpDataCachePane.db.on()) {
                    SDebug.printStackTrace((Throwable)maxOutstandingTarpRequests);
                }
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MAX_OUT_TARP_REQ);
            }
            catch (xMaxTdcEntries xMaxTdcEntries2) {
                SDebug.printStackTrace((Throwable)((Object)xMaxTdcEntries2));
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_TDC_MAX);
            }
            catch (xDuplicateTDC xDuplicateTDC2) {
                SDebug.printStackTrace((Throwable)((Object)xDuplicateTDC2));
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DUPLICATE_TDC);
            }
            catch (InternalCommError internalCommError) {
                SDebug.printStackTrace((Throwable)internalCommError);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSI_OPERATION_FAILURE);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CANT_ADD_TDC_ENTRY_PARAM_1, (Object)exception.getMessage());
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected void apply() throws Exception {
        this.creationPane.applyChangesToModel();
    }

    private JPanel createAttributesPanel(OsiTarpDataCachePane osiTarpDataCachePane) {
        this.creationPane = new TdcCreationPane(osiTarpDataCachePane);
        return this.creationPane;
    }

    public JPanel getAttributesPanel() {
        return this.creationPane;
    }

    private JPanel getButtonPanel(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

