/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Common.sIpTunnel;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.TunnelsModel;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

class TunnelsDataSource
extends AbstractRowDataSource {
    private TunnelsModel _model;
    private ArrayList _data;
    private static final String[] _columnNames = new String[]{"Source Address", "Source Mask", "Source Length", "Destination Address", "Destination Mask", "Destination Length"};
    private static final Class[] _columnClasses = new Class[]{String.class, String.class, Integer.class, String.class, String.class, Integer.class};
    private static final SDebug db = new SDebug("TunnelsDataSource");

    TunnelsDataSource(TunnelsModel tunnelsModel) {
        this._model = tunnelsModel;
        this._data = new ArrayList();
        if (db.on()) {
            db.println("empty");
        }
    }

    private static void fetchValues(TunnelsModel tunnelsModel, ArrayList arrayList) {
        try {
            sIpTunnel[] sIpTunnelArray = tunnelsModel.getTunnels();
            for (int i = 0; i < sIpTunnelArray.length; ++i) {
                arrayList.add(new TunnelInfo(sIpTunnelArray[i]));
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            // empty catch block
        }
    }

    void refreshFromModel(SortableRowTableModel sortableRowTableModel) {
        block2: {
            try {
                ArrayList arrayList = new ArrayList();
                TunnelsDataSource.fetchValues(this._model, arrayList);
                SwingUtilities.invokeAndWait(new Refresher(sortableRowTableModel, arrayList));
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("exception: " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    ColumnRenderer[] getRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[_columnNames.length];
        for (int i = 0; i < _columnNames.length; ++i) {
            columnRendererArray[i] = new Renderer(i);
        }
        return columnRendererArray;
    }

    public synchronized Object getObjectAtRow(int n) {
        return this._data.get(n);
    }

    public synchronized int getRowCount() {
        return this._data.size();
    }

    public Class getRowObjectClass() {
        return TunnelInfo.class;
    }

    private class Renderer
    implements ColumnRenderer {
        private final int _column;

        Renderer(int n) {
            this._column = n;
        }

        public String getName() {
            return _columnNames[this._column];
        }

        public int getWidth() {
            return 96;
        }

        public int getAlignment() {
            return 2;
        }

        public boolean isResizable() {
            return true;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return jTable.getDefaultRenderer(_columnClasses[this._column]).getTableCellRendererComponent(jTable, ((TunnelInfo)object).getValueAt(n2), bl, bl2, n, n2);
        }

        public int compareColumn(Object object, Object object2, int n) {
            if (object instanceof TunnelInfo) {
                if (object2 instanceof TunnelInfo) {
                    return ((TunnelInfo)object).cmpValueAt((TunnelInfo)object2, n);
                }
                return -1;
            }
            return 1;
        }
    }

    private class Refresher
    implements Runnable {
        private SortableRowTableModel _tm;
        private ArrayList _newData;

        Refresher(SortableRowTableModel sortableRowTableModel, ArrayList arrayList) {
            this._tm = sortableRowTableModel;
            this._newData = arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TunnelsDataSource tunnelsDataSource = TunnelsDataSource.this;
            synchronized (tunnelsDataSource) {
                TunnelsDataSource.this._data = this._newData;
            }
            this._tm.dataSourceChanged();
            this._tm = null;
            this._newData = null;
        }
    }

    static class TunnelInfo {
        private sIpTunnel _tunnel;
        private String _srcAddress;
        private String _srcMask;
        private Integer _srcLength;
        private String _dstAddress;
        private String _dstMask;
        private Integer _dstLength;

        TunnelInfo(sIpTunnel sIpTunnel2) {
            this._tunnel = sIpTunnel2;
            this._srcAddress = TunnelInfo.asString(this._tunnel.source.address);
            this._srcMask = TunnelInfo.asString(this._tunnel.source.mask);
            this._srcLength = TunnelInfo.getLength(this._tunnel.source.mask);
            this._dstAddress = TunnelInfo.asString(this._tunnel.destination.address);
            this._dstMask = TunnelInfo.asString(this._tunnel.destination.mask);
            this._dstLength = TunnelInfo.getLength(this._tunnel.destination.mask);
        }

        private static String asString(sIpAddr sIpAddr2) {
            return InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sIpAddr2));
        }

        private static Integer getLength(sIpAddr sIpAddr2) {
            int n = 0;
            for (int i = 12; i < 16; ++i) {
                int n2 = 128;
                for (int j = 0; j < 8 && (sIpAddr2.addr[i] & n2) != 0; ++j) {
                    ++n;
                    n2 >>>= 1;
                }
            }
            return new Integer(n);
        }

        sIpTunnel getTunnel() {
            return this._tunnel;
        }

        String getSourceAddress() {
            return this._srcAddress;
        }

        String getDestinationAddress() {
            return this._dstAddress;
        }

        String getSourceMask() {
            return this._srcMask;
        }

        String getDestinationMask() {
            return this._dstMask;
        }

        Integer getSourceLength() {
            return this._srcLength;
        }

        Integer getDestinationLength() {
            return this._dstLength;
        }

        Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this.getSourceAddress();
                }
                case 1: {
                    return this.getSourceMask();
                }
                case 2: {
                    return this.getSourceLength();
                }
                case 3: {
                    return this.getDestinationAddress();
                }
                case 4: {
                    return this.getDestinationMask();
                }
                case 5: {
                    return this.getDestinationLength();
                }
            }
            return null;
        }

        int cmpValueAt(TunnelInfo tunnelInfo, int n) {
            switch (n) {
                case 0: {
                    return this.getSourceAddress().compareTo(tunnelInfo.getSourceAddress());
                }
                case 1: {
                    return this.getSourceMask().compareTo(tunnelInfo.getSourceMask());
                }
                case 2: {
                    return this.getSourceLength().compareTo(tunnelInfo.getSourceLength());
                }
                case 3: {
                    return this.getDestinationAddress().compareTo(tunnelInfo.getDestinationAddress());
                }
                case 4: {
                    return this.getDestinationMask().compareTo(tunnelInfo.getDestinationMask());
                }
                case 5: {
                    return this.getDestinationLength().compareTo(tunnelInfo.getDestinationLength());
                }
            }
            return -1;
        }
    }
}

