/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp;

import cerent.cms.model.Attribute;
import cerent.cms.model.LmpConstants;
import cerent.cms.model.LmpException;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.Pane;
import cerent.cms.ui.shelf.lmp.DataLinkDataSource;
import cerent.cms.ui.shelf.lmp.PortWrapper;
import cerent.cms.ui.shelf.lmp.TeLinkDataSource;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.gui.TextAreaDialog;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DataLinkCreationDialog
extends UDialog
implements ActionListener,
LmpConstants {
    public static final String TITLE = "Create LMP Data Link";
    private JButton okButton;
    private JButton cancelButton;
    private Pane parent;
    protected DataLinkDataSource dsc;
    protected DataLinkDataSource.Info value;
    protected JComboBox localPort;
    protected JTextField localPortId;
    protected JComboBox type;
    protected JComboBox localTeLinkId;
    protected JTextField remoteDataLinkId;
    private boolean ok = false;

    public static DataLinkCreationDialog getCreationDialog(Pane pane, DataLinkDataSource dataLinkDataSource) {
        return new DataLinkCreationDialog(JOptionPane.getFrameForComponent((Component)pane), TITLE, new Object[]{pane, dataLinkDataSource});
    }

    protected DataLinkCreationDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.ok = false;
        Object[] objectArray = (Object[])object;
        this.parent = (Pane)objectArray[0];
        this.dsc = (DataLinkDataSource)objectArray[1];
        if (this.value == null) {
            this.value = new DataLinkDataSource.Info(this.dsc);
        }
        jPanel.add((Component)this.getCenterPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        this.parent = null;
        this.dsc = null;
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.valuesOk()) {
                this.ok = true;
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.ok = false;
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    public boolean ok() {
        return this.ok;
    }

    public DataLinkDataSource.Info getValues() {
        return this.value;
    }

    private void displayStatusMessage(final String string, final String string2) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TextAreaDialog(JOptionPane.getFrameForComponent((Component)((Object)DataLinkCreationDialog.this)), string, string2, 650, 200);
            }
        });
    }

    private String toString(Exception exception) {
        int n;
        if (exception instanceof NumberFormatException) {
            return "invalid number format: " + exception.getMessage();
        }
        String string = exception.getMessage();
        if ((string == null || string.length() == 0) && (n = (string = exception.toString()).lastIndexOf(46)) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private boolean valuesOk() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DataLinkDataSource.Column column = this.dsc.getColumn("Local Port");
        try {
            column.setColumnValue(this.value, this.localPort.getSelectedItem());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Data Link Type");
        try {
            column.setColumnValue(this.value, this.type.getSelectedItem());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Local TE Link Id");
        try {
            column.setColumnValue(this.value, this.localTeLinkId.getSelectedItem());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Remote Port Id");
        try {
            column.setColumnValue(this.value, this.remoteDataLinkId.getText());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        if (arrayList.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Failed to validate LMP Data Link parameters:\n\n");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Exception exception = (Exception)iterator.next();
                stringBuffer.append(string);
                stringBuffer.append(": ");
                stringBuffer.append(this.toString(exception));
                stringBuffer.append("\n");
            }
            this.displayStatusMessage("LMP Data Link Validation Errors", stringBuffer.toString());
        }
        return arrayList.size() <= 0;
    }

    private void helpPutDefaultType(String string, JComboBox jComboBox) {
        jComboBox.setSelectedItem(this.dsc.getTypeChoice(this.dsc.getDefaultValue(string)));
    }

    private void putDefaults() {
        this.helpPutDefaultType("Data Link Type", this.type);
    }

    private JPanel getCenterPanel() {
        TeLinkDataSource.Info[] infoArray;
        PortWrapper[] portWrapperArray;
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 5, 5));
        try {
            portWrapperArray = this.dsc.getLocalPortChoices(this.value);
        }
        catch (LmpException lmpException) {
            ErrorMsg.displayError((Component)((Object)this), (EID)lmpException.getEid());
            portWrapperArray = new PortWrapper[]{};
        }
        try {
            infoArray = this.dsc.getTeLinkChoices();
        }
        catch (LmpException lmpException) {
            ErrorMsg.displayError((Component)((Object)this), (EID)lmpException.getEid());
            infoArray = new TeLinkDataSource.Info[]{};
        }
        jPanel.add(new JLabel("Local Port:", 4));
        this.localPort = new JComboBox<PortWrapper>(portWrapperArray);
        jPanel.add(this.localPort);
        jPanel.add(new JLabel("Local Port Id:", 4));
        this.localPortId = new JTextField(20);
        jPanel.add(this.localPortId);
        jPanel.add(new JLabel("Data Link Type:", 4));
        this.type = new JComboBox<Attribute>(this.dsc.getTypeChoices());
        jPanel.add(this.type);
        jPanel.add(new JLabel("Local TE Link Id:", 4));
        this.localTeLinkId = new JComboBox<TeLinkDataSource.Info>(infoArray);
        jPanel.add(this.localTeLinkId);
        jPanel.add(new JLabel("Remote Port Id:", 4));
        this.remoteDataLinkId = new JTextField(20);
        jPanel.add(this.remoteDataLinkId);
        this.putDefaults();
        this.localPortId.setEnabled(false);
        this.updateLocalPortId();
        this.localPort.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DataLinkCreationDialog.this.updateLocalPortId();
            }
        });
        return jPanel;
    }

    private void updateLocalPortId() {
        PortWrapper portWrapper = (PortWrapper)this.localPort.getSelectedItem();
        this.localPortId.setText(portWrapper != null ? this.dsc.asString(portWrapper.getPortId(), '0', 8) : "");
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        jPanel.add(new CSHelpButton(this.getCsHelpId()));
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected CSHelpID getCsHelpId() {
        return CSHelpConst.LmpDataLinkCreationDialog;
    }
}

