/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp;

import cerent.cms.idl.Lmp.sDataLinkAttrs;
import cerent.cms.model.LmpConstants;
import cerent.cms.model.LmpDataLinkModels;
import cerent.cms.model.LmpException;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractDataSourceControl;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.shelf.lmp.DataLinkCreationDialog;
import cerent.cms.ui.shelf.lmp.DataLinkDataSource;
import cerent.cms.ui.shelf.lmp.DataLinkDeletionDialog;
import cerent.cms.ui.shelf.lmp.DataLinkEditDialog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class DataLinkPane
extends ObserverPane
implements Observer,
LmpConstants {
    private static final String CREATE = "Create...";
    private static final String EDIT = "Edit...";
    private static final String DELETE = "Delete...";
    private JButton createButton;
    private JButton editButton;
    private JButton deleteButton;
    private JPanel buttonRow;
    private UScrollPane scrollPane;
    private NodeModelDelegate node;
    private Info dsc;

    public DataLinkPane(String string, LmpDataLinkModels lmpDataLinkModels, TabbedView tabbedView) {
        super(string, tabbedView);
        this.trace("<init>");
        this.node = (NodeModelDelegate)lmpDataLinkModels.getNodeModel();
        this.dsc = new Info(lmpDataLinkModels);
        this.setDataSourceControl(this.dsc);
    }

    public void destroy() {
        this.trace("destroy");
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.destroy();
    }

    public void enteringPage() throws Exception {
        this.trace("enteringPage");
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.getTable(), this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        this.trace("leavingPage");
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.leavingPage();
    }

    private void setTable(JTable jTable) {
        this.table = jTable;
    }

    public void update(Observable observable, Object object) {
        this.trace("update");
        this.requestRefresh(observable, null);
        this.manageButtons();
    }

    private void manageButtons() {
        boolean bl = this.isUserAuthorized();
        int n = this.dsc.getSelectedRowCount();
        this.createButton.setEnabled(bl);
        this.editButton.setEnabled(bl && n == 1);
        this.deleteButton.setEnabled(bl && n > 0);
    }

    private void trace(String string) {
        if (db.on()) {
            db.println("DataLinkPane." + string + "(" + this.node.getHostName() + ")");
        }
    }

    private class Info
    extends AbstractDataSourceControl {
        private LmpDataLinkModels _model;
        private ObservableManager _om;
        private DataLinkDataSource _ds;
        private SortableRowTableModel _tm;
        private Thread _updater;
        private boolean _needsUpdate;

        Info(LmpDataLinkModels lmpDataLinkModels) {
            this._model = lmpDataLinkModels;
            this._om = new ObservableManager(DataLinkPane.this, true);
            this._ds = null;
            this._tm = null;
            this._updater = null;
            this._needsUpdate = false;
        }

        private synchronized boolean needsUpdate() {
            if (this._needsUpdate) {
                this._needsUpdate = false;
                return true;
            }
            this._updater = null;
            return false;
        }

        private void doUpdate() {
            DataLinkPane.this.trace("doUpdate");
            try {
                this._ds.refreshFromModel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public synchronized void refreshFromModel() throws Exception {
            DataLinkPane.this.trace("refreshFromModel");
            this._needsUpdate = true;
            if (this._updater == null) {
                this._updater = new Thread(new Runnable(){

                    public void run() {
                        DataLinkPane.this.uiToolkit.setSBText("Loading data links...");
                        while (Info.this.needsUpdate()) {
                            Info.this.doUpdate();
                        }
                        DataLinkPane.this.uiToolkit.setSBText("");
                    }
                });
                this._updater.start();
            }
        }

        public void refreshFromModel(int n) throws Exception {
            DataLinkPane.this.trace("refreshFromModel");
            if (n == -1) {
                this.initUi();
            }
            this.refreshFromModel();
        }

        public void applyToModel() {
        }

        private sDataLinkAttrs toAttrs(DataLinkDataSource.Info info) {
            sDataLinkAttrs sDataLinkAttrs2 = new sDataLinkAttrs();
            sDataLinkAttrs2.type = info.getType();
            sDataLinkAttrs2.tIndex = info.getLocalPortId();
            sDataLinkAttrs2.te_link_id = info.getLocalTeLinkId();
            sDataLinkAttrs2.remote_id = info.getRemoteDataLinkId();
            return sDataLinkAttrs2;
        }

        private void createDataLink() {
            DataLinkCreationDialog dataLinkCreationDialog = DataLinkCreationDialog.getCreationDialog(DataLinkPane.this, this._ds);
            dataLinkCreationDialog.show();
            if (dataLinkCreationDialog.ok()) {
                try {
                    this._model.createDataLink(this.toAttrs(dataLinkCreationDialog.getValues()));
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    ErrorMsg.displayError((Component)((Object)DataLinkPane.this), (EID)EMC.EID_WRONG_INTERFACE_TYPE_PARAM_1, (Object)"LMP Create Data Link");
                }
                catch (NoSuchInterface noSuchInterface) {
                    ErrorMsg.displayError((Component)((Object)DataLinkPane.this), (EID)EMC.EID_NO_SUCH_INTERFACE_PARAM_1, (Object)this._ds.getColumn("Local Port Id").getColumnValue(dataLinkCreationDialog.getValues()));
                }
                catch (LmpException lmpException) {
                    ErrorMsg.displayError((Component)((Object)DataLinkPane.this), (EID)lmpException.getEid());
                }
            }
        }

        private void editDataLink() {
            DataLinkDataSource.Info[] infoArray = this.getSelectedRows();
            for (int i = 0; i < infoArray.length; ++i) {
                this.editDataLink(infoArray[i]);
            }
        }

        private void editDataLink(DataLinkDataSource.Info info) {
            DataLinkEditDialog dataLinkEditDialog = DataLinkEditDialog.getEditDialog(DataLinkPane.this, this._ds, info);
            dataLinkEditDialog.show();
            if (dataLinkEditDialog.ok()) {
                try {
                    info.getModel().set(this.toAttrs(dataLinkEditDialog.getValues()));
                }
                catch (LmpException lmpException) {
                    ErrorMsg.displayError((Component)((Object)DataLinkPane.this), (EID)lmpException.getEid());
                }
            }
        }

        private void deleteDataLink() {
            DataLinkDataSource.Info[] infoArray = DataLinkPane.this.dsc.getSelectedRows();
            DataLinkDeletionDialog dataLinkDeletionDialog = DataLinkDeletionDialog.getDeletionDialog(DataLinkPane.this, this._ds, infoArray);
            dataLinkDeletionDialog.show();
            if (dataLinkDeletionDialog.ok()) {
                for (int i = 0; i < infoArray.length; ++i) {
                    try {
                        this._model.deleteDataLink(infoArray[i].getLocalDataLinkId());
                        continue;
                    }
                    catch (LmpException lmpException) {
                        ErrorMsg.displayError((Component)((Object)DataLinkPane.this), (EID)lmpException.getEid());
                    }
                }
            }
        }

        public IObservableManager getObservableManager() {
            return this._om;
        }

        public void disposeDataSource() {
            DataLinkPane.this.trace("disposeDataSource");
            this._om.removeObservable((Observable)((Object)this._model));
            if (this._ds != null) {
                this._ds.dispose();
            }
        }

        int getSelectedRowCount() {
            return DataLinkPane.this.getTable().getSelectedRowCount();
        }

        DataLinkDataSource.Info[] getSelectedRows() {
            int[] nArray = DataLinkPane.this.getTable().getSelectedRows();
            Object[] objectArray = new DataLinkDataSource.Info[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[i] = (DataLinkDataSource.Info)this._tm.getValueAt(nArray[i], 0);
            }
            Arrays.sort(objectArray);
            return objectArray;
        }

        UScrollPane initTable() {
            this._ds = new DataLinkDataSource(this._model);
            this._tm = new SortableRowTableModel((RowDataSource)this._ds, this._ds.getRenderers(), this._ds.getRowObjectClass());
            DataLinkPane.this.setTable((JTable)new UTable((TableModel)((Object)this._tm)));
            this._tm.initTable(DataLinkPane.this.getTable());
            this._ds.setTableModel(this._tm);
            ListSelectionModel listSelectionModel = DataLinkPane.this.getTable().getSelectionModel();
            listSelectionModel.setSelectionMode(2);
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        DataLinkPane.this.manageButtons();
                    }
                }
            });
            this._om.addObservable((Observable)((Object)this._model));
            return new UScrollPane((Component)DataLinkPane.this.getTable());
        }

        void initUi() {
            DataLinkPane.this.trace("initUi");
            DataLinkPane.this.setLayout(new BorderLayout());
            DataLinkPane.this.buttonRow = AbstractPane.createHorizontalPanel(null);
            DataLinkPane.this.buttonRow.setLayout(new BorderLayout());
            DataLinkPane.this.scrollPane = this.initTable();
            DataLinkPane.this.createButton = new JButton(DataLinkPane.CREATE);
            DataLinkPane.this.createButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Info.this.createDataLink();
                }
            });
            DataLinkPane.this.editButton = new JButton(DataLinkPane.EDIT);
            DataLinkPane.this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Info.this.editDataLink();
                }
            });
            DataLinkPane.this.deleteButton = new JButton(DataLinkPane.DELETE);
            DataLinkPane.this.deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Info.this.deleteDataLink();
                }
            });
            DataLinkPane.this.manageButtons();
            JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
            JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
            jPanel.add(DataLinkPane.this.createButton);
            jPanel.add(DataLinkPane.this.editButton);
            jPanel.add(DataLinkPane.this.deleteButton);
            jPanel2.add(new CSHelpButton(CSHelpConst.LmpDataLinkPane));
            DataLinkPane.this.buttonRow.add((Component)jPanel, "Center");
            DataLinkPane.this.buttonRow.add((Component)jPanel2, "East");
            DataLinkPane.this.add((Component)DataLinkPane.this.scrollPane, "Center");
            DataLinkPane.this.add(DataLinkPane.this.buttonRow, "South");
        }
    }
}

