/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp;

import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Lmp.eProductConfigOperationalState;
import cerent.cms.idl.Lmp.eWdmRoleType;
import cerent.cms.idl.Lmp.sProductConfigAttrs;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.LmpException;
import cerent.cms.model.LmpModel;
import cerent.cms.ui.AbstractDataSourceControl;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ObserverProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.InetUtil;
import cerent.util.ObservableManager;
import cerent.util.gui.TextAreaDialog;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GeneralPane
extends ObserverProvPane
implements Observer {
    private JCheckBox _enabled;
    private JLabel _localNodeIdLabel;
    private JTextField _localNodeId;
    private JCheckBox _wdm;
    private JLabel _wdmRoleLabel;
    private JComboBox _wdmRole;
    private JPanel _operationalPanel;
    private JLabel _operationalStateLabel;
    private JLabel _operationalState;

    GeneralPane(String string, LmpModel lmpModel, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDataSourceControl(new Info(lmpModel));
    }

    public void update(Observable observable, Object object) {
        this.requestRefresh(observable, null);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.LmpGeneralPane;
    }

    private class Info
    extends AbstractDataSourceControl {
        private LmpModel _model;
        private ObservableManager _om;
        private Thread _updater;
        private boolean _needsUpdate;

        Info(LmpModel lmpModel) {
            this._model = lmpModel;
            this._om = new ObservableManager(GeneralPane.this, true);
            this._updater = null;
            this._needsUpdate = false;
        }

        private synchronized boolean needsUpdate() {
            if (this._needsUpdate) {
                this._needsUpdate = false;
                return true;
            }
            this._updater = null;
            return false;
        }

        private String asString(sIpAddr sIpAddr2) {
            return InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sIpAddr2));
        }

        private void doUpdate() {
            try {
                final boolean bl = this._model.isEnabled();
                final boolean bl2 = this._model.isWdm();
                final eWdmRoleType eWdmRoleType2 = this._model.getWdmRole();
                final sIpAddr sIpAddr2 = this._model.getLocalNodeId();
                final eProductConfigOperationalState eProductConfigOperationalState2 = this._model.getOperationalState();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        GeneralPane.this._enabled.setSelected(bl);
                        GeneralPane.this._localNodeId.setText(Info.this.asString(sIpAddr2));
                        GeneralPane.this._localNodeId.setEnabled(bl);
                        GeneralPane.this._wdm.setSelected(bl2);
                        GeneralPane.this._wdm.setEnabled(bl);
                        GeneralPane.this._wdmRoleLabel.setEnabled(bl2 && bl);
                        GeneralPane.this._wdmRole.setSelectedItem(Info.this.getWdmRoleChoice(eWdmRoleType2));
                        GeneralPane.this._wdmRole.setEnabled(bl2 && bl);
                        GeneralPane.this._operationalState.setText(Info.this.getOperationalStateChoice(eProductConfigOperationalState2).toString());
                        GeneralPane.this._operationalPanel.setVisible(bl);
                        GeneralPane.this.setDirty(false);
                    }
                });
            }
            catch (LmpException lmpException) {
                ErrorMsg.displayError((Component)((Object)GeneralPane.this), (EID)lmpException.getEid());
            }
        }

        public synchronized void refreshFromModel() throws Exception {
            this._needsUpdate = true;
            if (this._updater == null) {
                this._updater = new Thread(new Runnable(){

                    public void run() {
                        GeneralPane.this.uiToolkit.setSBText("Loading LMP configuration...");
                        while (Info.this.needsUpdate()) {
                            Info.this.doUpdate();
                        }
                        GeneralPane.this.uiToolkit.setSBText("");
                    }
                });
                this._updater.start();
            }
        }

        public void refreshFromModel(int n) throws Exception {
            if (n == -1) {
                this.initUi();
            }
            this.refreshFromModel();
        }

        private String toString(Exception exception) {
            int n;
            if (exception instanceof NumberFormatException) {
                return "invalid number format: " + exception.getMessage();
            }
            String string = exception.getMessage();
            if ((string == null || string.length() == 0) && (n = (string = exception.toString()).lastIndexOf(46)) >= 0) {
                string = string.substring(n + 1);
            }
            return string;
        }

        public void applyToModel() {
            try {
                this._model.set(new sProductConfigAttrs(GeneralPane.this._enabled.isSelected(), GeneralPane.this._wdm.isSelected(), this.getWdmRoleChoice((Attribute)GeneralPane.this._wdmRole.getSelectedItem()), IpAddrFactory.getIpAddr(InetUtil.makeIpAddr(GeneralPane.this._localNodeId.getText().trim()))));
            }
            catch (LmpException lmpException) {
                ErrorMsg.displayError((Component)((Object)GeneralPane.this), (EID)lmpException.getEid());
            }
            catch (Exception exception) {
                final String string = this.toString(exception);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        new TextAreaDialog(JOptionPane.getFrameForComponent((Component)((Object)GeneralPane.this)), "LMP General Validation Error", string, 650, 200);
                    }
                });
            }
        }

        public IObservableManager getObservableManager() {
            return this._om;
        }

        public void disposeDataSource() {
            this._om.removeObservable((Observable)((Object)this._model));
        }

        private void limitHeight(JPanel jPanel) {
            Dimension dimension = jPanel.getPreferredSize();
            dimension.width = Integer.MAX_VALUE;
            jPanel.setMaximumSize(dimension);
        }

        void initUi() {
            JPanel jPanel = new JPanel(new FlowLayout(0, 7, 7));
            jPanel.setBorder(BorderFactory.createTitledBorder("Status"));
            jPanel.add(GeneralPane.this._operationalStateLabel = new JLabel("Operational State:"));
            jPanel.add(GeneralPane.this._operationalState = new JLabel());
            jPanel.setAlignmentX(0.0f);
            this.limitHeight(jPanel);
            GeneralPane.this._operationalPanel = jPanel;
            JPanel jPanel2 = new JPanel(new FlowLayout(0, 7, 7));
            jPanel2.setBorder(BorderFactory.createTitledBorder("Configuration"));
            jPanel2.add(GeneralPane.this._enabled = new JCheckBox("Enable LMP"));
            jPanel2.add(GeneralPane.this._localNodeIdLabel = new JLabel("Local Node Id:"));
            jPanel2.add(GeneralPane.this._localNodeId = new JTextField(20));
            jPanel2.add(GeneralPane.this._wdm = new JCheckBox("LMP-WDM"));
            jPanel2.add(GeneralPane.this._wdmRoleLabel = new JLabel("Role:"));
            jPanel2.add(GeneralPane.this._wdmRole = new JComboBox<Attribute>(this.getWdmRoleChoices()));
            jPanel2.setAlignmentX(0.0f);
            this.limitHeight(jPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 1));
            jPanel3.add(jPanel);
            jPanel3.add(jPanel2);
            GeneralPane.this.add((Component)new UScrollPane((Component)jPanel3));
            GeneralPane.this._enabled.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = GeneralPane.this._enabled.isSelected();
                    boolean bl2 = GeneralPane.this._wdm.isSelected();
                    GeneralPane.this._localNodeId.setEnabled(bl);
                    GeneralPane.this._wdm.setEnabled(bl);
                    GeneralPane.this._wdmRoleLabel.setEnabled(bl && bl2);
                    GeneralPane.this._wdmRole.setEnabled(bl && bl2);
                    GeneralPane.this.setDirty(true);
                }
            });
            GeneralPane.this._localNodeId.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    GeneralPane.this.setDirty(true);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    GeneralPane.this.setDirty(true);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    GeneralPane.this.setDirty(true);
                }
            });
            GeneralPane.this._wdm.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = GeneralPane.this._enabled.isSelected();
                    boolean bl2 = GeneralPane.this._wdm.isSelected();
                    GeneralPane.this._localNodeId.setEnabled(bl);
                    GeneralPane.this._wdmRoleLabel.setEnabled(bl2 && bl);
                    GeneralPane.this._wdmRole.setEnabled(bl2 && bl);
                    GeneralPane.this.setDirty(true);
                }
            });
            GeneralPane.this._wdmRole.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    GeneralPane.this.setDirty(true);
                }
            });
            this._om.addObservable((Observable)((Object)this._model));
        }

        Attribute[] getWdmRoleChoices() {
            return ElementDefaults.getAttributeMap(this._model).getAttributeArray("LMP-WDM-Role");
        }

        Attribute getWdmRoleChoice(eWdmRoleType eWdmRoleType2) {
            Attribute[] attributeArray = this.getWdmRoleChoices();
            int n = eWdmRoleType2.value();
            for (int i = 0; i < attributeArray.length; ++i) {
                if (attributeArray[i].getIntValue() != n) continue;
                return attributeArray[i];
            }
            return null;
        }

        eWdmRoleType getWdmRoleChoice(Attribute attribute) {
            return eWdmRoleType.from_int(attribute.getIntValue());
        }

        Attribute[] getOperationalStateChoices() {
            return ElementDefaults.getAttributeMap(this._model).getAttributeArray("LMP-Product-Config-Operational-State");
        }

        Attribute getOperationalStateChoice(eProductConfigOperationalState eProductConfigOperationalState2) {
            Attribute[] attributeArray = this.getOperationalStateChoices();
            int n = eProductConfigOperationalState2.value();
            for (int i = 0; i < attributeArray.length; ++i) {
                if (attributeArray[i].getIntValue() != n) continue;
                return attributeArray[i];
            }
            return null;
        }

        eProductConfigOperationalState getOperationalStateChoice(Attribute attribute) {
            return eProductConfigOperationalState.from_int(attribute.getIntValue());
        }
    }
}

