/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp;

import cerent.cms.idl.Lmp.sTELinkAttrs;
import cerent.cms.model.LmpException;
import cerent.cms.model.LmpTeLinkModels;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractDataSourceControl;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.shelf.lmp.TeLinkCreationDialog;
import cerent.cms.ui.shelf.lmp.TeLinkDataSource;
import cerent.cms.ui.shelf.lmp.TeLinkDeletionDialog;
import cerent.cms.ui.shelf.lmp.TeLinkEditDialog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class TeLinkPane
extends ObserverPane
implements Observer {
    private static final String CREATE = "Create...";
    private static final String EDIT = "Edit...";
    private static final String DELETE = "Delete...";
    private JButton createButton;
    private JButton editButton;
    private JButton deleteButton;
    private JPanel buttonRow;
    private UScrollPane scrollPane;
    private NodeModelDelegate node;
    private Info dsc;

    public TeLinkPane(String string, LmpTeLinkModels lmpTeLinkModels, TabbedView tabbedView) {
        super(string, tabbedView);
        this.trace("<init>");
        this.node = (NodeModelDelegate)lmpTeLinkModels.getNodeModel();
        this.dsc = new Info(lmpTeLinkModels);
        this.setDataSourceControl(this.dsc);
    }

    public void destroy() {
        this.trace("destroy");
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.destroy();
    }

    public void enteringPage() throws Exception {
        this.trace("enteringPage");
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.getTable(), this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        this.trace("leavingPage");
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.leavingPage();
    }

    private void setTable(JTable jTable) {
        this.table = jTable;
    }

    public void update(Observable observable, Object object) {
        this.trace("update");
        this.requestRefresh(observable, null);
        this.manageButtons();
    }

    private void manageButtons() {
        boolean bl = this.isUserAuthorized();
        int n = this.dsc.getSelectedRowCount();
        this.createButton.setEnabled(bl);
        this.editButton.setEnabled(bl && n == 1);
        this.deleteButton.setEnabled(bl && n > 0);
    }

    private void trace(String string) {
        if (db.on()) {
            db.println("TeLinkPane." + string + "(" + this.node.getHostName() + ")");
        }
    }

    private class Info
    extends AbstractDataSourceControl {
        private LmpTeLinkModels _model;
        private ObservableManager _om;
        private TeLinkDataSource _ds;
        private SortableRowTableModel _tm;
        private Thread _updater;
        private boolean _needsUpdate;

        Info(LmpTeLinkModels lmpTeLinkModels) {
            this._model = lmpTeLinkModels;
            this._om = new ObservableManager(TeLinkPane.this, true);
            this._ds = null;
            this._tm = null;
            this._updater = null;
            this._needsUpdate = false;
        }

        private synchronized boolean needsUpdate() {
            if (this._needsUpdate) {
                this._needsUpdate = false;
                return true;
            }
            this._updater = null;
            return false;
        }

        private void doUpdate() {
            TeLinkPane.this.trace("doUpdate");
            try {
                this._ds.refreshFromModel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public synchronized void refreshFromModel() throws Exception {
            TeLinkPane.this.trace("refreshFromModel");
            this._needsUpdate = true;
            if (this._updater == null) {
                this._updater = new Thread(new Runnable(){

                    public void run() {
                        TeLinkPane.this.uiToolkit.setSBText("Loading TE links...");
                        while (Info.this.needsUpdate()) {
                            Info.this.doUpdate();
                        }
                        TeLinkPane.this.uiToolkit.setSBText("");
                    }
                });
                this._updater.start();
            }
        }

        public void refreshFromModel(int n) throws Exception {
            TeLinkPane.this.trace("refreshFromModel");
            if (n == -1) {
                this.initUi();
            }
            this.refreshFromModel();
        }

        public void applyToModel() {
        }

        private sTELinkAttrs toAttrs(TeLinkDataSource.Info info) {
            sTELinkAttrs sTELinkAttrs2 = new sTELinkAttrs();
            sTELinkAttrs2.admin_status = info.getAdminState();
            sTELinkAttrs2.remote_ne = info.getRemoteNodeId();
            sTELinkAttrs2.rem_un_id = info.getRemoteTeLinkId();
            sTELinkAttrs2.mux_cap = info.getMuxCap();
            return sTELinkAttrs2;
        }

        private void createTeLink() {
            TeLinkCreationDialog teLinkCreationDialog = TeLinkCreationDialog.getCreationDialog(TeLinkPane.this, this._ds);
            teLinkCreationDialog.show();
            if (teLinkCreationDialog.ok()) {
                try {
                    this._model.createTeLink(this.toAttrs(teLinkCreationDialog.getValues()));
                }
                catch (LmpException lmpException) {
                    ErrorMsg.displayError((Component)((Object)TeLinkPane.this), (EID)lmpException.getEid());
                }
            }
        }

        private void editTeLink() {
            TeLinkDataSource.Info[] infoArray = this.getSelectedRows();
            for (int i = 0; i < infoArray.length; ++i) {
                this.editTeLink(infoArray[i]);
            }
        }

        private void editTeLink(TeLinkDataSource.Info info) {
            TeLinkEditDialog teLinkEditDialog = TeLinkEditDialog.getEditDialog(TeLinkPane.this, this._ds, info);
            teLinkEditDialog.show();
            if (teLinkEditDialog.ok()) {
                try {
                    info.getModel().set(this.toAttrs(teLinkEditDialog.getValues()));
                }
                catch (LmpException lmpException) {
                    ErrorMsg.displayError((Component)((Object)TeLinkPane.this), (EID)lmpException.getEid());
                }
            }
        }

        private void deleteTeLink() {
            TeLinkDataSource.Info[] infoArray = TeLinkPane.this.dsc.getSelectedRows();
            TeLinkDeletionDialog teLinkDeletionDialog = TeLinkDeletionDialog.getDeletionDialog(TeLinkPane.this, this._ds, infoArray);
            teLinkDeletionDialog.show();
            if (teLinkDeletionDialog.ok()) {
                for (int i = 0; i < infoArray.length; ++i) {
                    try {
                        this._model.deleteTeLink(infoArray[i].getLocalTeLinkId());
                        continue;
                    }
                    catch (LmpException lmpException) {
                        ErrorMsg.displayError((Component)((Object)TeLinkPane.this), (EID)lmpException.getEid());
                    }
                }
            }
        }

        public IObservableManager getObservableManager() {
            return this._om;
        }

        public void disposeDataSource() {
            TeLinkPane.this.trace("disposeDataSource");
            this._om.removeObservable((Observable)((Object)this._model));
            if (this._ds != null) {
                this._ds.dispose();
            }
        }

        int getSelectedRowCount() {
            return TeLinkPane.this.getTable().getSelectedRowCount();
        }

        TeLinkDataSource.Info[] getSelectedRows() {
            int[] nArray = TeLinkPane.this.getTable().getSelectedRows();
            Object[] objectArray = new TeLinkDataSource.Info[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[i] = (TeLinkDataSource.Info)this._tm.getValueAt(nArray[i], 0);
            }
            Arrays.sort(objectArray);
            return objectArray;
        }

        UScrollPane initTable() {
            this._ds = new TeLinkDataSource(this._model);
            this._tm = new SortableRowTableModel((RowDataSource)this._ds, this._ds.getRenderers(), this._ds.getRowObjectClass());
            TeLinkPane.this.setTable((JTable)new UTable((TableModel)((Object)this._tm)));
            this._tm.initTable(TeLinkPane.this.getTable());
            this._ds.setTableModel(this._tm);
            ListSelectionModel listSelectionModel = TeLinkPane.this.getTable().getSelectionModel();
            listSelectionModel.setSelectionMode(2);
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        TeLinkPane.this.manageButtons();
                    }
                }
            });
            this._om.addObservable((Observable)((Object)this._model));
            return new UScrollPane((Component)TeLinkPane.this.getTable());
        }

        void initUi() {
            TeLinkPane.this.trace("initUi");
            TeLinkPane.this.setLayout(new BorderLayout());
            TeLinkPane.this.buttonRow = AbstractPane.createHorizontalPanel(null);
            TeLinkPane.this.buttonRow.setLayout(new BorderLayout());
            TeLinkPane.this.scrollPane = this.initTable();
            TeLinkPane.this.createButton = new JButton(TeLinkPane.CREATE);
            TeLinkPane.this.createButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Info.this.createTeLink();
                }
            });
            TeLinkPane.this.editButton = new JButton(TeLinkPane.EDIT);
            TeLinkPane.this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Info.this.editTeLink();
                }
            });
            TeLinkPane.this.deleteButton = new JButton(TeLinkPane.DELETE);
            TeLinkPane.this.deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Info.this.deleteTeLink();
                }
            });
            TeLinkPane.this.manageButtons();
            JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
            JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
            jPanel.add(TeLinkPane.this.createButton);
            jPanel.add(TeLinkPane.this.editButton);
            jPanel.add(TeLinkPane.this.deleteButton);
            jPanel2.add(new CSHelpButton(CSHelpConst.LmpTeLinkPane));
            TeLinkPane.this.buttonRow.add((Component)jPanel, "Center");
            TeLinkPane.this.buttonRow.add((Component)jPanel2, "East");
            TeLinkPane.this.add((Component)TeLinkPane.this.scrollPane, "Center");
            TeLinkPane.this.add(TeLinkPane.this.buttonRow, "South");
        }
    }
}

