/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.SonetMedia.sPathThresholds600;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.MuxIndex;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Frame;
import javax.swing.table.AbstractTableModel;

public class CxcHoPathPmThresholdsTableModel
extends AbstractTableModel {
    private Frame _frame;
    private TDMTerminology terms;
    protected TdmHoModel[] model = null;
    protected boolean[] rowDirty = null;
    protected sPathThresholds600[] statsVal;
    protected sInterface[] info = null;
    protected eIntervalType intervalType;
    protected int numLines;
    protected boolean nearEnd = false;
    protected EntityCellRenderer myPortRenderer;
    public static final int LINENUMBER_INDEX = 0;
    public static final int CV_INDEX = 1;
    public static final int ES_INDEX = 2;
    public static final int FC_INDEX = 3;
    public static final int SES_INDEX = 4;
    public static final int UAS_INDEX = 5;
    public static final int PJPIN_INDEX = 6;
    public static final int PJNIN_INDEX = 7;
    public static final int PJPOUT_INDEX = 8;
    public static final int PJNOUT_INDEX = 9;
    public static String[] columnNames = new String[]{"Port", "CV", "ES", "FC", "SES", "UAS", "PPJC-Pdet", "NPJC-Pdet", "PPJC-Pgen", "NPJC-Pgen"};
    private static final SDebug db = new SDebug("CxcHoPathPmThresholdsTableModel");

    public CxcHoPathPmThresholdsTableModel(INodeModel iNodeModel, TdmHoModel[] tdmHoModelArray, eIntervalType eIntervalType2, boolean bl) {
        this._frame = iNodeModel.getUiToolkit().getApplicationFrame();
        this.terms = iNodeModel.getTDMTerminology();
        this.model = tdmHoModelArray;
        this.nearEnd = bl;
        this.intervalType = eIntervalType2;
        if (this.model == null) {
            if (db.on()) {
                db.println("Model null");
            }
            this.numLines = 0;
            return;
        }
        this.numLines = this.model.length;
        this.init();
    }

    protected String getLineNumber(int n) throws NoSuchInterface, AbstractCmsNoSuchEntityException {
        StringBuffer stringBuffer = new StringBuffer();
        this.getInfo(n);
        if (this.info[n] != null) {
            MuxIndex muxIndex = new MuxIndex(this.model[n], this.info[n].muxIndex + 1);
            stringBuffer.append("Port ");
            if (this.info[n].portNumber == 0) {
                stringBuffer.append("all");
            } else {
                stringBuffer.append(this.getPortDescriptionFor(n));
            }
            stringBuffer.append(", " + this.terms.getGeneralTerms(0) + " ");
            stringBuffer.append(muxIndex);
        }
        return stringBuffer.toString();
    }

    protected sInterface getInfo(int n) throws NoSuchInterface {
        if (this.info[n] == null) {
            this.info[n] = this.model[n].getInfo();
        }
        return this.info[n];
    }

    private void init() {
        this.myPortRenderer = new EntityCellRenderer();
        this.rowDirty = new boolean[this.numLines];
        this.statsVal = new sPathThresholds600[this.numLines];
        this.info = new sInterface[this.numLines];
    }

    private void refreshPmStats(int n) {
        if (this.statsVal[n] == null) {
            try {
                this.statsVal[n] = new sPathThresholds600();
                this.model[n].getStsPathThresholds(this.nearEnd, this.intervalType, this.statsVal[n]);
                if (db.on()) {
                    db.println("Stats val got for line " + n);
                }
                this.printStats(this.statsVal[n]);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private Frame getFrame() {
        return this._frame;
    }

    public Class getColumnClass(int n) {
        if (n != 0) {
            return Integer.class;
        }
        return String.class;
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            if (db.on()) {
                db.println("Change in value " + n + " " + n2);
            }
            int n3 = -1;
            if (object instanceof Integer) {
                n3 = (Integer)object;
            } else if (object instanceof String) {
                n3 = Integer.parseInt((String)object);
            }
            if (n3 < 0) {
                throw new Exception();
            }
            switch (n2) {
                case 1: {
                    if (this.statsVal[n].cv == n3) break;
                    this.statsVal[n].cv = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 2: {
                    if (this.statsVal[n].es == n3) break;
                    this.statsVal[n].es = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 4: {
                    if (this.statsVal[n].ses == n3) break;
                    this.statsVal[n].ses = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 3: {
                    if (this.statsVal[n].fc == n3) break;
                    this.statsVal[n].fc = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 5: {
                    if (this.statsVal[n].uas == n3) break;
                    this.statsVal[n].uas = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 6: {
                    if (this.statsVal[n].pjpIn == n3) break;
                    this.statsVal[n].pjpIn = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 7: {
                    if (this.statsVal[n].pjnIn == n3) break;
                    this.statsVal[n].pjnIn = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 8: {
                    if (this.statsVal[n].pjpOut == n3) break;
                    this.statsVal[n].pjpOut = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 9: {
                    if (this.statsVal[n].pjnOut == n3) break;
                    this.statsVal[n].pjnOut = n3;
                    this.rowDirty[n] = true;
                    break;
                }
            }
            this.fireTableCellUpdated(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            if (db.on()) {
                db.println("NumberFormatException caught in CxcHoPathPmThresholdsTableModel::setValueAt(): " + numberFormatException);
                SDebug.printStackTrace((Throwable)numberFormatException);
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in setting value " + exception);
            }
            System.err.println("Error in setting value " + exception);
            exception.printStackTrace(System.err);
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        if (this.nearEnd) {
            return columnNames.length;
        }
        return 6;
    }

    public sPathThresholds600 getStatsVal(int n) {
        if (n >= this.numLines) {
            return null;
        }
        return this.statsVal[n];
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.model.length > 0) {
            try {
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.model[0].getModuleModel().isProtectModule()) {
                    return n2 > 0 && this.shouldLineBeEditable(n);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return false;
            }
        }
        return false;
    }

    private boolean shouldLineBeEditable(int n) {
        boolean bl = true;
        try {
            IPortModel iPortModel = null;
            if (this.model[n] instanceof TdmHoModel) {
                iPortModel = this.model[n].getPortModel();
                TdmLineModel tdmLineModel = (TdmLineModel)iPortModel.getInterfaceModel();
                bl = !tdmLineModel.isProtectLine();
            } else {
                if (CxcHoPathPmThresholdsTableModel.db.on) {
                    db.println("The line model was not a TdmHoModel - thresholds will be editable.");
                }
                bl = true;
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.println("AbstractCmsNoSuchEntityException caught: " + (Object)((Object)abstractCmsNoSuchEntityException));
            db.println("Thresholds will NOT be editable.");
            bl = false;
        }
        catch (Exception exception) {
            db.println("Unexpected Exception caught: " + exception);
            db.println("Thresholds will NOT be editable.");
            SDebug.printStackTrace((Throwable)exception);
            bl = false;
        }
        return bl;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getLineNumber(n);
                }
                case 1: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].cv);
                }
                case 2: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].es);
                }
                case 4: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].ses);
                }
                case 3: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].fc);
                }
                case 5: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].uas);
                }
                case 6: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].pjpIn);
                }
                case 8: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].pjpOut);
                }
                case 7: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].pjnIn);
                }
                case 9: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].pjnOut);
                }
            }
            return null;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in getValueAt " + exception);
            }
            System.err.println("Error in getValueAt " + exception);
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public void refreshLineFromModel(int n) {
        this.statsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStsModel(TdmHoModel[] tdmHoModelArray) {
        CxcHoPathPmThresholdsTableModel cxcHoPathPmThresholdsTableModel = this;
        synchronized (cxcHoPathPmThresholdsTableModel) {
            this.model = tdmHoModelArray;
            this.numLines = this.model.length;
            this.statsVal = new sPathThresholds600[this.numLines];
            this.rowDirty = new boolean[this.numLines];
            this.info = new sInterface[this.numLines];
            for (int i = 0; i < this.numLines; ++i) {
                this.statsVal[i] = null;
                this.rowDirty[i] = false;
            }
        }
        this.fireTableDataChanged();
    }

    public void refreshFromModel() {
        int n;
        if (db.on()) {
            db.println("refreshing in model");
        }
        for (n = 0; n < this.numLines; ++n) {
            this.statsVal[n] = null;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.rowDirty[n] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }

    private void printStats(sPathThresholds600 sPathThresholds6002) {
        if (db.on()) {
            db.println("Near End = " + this.nearEnd + " Interval Type = " + EnumStrings.getString((Object)this.intervalType, (int)this.intervalType.value()));
            db.println("===============================================");
            db.println("CV " + sPathThresholds6002.cv);
            db.println("ES " + sPathThresholds6002.es);
            db.println("FC " + sPathThresholds6002.fc);
            db.println("SES " + sPathThresholds6002.ses);
            db.println("UAS " + sPathThresholds6002.uas);
            db.println("PPJC-Pdet " + sPathThresholds6002.pjpIn);
            db.println("NPJC-Pdet " + sPathThresholds6002.pjnIn);
            db.println("PPJC-Pgen" + sPathThresholds6002.pjpOut);
            db.println("NPJC-Pgen" + sPathThresholds6002.pjnOut);
            db.println("===============================================");
        }
    }
}

