/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.SonetMedia.sPathThresholds;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.FramingType;
import cerent.cms.model.IFramingType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TdmModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.HoPathPmThresholdsTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class HoPathPmThresholdsPane
extends NodeProvPane
implements TableModelListener {
    protected HoPathPmThresholdsTableModel dataModel = null;
    protected TdmHoModel[] hoModels = null;
    protected InterfaceModel[] lineModels = null;
    protected BlsrModel[] blsrModels = null;
    protected int indexOfHo;
    protected TdmModuleModel eqpmtModel = null;
    protected eIntervalType intervalType = null;
    protected boolean nearEnd = false;
    protected Observer strucChangeObserver = null;
    protected Observer blsrChangeObserver = null;
    protected boolean isElectrical = false;
    protected static final SDebug db = new SDebug("HoPathPmThresholdsPane");

    public HoPathPmThresholdsPane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray, eIntervalType eIntervalType2, boolean bl, int n) {
        this(string, tabbedView, interfaceModelArray, eIntervalType2, bl, n, false);
    }

    public HoPathPmThresholdsPane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray, eIntervalType eIntervalType2, boolean bl, int n, boolean bl2) {
        super(string, tabbedView);
        if (db.on()) {
            db.println("<init>( " + string + ", " + tabbedView.getClass().getName() + ", " + "InterfaceModel[ " + interfaceModelArray.length + " ], " + eIntervalType2 + ", " + bl + ", " + n + " )");
        }
        TableColumn tableColumn = null;
        this.intervalType = eIntervalType2;
        this.nearEnd = bl;
        this.lineModels = interfaceModelArray;
        this.indexOfHo = n;
        this.hoModels = this.getHo(interfaceModelArray, n);
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.add((Component)uScrollPane);
        IFramingType iFramingType = FramingType.getFramingType((int)tabbedView.getUiModel().getNodeModel().getFramingType());
        if (iFramingType.isSdh()) {
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(4));
            this.table.removeColumn(tableColumn);
        } else {
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
            this.table.removeColumn(tableColumn);
        }
        if (bl2 || !bl) {
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(7));
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(8));
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(9));
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(10));
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(11));
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(12));
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(13));
            this.table.removeColumn(tableColumn);
        }
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        this.table.setAutoCreateColumnsFromModel(false);
        this.strucChangeObserver = new Observer(){

            public void update(Observable observable, Object object) {
                Integer n;
                if (db.on()) {
                    db.println("Got an update from linemodel");
                }
                if (object instanceof Integer && (n = (Integer)object).equals(ModelUpdateType.ADDED)) {
                    HoPathPmThresholdsPane.this.initializeLines();
                }
            }
        };
        this.blsrChangeObserver = new Observer(){

            public void update(Observable observable, Object object) {
                if (db.on()) {
                    db.println("Got an update from linemodel");
                }
                if (object instanceof Integer) {
                    Integer n = (Integer)object;
                    HoPathPmThresholdsPane.this.initializeLines();
                }
            }
        };
        this.registerWithModel();
    }

    protected TdmHoModel[] getHo(InterfaceModel[] interfaceModelArray, int n) {
        Collection collection;
        if (db.on()) {
            db.println("getHo( InterfaceModel[ " + interfaceModelArray.length + " ], " + n + " )");
        }
        if ((collection = InterfaceModel.getHigherLayerModels(interfaceModelArray, n)) == null) {
            if (db.on()) {
                db.println("Error in getting Ho lines");
            }
            return null;
        }
        if (db.on()) {
            db.println("Returning Hos " + collection.size());
        }
        return collection.toArray(new TdmHoModel[0]);
    }

    protected synchronized void initializeLines() {
        if (db.on()) {
            db.println("initializeLines");
        }
        this.hoModels = this.getHo(this.lineModels, this.indexOfHo);
        this.dataModel.setHoModel(this.hoModels);
        this.registerWithModel();
    }

    protected HoPathPmThresholdsTableModel getDataModel() {
        INodeModel iNodeModel = this.uiModel.getNodeModel();
        return new HoPathPmThresholdsTableModel(iNodeModel, this.lineModels, this.hoModels, this.intervalType, this.nearEnd);
    }

    protected void registerWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.hoModels.length; ++n) {
            this.hoModels[n].addObserver((Observer)((Object)this));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.lineModels[n].addObserver(this.strucChangeObserver);
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.uiModel.getNodeModel();
        ElementModelsDelegate elementModelsDelegate = nodeModelDelegate.getElementModelsDelegate();
        Set set = elementModelsDelegate.getBlsrElements();
        this.blsrModels = set.toArray(new BlsrModel[set.size()]);
        for (int i = 0; i < this.blsrModels.length; ++i) {
            this.blsrModels[i].addObserver(this.blsrChangeObserver);
            if (!db.on()) continue;
            db.println("observing with blsr #" + this.blsrModels[i]);
        }
    }

    protected void unregisterWithModel() {
        int n;
        for (n = 0; n < this.hoModels.length; ++n) {
            this.hoModels[n].deleteObserver((Observer)((Object)this));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.lineModels[n].deleteObserver(this.strucChangeObserver);
        }
        for (n = 0; n < this.blsrModels.length; ++n) {
            if (this.blsrModels[n] == null) continue;
            this.blsrModels[n].deleteObserver(this.blsrChangeObserver);
        }
    }

    public void dispose() {
        this.unregisterWithModel();
        super.dispose();
    }

    protected void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    protected void deleteMessage(Observable observable, Object object) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HoPathPmThresholdsPane.this.unregisterWithModel();
                HoPathPmThresholdsPane.this.initializeLines();
            }
        });
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                HoPathPmThresholdsPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof OcnLineUpdate) {
            this.unregisterWithModel();
            this.lineModels = (InterfaceModel[])((OcnLineUpdate)object).getModels();
            this.initializeLines();
        }
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.hoModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In HoPathPmThresholdsPane changeMessage cannot find Model " + observable);
        }
    }

    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            if (db.on()) {
                db.println("Applying changes");
            }
            for (n = 0; n < this.hoModels.length; ++n) {
                if (db.on()) {
                    db.println("setting at iteration " + n);
                }
                if (!this.dataModel.isRowDirty(n)) continue;
                this.printStats(this.dataModel.getThresholdsVal(n));
                this.hoModels[n].setPmThresholds(this.nearEnd, this.intervalType, this.dataModel.getThresholdsVal(n));
            }
            this.dataModel.resetDirtyBits();
        }
        catch (Exception exception) {
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        for (int i = 0; i < this.hoModels.length; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    protected void printStats(sPathThresholds sPathThresholds2) {
        if (db.on()) {
            db.println("===============================================");
        }
        if (db.on()) {
            db.println("CV " + sPathThresholds2.cv);
        }
        if (db.on()) {
            db.println("ES " + sPathThresholds2.es);
        }
        if (db.on()) {
            db.println("SES " + sPathThresholds2.ses);
        }
        if (db.on()) {
            db.println("FC " + sPathThresholds2.fc);
        }
        if (db.on()) {
            db.println("UAS " + sPathThresholds2.uas);
        }
        if (db.on()) {
            db.println("BBE " + sPathThresholds2.bbe);
        }
        if (db.on()) {
            db.println("===============================================");
        }
    }

    public CSHelpID getHelpID() {
        if (this.isElectrical) {
            return CSHelpConst.ElectPmThresholdsPane;
        }
        return CSHelpConst.HoPathPmThresholdsPane;
    }
}

