/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.sStsInfo;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.SonetMedia.sPathThresholds;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathInfo;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.LinePathHolder;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractValidatingTableModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.MuxIndex;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.Set;

public class HoPathPmThresholdsTableModel
extends AbstractValidatingTableModel {
    private int framingType;
    private TDMTerminology terms;
    private TdmHoModel[] model;
    private boolean[] rowDirty;
    private sPathThresholds[] thresholdsVal;
    private sInterface[] info;
    private eIntervalType intervalType;
    private int numLines;
    private boolean nearEnd;
    private EntityCellRenderer myPortRenderer;
    private InterfaceModel[] lineModels;
    private ArrayList switchedLinePathList;
    private Object[] combinedModels;
    public static final int LINENUMBER_INDEX = 0;
    public static final int CV_INDEX = 1;
    public static final int BBE_INDEX = 2;
    public static final int ES_INDEX = 3;
    public static final int FC_INDEX = 4;
    public static final int SES_INDEX = 5;
    public static final int UAS_INDEX = 6;
    public static final int PJPIN_INDEX = 7;
    public static final int PJNIN_INDEX = 8;
    public static final int PJPOUT_INDEX = 9;
    public static final int PJNOUT_INDEX = 10;
    public static final int PJDIFF_INDEX = 11;
    public static final int PJINSEC_INDEX = 12;
    public static final int PJOUTSEC_INDEX = 13;
    public static final int LAST_INDEX = 13;
    private static String[] columnNames;
    private static final SDebug db;

    public HoPathPmThresholdsTableModel(INodeModel iNodeModel, InterfaceModel[] interfaceModelArray, TdmHoModel[] tdmHoModelArray, eIntervalType eIntervalType2, boolean bl) {
        super((NodeModelDelegate)iNodeModel, db);
        int n;
        this.framingType = iNodeModel.getFramingType();
        this.terms = iNodeModel.getTDMTerminology();
        this.model = tdmHoModelArray;
        this.initColumnNames();
        this.nearEnd = bl;
        this.intervalType = eIntervalType2;
        this.lineModels = interfaceModelArray;
        this.getBlsrProtLinesList();
        if (this.model == null && this.switchedLinePathList.size() == 0) {
            if (db.on()) {
                db.println("Model null");
            }
            this.numLines = 0;
            return;
        }
        this.numLines = this.model.length + this.switchedLinePathList.size();
        this.combinedModels = new Object[this.numLines];
        for (n = 0; n < this.model.length; ++n) {
            this.combinedModels[n] = this.model[n];
        }
        n = 0;
        for (int i = this.model.length; i < this.numLines; ++i) {
            this.combinedModels[i] = this.switchedLinePathList.get(n++);
        }
        this.init();
    }

    protected void getBlsrProtLinesList() {
        this.switchedLinePathList = new ArrayList();
        ElementModelsDelegate elementModelsDelegate = this.node.getElementModelsDelegate();
        Set set = elementModelsDelegate.getBlsrElements();
        BlsrModel[] blsrModelArray = set.toArray(new BlsrModel[set.size()]);
        for (int i = 0; i < blsrModelArray.length; ++i) {
            LinePathHolder linePathHolder;
            int n;
            IPathInfo[] iPathInfoArray;
            int n2;
            TdmLineModel tdmLineModel;
            IEntityModel iEntityModel;
            try {
                iEntityModel = blsrModelArray[i].getEastProtectEntityModel();
                if (iEntityModel != null && iEntityModel instanceof TdmPortModel) {
                    tdmLineModel = ((TdmPortModel)iEntityModel).getTdmLineModel();
                    for (n2 = 0; n2 < this.lineModels.length; ++n2) {
                        if (tdmLineModel != this.lineModels[n2]) continue;
                        if (db.on()) {
                            db.println("This linemodel matches a BLSR's east protect: " + this.lineModels[n2]);
                        }
                        iPathInfoArray = blsrModelArray[i].getEastProtectHoPaths();
                        for (n = 0; n < iPathInfoArray.length; ++n) {
                            linePathHolder = new LinePathHolder(tdmLineModel, iPathInfoArray[n]);
                            this.switchedLinePathList.add(linePathHolder);
                        }
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
            try {
                iEntityModel = blsrModelArray[i].getWestProtectEntityModel();
                if (iEntityModel == null || !(iEntityModel instanceof TdmPortModel)) continue;
                tdmLineModel = ((TdmPortModel)iEntityModel).getTdmLineModel();
                for (n2 = 0; n2 < this.lineModels.length; ++n2) {
                    if (tdmLineModel != this.lineModels[n2]) continue;
                    if (db.on()) {
                        db.println("This linemodel matches a BLSR's west protect: " + this.lineModels[n2]);
                    }
                    iPathInfoArray = blsrModelArray[i].getWestProtectHoPaths();
                    for (n = 0; n < iPathInfoArray.length; ++n) {
                        linePathHolder = new LinePathHolder(tdmLineModel, iPathInfoArray[n]);
                        this.switchedLinePathList.add(linePathHolder);
                    }
                }
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
        }
    }

    protected String getLineNumber(int n) throws NoSuchInterface, AbstractCmsNoSuchEntityException {
        StringBuffer stringBuffer = new StringBuffer();
        this.getInfo(n);
        if (this.info[n] != null && this.combinedModels[n] instanceof TdmHoModel) {
            MuxIndex muxIndex = new MuxIndex((TdmHoModel)this.combinedModels[n], this.info[n].muxIndex + 1);
            stringBuffer.append("Port ");
            if (this.info[n].portNumber == 0) {
                stringBuffer.append("all");
            } else {
                stringBuffer.append(this.getPortDescriptionFor(n));
            }
            stringBuffer.append(", " + this.terms.getGeneralTerms(0) + " ");
            stringBuffer.append(muxIndex);
            try {
                stringBuffer.append(" (" + CircuitSize.width2sizeOfHoCircuit((int)((TdmHoModel)this.combinedModels[n]).getHoPathDefModel().getPathWidth(), (int)this.framingType).getCircuitSizeString() + ")");
            }
            catch (Exception exception) {
                db.info("Ignoring exception on path width adornment " + exception);
            }
        } else if (this.combinedModels[n] instanceof LinePathHolder) {
            LinePathHolder linePathHolder = (LinePathHolder)this.combinedModels[n];
            stringBuffer.append("Port ");
            stringBuffer.append(this.getPortDescriptionFor(n));
            stringBuffer.append(", " + this.terms.getGeneralTerms(0) + " ");
            stringBuffer.append(linePathHolder.getHoNum());
            stringBuffer.append(" (switched)");
        }
        return stringBuffer.toString();
    }

    protected sInterface getInfo(int n) throws NoSuchInterface {
        if (this.info[n] == null && this.combinedModels[n] instanceof TdmHoModel) {
            this.info[n] = ((TdmHoModel)this.combinedModels[n]).getInfo();
        }
        return this.info[n];
    }

    private void init() {
        this.myPortRenderer = new EntityCellRenderer();
        this.rowDirty = new boolean[this.numLines];
        this.thresholdsVal = new sPathThresholds[this.numLines];
        this.info = new sInterface[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
            this.thresholdsVal[i] = null;
        }
    }

    private void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.thresholdsVal[n] == null) {
            if (this.combinedModels[n] instanceof TdmHoModel) {
                this.thresholdsVal[n] = ((TdmHoModel)this.combinedModels[n]).getPmThresholds(this.nearEnd, this.intervalType);
            } else if (this.combinedModels[n] instanceof LinePathHolder) {
                LinePathHolder linePathHolder = (LinePathHolder)this.combinedModels[n];
                try {
                    TdmLineModel tdmLineModel = linePathHolder.getLineModel();
                    IPortModel iPortModel = tdmLineModel.getPortModel();
                    short s = (short)iPortModel.getIndex();
                    short s2 = linePathHolder.getHoNum();
                    sStsInfo sStsInfo2 = new sStsInfo();
                    sStsInfo2.index = s;
                    sStsInfo2.sts = s2;
                    this.thresholdsVal[n] = tdmLineModel.getBlsrProtectStsTermPmThresholds(sStsInfo2, this.nearEnd, this.intervalType);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            } else {
                db.println("refreshPmStats class error?, the combinedModel[] at " + n + " is " + this.combinedModels[n]);
            }
        }
    }

    private void initColumnNames() {
        columnNames = new String[14];
        try {
            HoPathPmThresholdsTableModel.columnNames[0] = "Port ";
            HoPathPmThresholdsTableModel.columnNames[3] = this.terms.getPmStat(2);
            HoPathPmThresholdsTableModel.columnNames[5] = this.terms.getPmStat(3);
            HoPathPmThresholdsTableModel.columnNames[1] = this.terms.getPmStat(1);
            HoPathPmThresholdsTableModel.columnNames[4] = this.terms.getPmStat(0);
            HoPathPmThresholdsTableModel.columnNames[6] = this.terms.getPmStat(9);
            HoPathPmThresholdsTableModel.columnNames[2] = this.terms.getPmStat(5);
            HoPathPmThresholdsTableModel.columnNames[7] = this.terms.getPmStat(10);
            HoPathPmThresholdsTableModel.columnNames[8] = this.terms.getPmStat(11);
            HoPathPmThresholdsTableModel.columnNames[9] = this.terms.getPmStat(12);
            HoPathPmThresholdsTableModel.columnNames[10] = this.terms.getPmStat(13);
            HoPathPmThresholdsTableModel.columnNames[11] = this.terms.getPmStat(28);
            HoPathPmThresholdsTableModel.columnNames[12] = this.terms.getPmStat(29);
            HoPathPmThresholdsTableModel.columnNames[13] = this.terms.getPmStat(30);
        }
        catch (Exception exception) {
            db.finer("Exception in initColumnNames() " + exception);
        }
    }

    private int getEs(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].es;
    }

    private int getCv(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].cv;
    }

    private int getSes(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].ses;
    }

    private int getFc(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].fc;
    }

    private int getUas(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].uas;
    }

    private int getBbe(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].bbe;
    }

    protected int getPjpIn(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].pjpIn;
    }

    protected int getPjnIn(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].pjnIn;
    }

    protected int getPjpOut(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].pjpOut;
    }

    protected int getPjnOut(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].pjnOut;
    }

    protected int getPjDiff(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].pjDiff;
    }

    protected int getPjInSec(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].pjInSec;
    }

    protected int getPjOutSec(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].pjOutSec;
    }

    public Class getColumnClass(int n) {
        if (n != 0) {
            return Integer.class;
        }
        return String.class;
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            if (db.on()) {
                db.println("Change in value " + n + " " + n2);
            }
            int n3 = -1;
            if (object instanceof Integer) {
                n3 = (Integer)object;
            } else if (object instanceof String) {
                n3 = Integer.parseInt((String)object);
            }
            if (n3 < 0) {
                Exception exception = new Exception();
                db.println("Caught exception in setValueAt");
                SDebug.printStackTrace((Throwable)exception);
                return;
            }
            switch (n2) {
                case 1: {
                    this.validatePmThresholds(3, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.terms.getPmStat(1), object.toString());
                    this.thresholdsVal[n].cv = n3;
                    break;
                }
                case 3: {
                    this.validatePmThresholds(3, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.terms.getPmStat(2), object.toString());
                    this.thresholdsVal[n].es = n3;
                    break;
                }
                case 5: {
                    this.validatePmThresholds(3, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.terms.getPmStat(3), object.toString());
                    this.thresholdsVal[n].ses = n3;
                    break;
                }
                case 4: {
                    this.validatePmThresholds(3, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.terms.getPmStat(0), object.toString());
                    this.thresholdsVal[n].fc = n3;
                    break;
                }
                case 6: {
                    this.validatePmThresholds(3, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.terms.getPmStat(9), object.toString());
                    this.thresholdsVal[n].uas = n3;
                    break;
                }
                case 2: {
                    this.validatePmThresholds(3, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.terms.getPmStat(5), object.toString());
                    this.thresholdsVal[n].bbe = n3;
                    break;
                }
                case 7: {
                    this.validatePmThresholds(3, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.terms.getPmStat(10), object.toString());
                    this.thresholdsVal[n].pjpIn = n3;
                    break;
                }
                case 8: {
                    this.validatePmThresholds(3, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.terms.getPmStat(11), object.toString());
                    this.thresholdsVal[n].pjnIn = n3;
                    break;
                }
                case 9: {
                    this.validatePmThresholds(3, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.terms.getPmStat(12), object.toString());
                    this.thresholdsVal[n].pjpOut = n3;
                    break;
                }
                case 10: {
                    this.validatePmThresholds(3, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.terms.getPmStat(13), object.toString());
                    this.thresholdsVal[n].pjnOut = n3;
                    break;
                }
                case 11: {
                    this.validatePmThresholds(3, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.terms.getPmStat(28), object.toString());
                    this.thresholdsVal[n].pjDiff = n3;
                    break;
                }
                case 12: {
                    this.validatePmThresholds(3, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.terms.getPmStat(29), object.toString());
                    this.thresholdsVal[n].pjInSec = n3;
                    break;
                }
                case 13: {
                    this.validatePmThresholds(3, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.terms.getPmStat(30), object.toString());
                    this.thresholdsVal[n].pjOutSec = n3;
                    break;
                }
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            db.println("NumberFormatException caught in setValueAt(): " + numberFormatException);
            SDebug.printStackTrace((Throwable)numberFormatException);
        }
        catch (ProvisionError provisionError) {
            this.presentProvisionError(this.getColumnName(n2), provisionError);
        }
        catch (Exception exception) {
            db.println("Unexpected Exception caught in HoPathPmThresholdsTableModel::setValueAt() " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public sPathThresholds getThresholdsVal(int n) {
        if (n >= this.numLines) {
            return null;
        }
        return this.thresholdsVal[n];
    }

    public boolean isCellEditable(int n, int n2) {
        block5: {
            if (this.combinedModels != null && this.combinedModels.length > 0) {
                try {
                    if (this.combinedModels[n] instanceof TdmHoModel) {
                        TdmHoModel tdmHoModel = (TdmHoModel)this.combinedModels[n];
                        if (AbstractPane.isUserAuthorized(tdmHoModel, SecurityLevel.PROVISIONING) && !tdmHoModel.getModuleModel().isProtectModule()) {
                            return n2 > 0 && this.shouldLineBeEditable(n);
                        }
                        break block5;
                    }
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean shouldLineBeEditable(int n) {
        boolean bl = true;
        try {
            Object object;
            IPortModel iPortModel = null;
            if (this.combinedModels[n] instanceof TdmHoModel) {
                iPortModel = ((TdmHoModel)this.combinedModels[n]).getPortModel();
            } else if (this.combinedModels[n] instanceof LinePathHolder) {
                object = (LinePathHolder)this.combinedModels[n];
                iPortModel = ((LinePathHolder)object).getLineModel().getPortModel();
            }
            object = (InterfaceModel)iPortModel.getInterfaceModel();
            bl = object instanceof TdmLineModel ? !((TdmLineModel)object).isProtectLine() : true;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.println("AbstractCmsNoSuchEntityException caught: " + (Object)((Object)abstractCmsNoSuchEntityException));
            bl = false;
        }
        catch (Exception exception) {
            db.println("Exception caught: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            bl = false;
        }
        return bl;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = null;
        if (this.combinedModels[n] instanceof TdmHoModel) {
            iPortModel = ((TdmHoModel)this.combinedModels[n]).getPortModel();
        } else if (this.combinedModels[n] instanceof LinePathHolder) {
            LinePathHolder linePathHolder = (LinePathHolder)this.combinedModels[n];
            iPortModel = linePathHolder.getLineModel().getPortModel();
        }
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getLineNumber(n);
                }
                case 1: {
                    return new Integer(this.getCv(n));
                }
                case 3: {
                    return new Integer(this.getEs(n));
                }
                case 5: {
                    return new Integer(this.getSes(n));
                }
                case 4: {
                    return new Integer(this.getFc(n));
                }
                case 6: {
                    return new Integer(this.getUas(n));
                }
                case 2: {
                    return new Integer(this.getBbe(n));
                }
                case 7: {
                    return new Integer(this.getPjpIn(n));
                }
                case 8: {
                    return new Integer(this.getPjnIn(n));
                }
                case 9: {
                    return new Integer(this.getPjpOut(n));
                }
                case 10: {
                    return new Integer(this.getPjnOut(n));
                }
                case 11: {
                    return new Integer(this.getPjDiff(n));
                }
                case 12: {
                    return new Integer(this.getPjInSec(n));
                }
                case 13: {
                    return new Integer(this.getPjOutSec(n));
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Error in getValueAt " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void refreshLineFromModel(int n) {
        this.thresholdsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHoModel(TdmHoModel[] tdmHoModelArray) {
        HoPathPmThresholdsTableModel hoPathPmThresholdsTableModel = this;
        synchronized (hoPathPmThresholdsTableModel) {
            int n;
            int n2;
            this.model = tdmHoModelArray;
            this.getBlsrProtLinesList();
            this.numLines = this.model.length + this.switchedLinePathList.size();
            this.combinedModels = new Object[this.numLines];
            for (n2 = 0; n2 < this.model.length; ++n2) {
                this.combinedModels[n2] = this.model[n2];
            }
            n2 = 0;
            for (n = this.model.length; n < this.numLines; ++n) {
                this.combinedModels[n] = this.switchedLinePathList.get(n2++);
            }
            this.thresholdsVal = new sPathThresholds[this.numLines];
            this.rowDirty = new boolean[this.numLines];
            this.info = new sInterface[this.numLines];
            for (n = 0; n < this.numLines; ++n) {
                this.thresholdsVal[n] = null;
                this.rowDirty[n] = false;
            }
        }
        this.fireTableDataChanged();
    }

    public void refreshFromModel() {
        int n;
        if (db.on()) {
            db.println("refreshing in model");
        }
        for (n = 0; n < this.numLines; ++n) {
            this.thresholdsVal[n] = null;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.rowDirty[n] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }

    static {
        db = new SDebug("HoPathPmThresholdsTableModel");
    }
}

