/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.sonet.TdmLinePmThresholdsTableModel;
import cerent.util.SDebug;

public class SdhLinePmThresholdsTableModel
extends TdmLinePmThresholdsTableModel {
    private static final SDebug db = new SDebug("SdhLinePmThresholdsTableModel");
    public static final int LINENUMBER_INDEX = 0;
    public static final int CV_INDEX = 1;
    public static final int BBE_INDEX = 2;
    public static final int ES_INDEX = 3;
    public static final int SES_INDEX = 4;
    public static final int UAS_INDEX = 5;
    public static final int PSC_INDEX = 6;
    public static final int PSD_INDEX = 7;
    public static final int PSCW_INDEX = 8;
    public static final int PSDW_INDEX = 9;
    public static final int PSCS_INDEX = 10;
    public static final int PSDS_INDEX = 11;
    public static final int PSCR_INDEX = 12;
    public static final int PSDR_INDEX = 13;
    public static final int LAST_INDEX = 13;

    public SdhLinePmThresholdsTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl, ModuleModel moduleModel) {
        super(iNodeModel, tdmLineModelArray, eIntervalType2, bl, moduleModel);
    }

    protected void initColumnNames() {
        this.columnNames = ElementDefaults.getPmColumnNames(this.moduleModel.getEqType(), this.getTerms(), this.nearEnd);
    }

    private int getBbe(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].bbe;
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            if (db.on()) {
                db.println("Change in value " + n + " " + n2);
            }
            int n3 = -1;
            if (object instanceof Integer) {
                n3 = (Integer)object;
            } else if (object instanceof String) {
                n3 = Integer.parseInt((String)object);
            }
            if (n3 < 0) {
                throw new Exception("Thresholds are positive");
            }
            switch (n2) {
                case 1: {
                    if (this.thresholdsVal[n].cv == n3) {
                        return;
                    }
                    this.getTerms();
                    this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, "EB", object.toString());
                    this.thresholdsVal[n].cv = n3;
                    break;
                }
                case 4: {
                    if (this.thresholdsVal[n].bbe == n3) {
                        return;
                    }
                    this.getTerms();
                    this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, "BBE", object.toString());
                    this.thresholdsVal[n].bbe = n3;
                    break;
                }
                case 2: {
                    if (this.thresholdsVal[n].es == n3) {
                        return;
                    }
                    this.getTerms();
                    this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, "ES", object.toString());
                    this.thresholdsVal[n].es = n3;
                    break;
                }
                case 3: {
                    if (this.thresholdsVal[n].ses == n3) {
                        return;
                    }
                    this.getTerms();
                    this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, "SES", object.toString());
                    this.thresholdsVal[n].ses = n3;
                    break;
                }
                case 5: {
                    if (this.thresholdsVal[n].uas == n3) {
                        return;
                    }
                    this.getTerms();
                    this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, "UAS", object.toString());
                    this.thresholdsVal[n].uas = n3;
                    break;
                }
                case 7: {
                    if (this.thresholdsVal[n].psd == n3) {
                        return;
                    }
                    this.getTerms();
                    this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, "PSD", object.toString());
                    this.thresholdsVal[n].psd = n3;
                    break;
                }
                case 6: {
                    if (this.thresholdsVal[n].psc == n3) {
                        return;
                    }
                    this.getTerms();
                    this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, "PSC", object.toString());
                    this.thresholdsVal[n].psc = n3;
                    break;
                }
                case 8: {
                    if (this.thresholdsVal[n].pscw == n3) {
                        return;
                    }
                    this.getTerms();
                    this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, "PSC-W", object.toString());
                    this.thresholdsVal[n].pscw = n3;
                    break;
                }
                case 9: {
                    if (this.thresholdsVal[n].psdw == n3) {
                        return;
                    }
                    this.getTerms();
                    this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, "PSD-W", object.toString());
                    this.thresholdsVal[n].psdw = n3;
                    break;
                }
                case 10: {
                    if (this.thresholdsVal[n].pscs == n3) {
                        return;
                    }
                    this.getTerms();
                    this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, "PSC-S", object.toString());
                    this.thresholdsVal[n].pscs = n3;
                    break;
                }
                case 11: {
                    if (this.thresholdsVal[n].psds == n3) {
                        return;
                    }
                    this.getTerms();
                    this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, "PSD-S", object.toString());
                    this.thresholdsVal[n].psds = n3;
                    break;
                }
                case 12: {
                    if (this.thresholdsVal[n].pscr == n3) {
                        return;
                    }
                    this.getTerms();
                    this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, "PSC-R", object.toString());
                    this.thresholdsVal[n].pscr = n3;
                    break;
                }
                case 13: {
                    if (this.thresholdsVal[n].psdr == n3) {
                        return;
                    }
                    this.getTerms();
                    this.validatePmThresholds(1, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, "PSD-R", object.toString());
                    this.thresholdsVal[n].psdr = n3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid column #" + n2);
                }
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            if (db.on()) {
                db.println("NumberFormatException caught in SdhLinePmThresholdsTableModel::setValueAt(): " + numberFormatException);
                SDebug.printStackTrace((Throwable)numberFormatException);
            }
        }
        catch (ProvisionError provisionError) {
            this.presentProvisionError(this.getColumnName(n2), provisionError);
        }
        catch (Exception exception) {
            db.println("Error in setValueAt " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public Object getValueAt(int n, int n2) {
        try {
            int n3 = this.model[n].getPortModel().getEqType();
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return new Integer(this.getCv(n));
                }
                case 4: {
                    return new Integer(this.getBbe(n));
                }
                case 2: {
                    return new Integer(this.getEs(n));
                }
                case 3: {
                    return new Integer(this.getSes(n));
                }
                case 5: {
                    return new Integer(this.getUas(n));
                }
                case 7: {
                    return new Integer(this.getPsd(n));
                }
                case 6: {
                    return new Integer(this.getPsc(n));
                }
                case 8: {
                    if (n3 == 28) {
                        return "N/A";
                    }
                    return new Integer(this.getPscW(n));
                }
                case 9: {
                    if (n3 == 28) {
                        return "N/A";
                    }
                    return new Integer(this.getPsdW(n));
                }
                case 10: {
                    if (n3 == 28 || n3 == 29) {
                        return "N/A";
                    }
                    return new Integer(this.getPscS(n));
                }
                case 11: {
                    if (n3 == 28 || n3 == 29) {
                        return "N/A";
                    }
                    return new Integer(this.getPsdS(n));
                }
                case 12: {
                    if (n3 == 28 || n3 == 29) {
                        return "N/A";
                    }
                    return new Integer(this.getPscR(n));
                }
                case 13: {
                    if (n3 == 28 || n3 == 29) {
                        return "N/A";
                    }
                    return new Integer(this.getPsdR(n));
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Error in getValueAt " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public boolean isCellEditable(int n, int n2) {
        try {
            int n3 = this.model[n].getPortModel().getEqType();
            switch (n2) {
                case 8: 
                case 9: {
                    return n3 != 28;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    return n3 != 28 && n3 != 29;
                }
            }
            return super.isCellEditable(n, n2);
        }
        catch (Exception exception) {
            return super.isCellEditable(n, n2);
        }
    }
}

