/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.IPlatform;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmModuleModel;
import cerent.cms.ui.AlsPane;
import cerent.cms.ui.CardMaintenancePane;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ILineModelUpdater;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.sonet.TdmInfoMaintenancePane;
import cerent.cms.ui.sonet.TdmLoopbackPane;
import cerent.cms.ui.sonet.TdmPmPane;
import cerent.cms.ui.sonet.TdmProvPane;
import cerent.cms.ui.sonet.TdmTransceiverPane;

public class TdmCardTabbedView
extends CardTabbedView {
    protected TdmLineModel[] lineModels = ((TdmModuleModel)this.getUiModel()).getTdmLineModels();
    private final String speedLabel_;

    public TdmCardTabbedView(TdmModuleModel tdmModuleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit, String string) {
        super(tdmModuleModel, iEventPanelController, iUiToolkit);
        this.speedLabel_ = string;
        this.lineModels = (TdmLineModel[])tdmModuleModel.getLineModels();
        this.showTabs();
    }

    public Pane getMaintenanceTab() {
        return TdmCardTabbedView.getTdmMaintPane("Maintenance", this, this.lineModels);
    }

    public static Pane getTdmMaintPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray) {
        int n;
        CardMaintenancePane cardMaintenancePane = new CardMaintenancePane(string, tabbedView, tdmLineModelArray, new ILineModelUpdater(){

            public boolean updateIsForMe(ModuleModelUpdate moduleModelUpdate) {
                return moduleModelUpdate instanceof OcnLineUpdate;
            }
        });
        ModuleModel moduleModel = (ModuleModel)tabbedView.getUiModel();
        IPlatform iPlatform = ((NodeModelDelegate)moduleModel.getNodeModel()).getPlatform();
        if (iPlatform.supportsTdmInfo()) {
            cardMaintenancePane.addSubTab("Info", new TdmInfoMaintenancePane("Info", tabbedView));
        }
        if (moduleModel.supportsAls()) {
            cardMaintenancePane.addSubTab("ALS", new AlsPane("ALS", tabbedView, tdmLineModelArray));
        }
        if (iPlatform.supportsTdmTransceiver(n = ((EntityModel)tabbedView.getUiModel()).getEqType()) && !TdmCardTabbedView.isOldOC192LR(moduleModel)) {
            cardMaintenancePane.addSubTab("Transceiver", new TdmTransceiverPane("Transceiver", tabbedView, tdmLineModelArray));
        }
        cardMaintenancePane.addSubTab("Loopback", new TdmLoopbackPane("Loopback", tabbedView, tdmLineModelArray));
        return cardMaintenancePane;
    }

    private static boolean isOldOC192LR(ModuleModel moduleModel) {
        boolean bl = false;
        switch (moduleModel.getEqType()) {
            case 60: {
                String string;
                String string2 = moduleModel.getMfgData().name;
                if (string2 == null || string2.indexOf("OC192") == -1 || string2.indexOf("LR") == -1 || (string = moduleModel.getMfgData().firmwareVersion) == null || string.indexOf("57-4363-") == -1) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public Pane getPerformanceTab() {
        return new TdmPmPane("Performance", this, this.lineModels);
    }

    public Pane getProvTab() {
        return new TdmProvPane("Provisioning", this, this.lineModels);
    }
}

