/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.FramingType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsProvExtModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.OpticsProvExtModel;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.OpticsProvExtHelper;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.VariComboBoxCellEditor;
import cerent.cms.ui.sonet.SyncStatusMsgDialog;
import cerent.cms.ui.sonet.TdmLineTableModel;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.AbstractCellEditor;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.SoakTimeCellEditor;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TdmLineProvPane
extends NodeProvPane
implements TableModelListener,
PropertyChangeListener,
ActionListener {
    private ObservableManager _obsMgr;
    protected TdmLineTableModel dataModel;
    protected TdmLineModel[] lineModels;
    protected IOpticsProvExtModel[] opticModels;
    static final SDebug db = new SDebug("TdmLineProvPane");

    public TdmLineProvPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray, TdmLineTableModel tdmLineTableModel) {
        super(string, tabbedView);
        this.lineModels = tdmLineModelArray;
        this.dataModel = tdmLineTableModel;
        this.opticModels = OpticsProvExtModel.getModels(tdmLineModelArray);
        this.getObsMgr().setObservable((Observable[])tdmLineModelArray);
        this.initProvPane();
    }

    protected ModuleModel getEqpmtModel() {
        return (ModuleModel)this.getUiModel();
    }

    private void initProvPane() {
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.add((Component)uScrollPane, "Center");
        this.customizeProvPane();
        this.registerWithModel();
    }

    private void customizeProvPane() {
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[0]);
        tableColumn.setMinWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[3]);
        tableColumn.setMinWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[4]);
        tableColumn.setMinWidth(130);
        this.removeColumn(8);
        if (this.pci.showPjMon()) {
            tableColumn = this.table.getColumn(this.dataModel.columnNames[14]);
            tableColumn.setCellEditor(new PJMonitorCellEditor());
            tableColumn.setCellRenderer(new SonetMonitorCellRenderer());
        } else {
            this.removeColumn(14);
        }
        this.setCellEditorAdminState();
        SoakTimeCellEditor soakTimeCellEditor = new SoakTimeCellEditor(this);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[17]);
        tableColumn.setCellEditor(soakTimeCellEditor);
        tableColumn.setMinWidth(soakTimeCellEditor.getPreferredWidth() + 10);
        if (this.pci.showSSM()) {
            tableColumn = this.table.getColumn(this.dataModel.columnNames[19]);
            tableColumn.setCellRenderer(new ShowButtonCellRenderer("Show"));
            tableColumn.setCellEditor(new ShowButtonCellEditor(this.getButtonForSyncMsg()));
        } else {
            this.removeColumn(19);
        }
        if (!this.pci.showType()) {
            this.removeColumn(18);
        }
        if (this.isReachAndWave()) {
            this.setOpticsExtCellEditor(21, this.getEqpmtModel(), this.opticModels, db);
            this.setOpticsExtCellEditor(22, this.getEqpmtModel(), this.opticModels, db);
        } else {
            this.removeColumn(21);
            this.removeColumn(22);
        }
        this.prepareColumns();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    private FramingType getFramingType(INodeModel iNodeModel) {
        try {
            return (FramingType)Model.getFramingType(iNodeModel);
        }
        catch (AnnotatedException annotatedException) {
            db.println("Could not get framing type. Assuming SONET");
            return FramingType.SONET;
        }
    }

    protected void prepareColumns() {
        this.removeColumn(15);
        this.removeColumn(16);
        if (!(this.getUiModel() instanceof PluggableCarrierModel)) {
            this.removeColumn(2);
        }
        boolean bl = this.pci.is600();
        boolean bl2 = false;
        ModuleModel moduleModel = this.getEqpmtModel();
        if (bl || moduleModel.getEqType() == 219 || moduleModel.getEqType() == 60 || moduleModel.getEqType() == 220) {
            bl2 = true;
        } else if (moduleModel.getEqType() == 11) {
            String string;
            int n = moduleModel.getSlot();
            ArrayList arrayList = moduleModel.getNodeModel().getMfgData(moduleModel.getShelfId());
            if (n > 0 && (string = (String)arrayList.get(n - 1)) != null && string.indexOf("AS") != -1) {
                bl2 = true;
            }
        }
        if (moduleModel.getEqType() == 182) {
            this.removeColumn(13);
        }
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(7));
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(TdmLineTableModel.blsrAttrs)));
        tableColumn.sizeWidthToFit();
        if (!bl2) {
            this.removeColumn(7);
        }
        this.setAttrCellEditor(20, "AlsMode");
        if (!moduleModel.supportsAls()) {
            this.removeColumn(20);
        }
        this.setAttrCellEditor(5, "declareSfBerLevel");
        this.setAttrCellEditor(6, "declareSdBerLevel");
        if (this.pci.showType()) {
            tableColumn = this.table.getColumn(this.dataModel.columnNames[18]);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(TdmLineTableModel.sdhSonetAttrs)));
            if (this.getFramingType(moduleModel.getNodeModel()).isSdh()) {
                tableColumn.setCellEditor(null);
            }
            tableColumn.sizeWidthToFit();
        }
        if (this.pci.showAdminSSM()) {
            tableColumn = this.table.getColumn(this.dataModel.columnNames[11]);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getQualityAttributes())));
        } else {
            this.removeColumn(11);
            this.removeColumn(12);
        }
    }

    protected void setAttrCellEditor(int n, String string) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[n]);
        try {
            Attribute[] attributeArray = this.getAttributeArray(string);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
            tableColumn.setPreferredWidth(tableColumn.getWidth());
        }
        catch (NoSuchElementException noSuchElementException) {
            if (db.on()) {
                db.println("Warning: cannot find attributes for " + string);
            }
            this.table.removeColumn(tableColumn);
        }
    }

    protected void setOpticsExtCellEditor(int n, ModuleModel moduleModel, IOpticsProvExtModel[] iOpticsProvExtModelArray, SDebug sDebug) {
        if (this.isReachAndWave()) {
            int n2 = 90;
            TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[n]);
            Attribute[][] attributeArray = null;
            switch (n) {
                case 21: {
                    attributeArray = OpticsProvExtHelper.getCombinedReaches(moduleModel, iOpticsProvExtModelArray, sDebug);
                    break;
                }
                case 22: {
                    n2 = 100;
                    attributeArray = OpticsProvExtHelper.getCombinedWavelengths(moduleModel, iOpticsProvExtModelArray, sDebug);
                }
            }
            tableColumn.setCellEditor(new VariComboBoxCellEditor(attributeArray));
            tableColumn.sizeWidthToFit();
            tableColumn.setMinWidth(n2);
        }
    }

    protected void setCellEditorAdminState() {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[3]);
        boolean bl = AdminState.isANSI(this.getUiModel().getNodeModel().getFramingType());
        AdminState[] adminStateArray = AdminState.getDefaultAdminStates(bl);
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(adminStateArray)));
        tableColumn.sizeWidthToFit();
        tableColumn.setPreferredWidth(tableColumn.getWidth());
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        this.table.removeColumn(tableColumn);
    }

    private JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    private JComboBox getComboBoxFor(AdminState[] adminStateArray) {
        JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap(this.getEqpmtModel());
    }

    public Attribute[] getAttributeArray(String string) throws NoSuchElementException {
        Attribute[] attributeArray = this.getAttributeMap().getAttributeArray(string);
        if (attributeArray == null) {
            throw new NoSuchElementException();
        }
        return attributeArray;
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.lineModels)) {
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            bl2 = true;
        }
        if (this.dataModel.mediaChanged()) {
            stringBuffer.append("Some lines have their media changed.").append('\n');
            bl = true;
        }
        if (AdminState.needRemoveLoopback(this.dataModel, this.lineModels)) {
            stringBuffer.append("Some lines will be removed from loopback since their new state does not allow loopback.").append('\n');
            bl = true;
        }
        if (bl || bl2) {
            boolean bl3 = true;
            if (bl2) {
                String string = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, bl);
                bl3 = false;
                stringBuffer.append(string).append("\n");
            }
            if (AdminState.adminStateChangedToFormOfOOSWhilePeerIsIS(this.dataModel, this.lineModels)) {
                stringBuffer.append(this.getSplitterString());
            }
            stringBuffer.append("\n");
            if (!bl3) {
                stringBuffer.append(this.getApplyString(bl3));
            } else {
                stringBuffer.append(this.getApplyString());
            }
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                return;
            }
        }
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                TdmLineProvPane.this.refreshLine(observable);
            }
        };
    }

    public void refreshFromModel() {
        this.dataModel.refreshFromModel();
        if (this.isReachAndWave()) {
            this.setOpticsExtCellEditor(21, this.getEqpmtModel(), this.opticModels, db);
            this.setOpticsExtCellEditor(22, this.getEqpmtModel(), this.opticModels, db);
        }
        this.resetDirty();
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
            this.setOpticsExtCellEditor(21, this.getEqpmtModel(), this.opticModels, db);
            this.setOpticsExtCellEditor(22, this.getEqpmtModel(), this.opticModels, db);
        } else if (db.on()) {
            db.println("In TdmLineProvPane changeMessage cannot find Model " + observable);
        }
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof OcnLineUpdate) {
            this.setLineModels((TdmLineModel[])((OcnLineUpdate)object).getModels());
        }
    }

    protected void setLineModels(TdmLineModel[] tdmLineModelArray) {
        this.getObsMgr().removeObservable((Observable[])this.lineModels);
        this.lineModels = tdmLineModelArray;
        this.opticModels = OpticsProvExtModel.getModels(this.lineModels);
        this.getObsMgr().addObservable((Observable[])this.lineModels);
        this.dataModel.refreshMyLines(this.lineModels);
        this.setOpticsExtCellEditor(21, this.getEqpmtModel(), this.opticModels, db);
        this.setOpticsExtCellEditor(22, this.getEqpmtModel(), this.opticModels, db);
    }

    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.dispose();
    }

    public void enteringPage() throws Exception {
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        super.enteringPage();
        this.getObsMgr().setPassing(true);
    }

    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    private int getNumHo(int n) {
        int n2 = 0;
        try {
            n2 = this.lineModels[n].numHo();
        }
        catch (Exception exception) {
            db.println("Caught exception in getPJMonitorCombo");
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_NBR_HOS_FOR_LINE);
        }
        if (db.on()) {
            db.println("Num Ho = " + n2);
        }
        return n2;
    }

    private JButton getButtonForSyncMsg() {
        JButton jButton = new JButton("Show");
        jButton.addActionListener(this);
        return jButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setCursor(3);
        SyncStatusMsgDialog syncStatusMsgDialog = SyncStatusMsgDialog.instance(JOptionPane.getFrameForComponent((Component)((Object)this)), "Synchronization Status Message");
        syncStatusMsgDialog.setTdmLineModel(this.lineModels[this.getTable().getEditingRow()]);
        syncStatusMsgDialog.show();
        this.setCursor(0);
    }

    protected String getSplitterString() {
        return "";
    }

    protected boolean isReachAndWave() {
        return this.getEqpmtModel() instanceof PluggableCarrierModel;
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.TdmLineProvPane;
    }

    protected ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    class ShowButtonCellEditor
    extends AbstractCellEditor {
        private JButton editor;

        public ShowButtonCellEditor(JButton jButton) {
            this.editor = jButton;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return this.editor;
        }
    }

    class ShowButtonCellRenderer
    extends JButton
    implements TableCellRenderer {
        public ShowButtonCellRenderer(String string) {
            super(string);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this;
        }
    }

    class PJMonitorListCellRenderer
    extends DefaultListCellRenderer {
        PJMonitorListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2 = object;
            if (object instanceof Integer && (Integer)object == 0) {
                object2 = "Off";
            }
            return super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
        }
    }

    class PJMonitorCellEditor
    extends DefaultCellEditor {
        public PJMonitorCellEditor() {
            super(new JComboBox());
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                public void setValue(Object object) {
                    ((JComboBox)PJMonitorCellEditor.this.editorComponent).setSelectedItem(object);
                }

                public Object getCellEditorValue() {
                    return ((JComboBox)PJMonitorCellEditor.this.editorComponent).getSelectedItem();
                }

                public boolean shouldSelectCell(EventObject eventObject) {
                    if (eventObject instanceof MouseEvent) {
                        MouseEvent mouseEvent = (MouseEvent)eventObject;
                        return mouseEvent.getID() != 506;
                    }
                    return true;
                }

                public boolean stopCellEditing() {
                    if (((JComboBox)PJMonitorCellEditor.this.editorComponent).isEditable()) {
                        ((JComboBox)PJMonitorCellEditor.this.editorComponent).actionPerformed(new ActionEvent(PJMonitorCellEditor.this, 0, ""));
                    }
                    return super.stopCellEditing();
                }
            };
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.editorComponent = this.getEditorComponent(n);
            this.delegate.setValue(object);
            return this.editorComponent;
        }

        public JComboBox getEditorComponent(int n) {
            JComboBox<Object> jComboBox = new JComboBox<Object>();
            int n2 = TdmLineProvPane.this.getNumHo(n);
            for (int i = 0; i <= n2; ++i) {
                jComboBox.addItem(new Integer(i));
            }
            jComboBox.setRenderer(new PJMonitorListCellRenderer());
            jComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            jComboBox.addActionListener(this.delegate);
            return jComboBox;
        }
    }

    class SonetMonitorCellRenderer
    extends DefaultTableCellRenderer {
        SonetMonitorCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = object;
            if (object instanceof Integer && (Integer)object == 0) {
                object2 = "Off";
            }
            return super.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
        }
    }
}

