/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.If.sInterface;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLoModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import javax.swing.table.AbstractTableModel;

public class TdmLoProvTableModel
extends AbstractTableModel {
    private TdmLoModel[] model;
    public String[] columnNames = new String[]{"", "SF Ber Level", "SD Ber Level"};
    private final TDMTerminology terms;
    private Attribute[] sfBerLevel;
    private Attribute[] sdBerLevel;
    private sInterface[] info;
    private boolean[][] isDirty;
    private int numLines;
    private String sdString = "declareSdBerLevel";
    private String sfString = "declareSfBerLevel";
    private INodeModel node;
    public static final int LINENUMBER_INDEX = 0;
    public static final int SFBERLEVEL_INDEX = 1;
    public static final int SDBERLEVEL_INDEX = 2;
    private static final SDebug db = new SDebug("TdmLoProvTableModel");

    public TdmLoProvTableModel(INodeModel iNodeModel, TdmLoModel[] tdmLoModelArray) {
        this.model = tdmLoModelArray;
        this.node = iNodeModel;
        this.terms = iNodeModel.getTDMTerminology();
        this.columnNames[0] = this.terms.getGeneralTerms(1);
        if (tdmLoModelArray == null) {
            if (db.on()) {
                db.println("Model is null");
            }
            this.numLines = 0;
        } else {
            this.numLines = tdmLoModelArray.length;
            this.sfBerLevel = new Attribute[this.numLines];
            this.sdBerLevel = new Attribute[this.numLines];
            this.info = new sInterface[this.numLines];
            this.isDirty = new boolean[this.numLines][this.getColumnCount()];
            for (int i = 0; i < this.numLines; ++i) {
                this.sfBerLevel[i] = null;
                this.sdBerLevel[i] = null;
            }
            this.resetDirtyBits();
        }
    }

    public int getRowCount() {
        return this.model == null ? 0 : this.model.length;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap((IModel)this.node);
    }

    public Attribute getSdBerLevelIndex(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.sdBerLevel[n] == null) {
            this.sdBerLevel[n] = this.getAttributeMap().getAttributeForVal(this.sdString, this.model[n].getLoSfSdModel().getSdBerLevel());
        }
        return this.sdBerLevel[n];
    }

    public Attribute getSfBerLevelIndex(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.sfBerLevel[n] == null) {
            this.sfBerLevel[n] = this.getAttributeMap().getAttributeForVal(this.sfString, this.model[n].getLoSfSdModel().getSfBerLevel());
        }
        return this.sfBerLevel[n];
    }

    protected sInterface getInfo(int n) throws NoSuchInterface {
        if (this.info[n] == null) {
            this.info[n] = this.model[n].getInfo();
        }
        return this.info[n];
    }

    protected String getLineNumber(int n) throws NoSuchInterface {
        StringBuffer stringBuffer = new StringBuffer();
        this.getInfo(n);
        if (this.info[n] != null) {
            stringBuffer.append("Port ");
            try {
                IPortModel iPortModel = this.model[n].getPortModel();
                stringBuffer.append(PortHelper.getPortNumString((IPortModel)iPortModel) + ", ");
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            stringBuffer.append(this.terms.getGeneralTerms(1) + " ");
            stringBuffer.append(n + 1);
        }
        return stringBuffer.toString();
    }

    public int getNumLines() {
        return this.numLines;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.model.length > 0 && AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING)) {
            return n2 > 0;
        }
        return false;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getLineNumber(n);
                }
                case 1: {
                    return this.getSfBerLevelIndex(n);
                }
                case 2: {
                    return this.getSdBerLevelIndex(n);
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Caught exception in getValueAt");
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        switch (n2) {
            case 1: {
                this.sfBerLevel[n] = (Attribute)object;
                break;
            }
            case 2: {
                this.sdBerLevel[n] = (Attribute)object;
                break;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    private Attribute getAttributeFor(String string, int n) {
        return this.getAttributeMap().getAttributeForVal(string, n);
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.sfBerLevel[i] = null;
            this.sdBerLevel[i] = null;
        }
        this.resetDirtyBits();
        this.fireTableDataChanged();
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.sfBerLevel[n] = null;
        this.sdBerLevel[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
        this.fireTableRowsUpdated(n, n);
    }

    public synchronized void setLoModel(TdmLoModel[] tdmLoModelArray) {
        this.model = tdmLoModelArray;
        this.numLines = tdmLoModelArray == null ? 0 : tdmLoModelArray.length;
        this.sfBerLevel = new Attribute[this.numLines];
        this.sdBerLevel = new Attribute[this.numLines];
        this.info = new sInterface[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.refreshFromModel();
    }
}

