/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TraceMode;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.TdmHoProvPane;
import cerent.cms.ui.sonet.TdmLineProvPane;
import cerent.cms.ui.sonet.TdmLineTableModel;
import cerent.cms.ui.sonet.TdmPhysicalAlarmThresholdProvPane;
import cerent.cms.ui.sonet.TdmThresholdProvPane;
import cerent.cms.ui.sonet.TdmVtIppmProvPane;
import cerent.cms.ui.trace.GenericTraceProvPane;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.awt.Component;

public class TdmProvPane
extends NodeProvPane
implements ITabName {
    protected TdmLineModel[] lineModels;
    private String threshTab = "SONET Thresholds/SDH Thresholds";
    private String hoProvTab = "SONET STS/VC4";
    private int LO_LEVEL = 1;
    private static final SDebug db = new SDebug("TdmProvPane");

    public TdmProvPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray) {
        this(string, tabbedView, tdmLineModelArray, true, false);
    }

    public TdmProvPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray, boolean bl, boolean bl2) {
        super(string, tabbedView);
        this.lineModels = tdmLineModelArray;
        try {
            if (Model.getFramingType(this.getUiModel().getNodeModel()).isSonet()) {
                this.threshTab = "SONET Thresholds";
                this.hoProvTab = "SONET STS";
            } else {
                this.threshTab = "SDH Thresholds";
                this.hoProvTab = "VC4";
            }
        }
        catch (AnnotatedException annotatedException) {
            // empty catch block
        }
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
        this.subTabs.addTab("Line", (Component)this.getLineProvTab());
        if (bl2) {
            this.subTabs.add("Section Trace", (Component)this.getSectionTracePane());
        }
        this.subTabs.addTab(this.threshTab, (Component)this.getThresholdsPane());
        if (this.supportsPhysicalPm()) {
            this.subTabs.addTab("Optics Thresholds", (Component)this.getPhysicalThresholdsPane());
        }
        this.subTabs.addTab(this.hoProvTab, (Component)this.getHOProvTab(this.hoProvTab));
        ModuleModel moduleModel = (ModuleModel)this.getUiModel();
        if (moduleModel.supportsVtIppm()) {
            this.subTabs.addTab("SONET VT", (Component)this.getLOProvTab());
        }
        if (bl) {
            this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
        }
        this.add((Component)this.subTabs);
    }

    protected Pane getThresholdsPane() {
        return new TdmThresholdProvPane(this.threshTab, this.getParentView(), this.lineModels);
    }

    protected Pane getPhysicalThresholdsPane() {
        return new TdmPhysicalAlarmThresholdProvPane(this.threshTab, this.getParentView(), this.lineModels);
    }

    protected Pane getLOProvTab() {
        return new TdmVtIppmProvPane("SONET VT", this.getParentView(), this.lineModels, this.LO_LEVEL);
    }

    protected Pane getHOProvTab(String string) {
        return new TdmHoProvPane(string, this.getParentView(), this.lineModels, 1);
    }

    protected Pane getLineProvTab() {
        return new TdmLineProvPane("Line", this.getParentView(), this.lineModels, new TdmLineTableModel((NodeModelDelegate)this.getUiModel().getNodeModel(), this.lineModels));
    }

    protected Pane getSectionTracePane() {
        return new GenericTraceProvPane("Section Trace", this.getParentView(), TraceMode.SECTION, this.lineModels, 3);
    }

    public boolean hasSubTabs() {
        return true;
    }

    protected boolean supportsPhysicalPm() {
        return ((ModuleModel)this.getUiModel()).supportsPhysicalPm();
    }
}

