/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.SonetMedia.sSectionThresholds;
import cerent.cms.model.FramingType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.TdmSectionPmThresholdsTableModel;
import cerent.util.AnnotatedException;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TdmSectionPmThresholdsPane
extends NodeProvPane
implements TableModelListener {
    protected TdmSectionPmThresholdsTableModel dataModel = null;
    protected TdmLineModel[] lineModels = null;
    TdmModuleModel eqpmtModel = null;
    protected eIntervalType intervalType = null;
    protected boolean nearEnd = false;
    private static final SDebug db = new SDebug("TdmSectionPmThresholdsPane");

    public TdmSectionPmThresholdsPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl) {
        super(string, tabbedView);
        TableColumn tableColumn = null;
        this.lineModels = tdmLineModelArray;
        this.intervalType = eIntervalType2;
        this.nearEnd = bl;
        INodeModel iNodeModel = tabbedView.getUiModel().getNodeModel();
        this.dataModel = this.getTableModel(iNodeModel);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.add((Component)uScrollPane);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[0]);
        tableColumn.setPreferredWidth(150);
        this.prepareColumns();
        this.registerWithModel();
    }

    protected TdmSectionPmThresholdsTableModel getTableModel(INodeModel iNodeModel) {
        TdmSectionPmThresholdsTableModel tdmSectionPmThresholdsTableModel = new TdmSectionPmThresholdsTableModel(iNodeModel, this.lineModels, this.intervalType, this.nearEnd);
        return tdmSectionPmThresholdsTableModel;
    }

    protected void prepareColumns() {
        TableColumn tableColumn = null;
        INodeModel iNodeModel = this.getParentView().getUiModel().getNodeModel();
        int n = iNodeModel.getFramingType();
        if (!FramingType.getFramingType((int)n).isSdh()) {
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
            this.table.removeColumn(tableColumn);
        }
    }

    protected void registerWithModel() {
        super.registerWithModel();
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    protected void unregisterWithModel() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    public void dispose() {
        this.unregisterWithModel();
        super.dispose();
    }

    protected void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                TdmSectionPmThresholdsPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof OcnLineUpdate) {
            this.unregisterWithModel();
            this.lineModels = (TdmLineModel[])((OcnLineUpdate)object).getModels();
            this.registerWithModel();
            this.dataModel.refreshMyLines(this.lineModels);
        }
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In TdmSectionPmThresholdsPane changeMessage cannot find Model " + observable);
        }
    }

    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.lineModels.length; ++n) {
                if (db.on()) {
                    db.println("setting at iteration " + n);
                }
                if (!this.dataModel.isRowDirty(n)) continue;
                this.printThresholds(this.dataModel.getThresholdsVal(n));
                this.lineModels[n].setSectionPmThresholds(this.intervalType, this.nearEnd, this.dataModel.getThresholdsVal(n));
            }
            this.dataModel.resetDirtyBits();
        }
        catch (Exception exception) {
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n;
        if (this.lineModels == null) {
            return;
        }
        int n2 = n = tableModelEvent.getLastRow() > this.lineModels.length - 1 ? this.lineModels.length - 1 : tableModelEvent.getLastRow();
        if (db.on()) {
            db.println("Got a table changed message val = " + n);
        }
        for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    private void printThresholds(sSectionThresholds sSectionThresholds2) {
        if (db.on()) {
            db.println("===============================================");
            db.println("Near End = " + this.nearEnd + " Interval Type = " + EnumStrings.getString((Object)this.intervalType, (int)this.intervalType.value()));
            db.println("CV " + sSectionThresholds2.cv);
            db.println("ES " + sSectionThresholds2.es);
            db.println("SES " + sSectionThresholds2.ses);
            db.println("BBE " + sSectionThresholds2.bbe);
            db.println("SEFS " + sSectionThresholds2.sefs);
            db.println("===============================================");
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.TdmSectionPmThresholdsPane;
    }
}

