/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.SonetMedia.sSectionThresholds;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.FramingType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.sonet.TdmTableModel;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;

public class TdmSectionPmThresholdsTableModel
extends TdmTableModel {
    protected boolean[] rowDirty = null;
    protected sSectionThresholds[] thresholdsVal;
    protected eIntervalType intervalType;
    protected boolean nearEnd;
    protected EntityCellRenderer myPortRenderer;
    public static final int LINENUMBER_INDEX = 0;
    public static final int CV_INDEX = 1;
    public static final int BBE_INDEX = 2;
    public static final int ES_INDEX = 3;
    public static final int SES_INDEX = 4;
    public static final int SEFS_INDEX = 5;
    public static final int SONET_INDEX_LEN = 6;
    public static final int UAS_INDEX = 6;
    public static final int SDH_INDEX_LEN = 7;
    public String[] columnNames;
    private static final SDebug db = new SDebug("TdmSectionPmThresholdsTableModel");

    public TdmSectionPmThresholdsTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl) {
        this(iNodeModel, tdmLineModelArray, eIntervalType2, bl, iNodeModel.getTDMTerminology());
    }

    public TdmSectionPmThresholdsTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl, TDMTerminology tDMTerminology) {
        super(iNodeModel, tDMTerminology);
        this.initColumnNames();
        this.model = tdmLineModelArray;
        this.nearEnd = bl;
        this.intervalType = eIntervalType2;
        this.myPortRenderer = new EntityCellRenderer();
        this.init();
    }

    private void init() {
        this.numLines = this.model.length;
        this.rowDirty = new boolean[this.numLines];
        this.thresholdsVal = new sSectionThresholds[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
            this.thresholdsVal[i] = null;
        }
    }

    private void refreshPmStats(int n) {
        if (this.thresholdsVal[n] == null) {
            try {
                this.thresholdsVal[n] = this.model[n].getSectionPmThresholds(this.intervalType, this.nearEnd);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private int getEs(int n) {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].es;
    }

    private int getCv(int n) {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].cv;
    }

    private int getSes(int n) {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].ses;
    }

    private int getSefs(int n) {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].sefs;
    }

    private int getUas(int n) {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].uas;
    }

    private int getBbe(int n) {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].bbe;
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        return Integer.class;
    }

    public void setValueAt(Object object, int n, int n2) {
        block24: {
            try {
                if (db.on()) {
                    db.println("Change in value " + n + " " + n2);
                }
                int n3 = -1;
                TDMTerminology tDMTerminology = this.getTerms();
                if (object instanceof Integer) {
                    n3 = (Integer)object;
                } else if (object instanceof String) {
                    n3 = Integer.parseInt((String)object);
                }
                if (n3 < 0) {
                    throw new Exception();
                }
                switch (n2) {
                    case 1: {
                        if (this.thresholdsVal[n].cv == n3) {
                            return;
                        }
                        this.validatePmThresholds(0, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(1), object.toString());
                        this.thresholdsVal[n].cv = n3;
                        break;
                    }
                    case 3: {
                        if (this.thresholdsVal[n].es == n3) {
                            return;
                        }
                        this.validatePmThresholds(0, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(2), object.toString());
                        this.thresholdsVal[n].es = n3;
                        break;
                    }
                    case 4: {
                        if (this.thresholdsVal[n].ses == n3) {
                            return;
                        }
                        this.validatePmThresholds(0, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(3), object.toString());
                        this.thresholdsVal[n].ses = n3;
                        break;
                    }
                    case 5: {
                        if (this.thresholdsVal[n].sefs == n3) {
                            return;
                        }
                        String string = "";
                        string = FramingType.getFramingType((int)this.getFramingType()).isSdh() ? tDMTerminology.getPmStat(4) : tDMTerminology.getPmStat(4);
                        this.validatePmThresholds(0, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, string, object.toString());
                        this.thresholdsVal[n].sefs = n3;
                        break;
                    }
                    case 6: {
                        if (this.thresholdsVal[n].uas == n3) {
                            return;
                        }
                        this.validatePmThresholds(0, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(9), object.toString());
                        this.thresholdsVal[n].uas = n3;
                        break;
                    }
                    case 2: {
                        if (this.thresholdsVal[n].bbe == n3) {
                            return;
                        }
                        this.validatePmThresholds(0, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, tDMTerminology.getPmStat(5), object.toString());
                        this.thresholdsVal[n].bbe = n3;
                        break;
                    }
                }
                this.rowDirty[n] = true;
                this.fireTableCellUpdated(n, n2);
            }
            catch (NumberFormatException numberFormatException) {
                if (db.on()) {
                    db.println("NumberFormatException caught in TdmSectionPmThresholdsTableModel::setValueAt() " + numberFormatException);
                    SDebug.printStackTrace((Throwable)numberFormatException);
                }
            }
            catch (ProvisionError provisionError) {
                SDebug.printStackTrace((Throwable)provisionError);
                this.presentProvisionError(this.getColumnName(n2), provisionError);
            }
            catch (Exception exception) {
                if (!db.on()) break block24;
                db.println("Error in setting value " + exception);
            }
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public sSectionThresholds getThresholdsVal(int n) {
        if (n >= this.numLines) {
            return null;
        }
        return this.thresholdsVal[n];
    }

    private void initColumnNames() {
        boolean bl = FramingType.getFramingType((int)this.getFramingType()).isSdh();
        int n = bl ? 7 : 6;
        try {
            TDMTerminology tDMTerminology = this.getTerms();
            this.columnNames = new String[n];
            this.columnNames[0] = "Port ";
            this.columnNames[1] = tDMTerminology.getPmStat(1);
            this.columnNames[2] = tDMTerminology.getPmStat(5);
            this.columnNames[3] = tDMTerminology.getPmStat(2);
            this.columnNames[4] = tDMTerminology.getPmStat(3);
            this.columnNames[5] = tDMTerminology.getPmStat(4);
            if (bl) {
                this.columnNames[6] = tDMTerminology.getPmStat(9);
            }
        }
        catch (Exception exception) {
            db.finer("Exception in initColumnNames() " + exception);
        }
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return new Integer(this.getCv(n));
                }
                case 3: {
                    return new Integer(this.getEs(n));
                }
                case 4: {
                    return new Integer(this.getSes(n));
                }
                case 5: {
                    return new Integer(this.getSefs(n));
                }
                case 6: {
                    return new Integer(this.getUas(n));
                }
                case 2: {
                    return new Integer(this.getBbe(n));
                }
            }
            return null;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in getValueAt " + exception);
            }
            return null;
        }
    }

    public void refreshMyLines(TdmLineModel[] tdmLineModelArray) {
        this.model = tdmLineModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    public void refreshLineFromModel(int n) {
        this.thresholdsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        int n;
        if (db.on()) {
            db.println("refreshing in model");
        }
        for (n = 0; n < this.numLines; ++n) {
            this.thresholdsVal[n] = null;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.rowDirty[n] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }
}

