/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.IPlatform;
import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.IFramingType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.sonet.CxcHoPathPmThresholdsPane;
import cerent.cms.ui.sonet.CxcTdmLinePmThresholdsPane;
import cerent.cms.ui.sonet.CxcTdmSectionPmThresholdsPane;
import cerent.cms.ui.sonet.HoPathPmThresholdsPane;
import cerent.cms.ui.sonet.LoPathPmThresholdsPane;
import cerent.cms.ui.sonet.SonetFEPmThresholdsPane;
import cerent.cms.ui.sonet.TdmLinePmThresholdsPane;
import cerent.cms.ui.sonet.TdmPhysicalPmThresholdsPane;
import cerent.cms.ui.sonet.TdmSectionPmThresholdsPane;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public class TdmThresholdProvPane
extends AbstractPane {
    protected TdmLineModel[] models;
    protected TdmThresholdButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected AbstractPane currentPane = null;
    protected static final String FE_SEC_1DAY_PANEL = "FE_SEC_1DAY";
    protected static final String FE_SEC_15MIN_PANEL = "FE_SEC_15MIN";
    protected static final String NE_SEC_1DAY_PANEL = "NE_SEC_1DAY";
    protected static final String NE_SEC_15MIN_PANEL = "NE_SEC_15MIN";
    protected static final String FE_LIN_1DAY_PANEL = "FE_LIN_1DAY";
    protected static final String FE_LIN_15MIN_PANEL = "FE_LIN_15MIN";
    protected static final String NE_LIN_1DAY_PANEL = "NE_LIN_1DAY";
    protected static final String NE_LIN_15MIN_PANEL = "NE_LIN_15MIN";
    protected static final String FE_PATH_1DAY_PANEL = "FE_PATH_1DAY";
    protected static final String FE_PATH_15MIN_PANEL = "FE_PATH_15MIN";
    protected static final String NE_PATH_1DAY_PANEL = "NE_PATH_1DAY";
    protected static final String NE_PATH_15MIN_PANEL = "NE_PATH_15MIN";
    protected static final String FE_VT_1DAY_PANEL = "FE_VT_1DAY";
    protected static final String FE_VT_15MIN_PANEL = "FE_VT_15MIN";
    protected static final String NE_VT_1DAY_PANEL = "NE_VT_1DAY";
    protected static final String NE_VT_15MIN_PANEL = "NE_VT_15MIN";
    protected static final int VT = 16;
    protected static final int PATH = 8;
    protected static final int FE = 4;
    protected static final int SEC = 2;
    protected static final int ONE_DAY = 1;
    protected static final int FE_VT_1DAY = 21;
    protected static final int FE_VT_15MIN = 20;
    protected static final int NE_VT_1DAY = 17;
    protected static final int NE_VT_15MIN = 16;
    protected static final int FE_PATH_1DAY = 13;
    protected static final int FE_PATH_15MIN = 12;
    protected static final int NE_PATH_1DAY = 9;
    protected static final int NE_PATH_15MIN = 8;
    protected static final int FE_SEC_1DAY = 7;
    protected static final int FE_SEC_15MIN = 6;
    protected static final int NE_SEC_1DAY = 3;
    protected static final int NE_SEC_15MIN = 2;
    protected static final int FE_LIN_1DAY = 5;
    protected static final int FE_LIN_15MIN = 4;
    protected static final int NE_LIN_1DAY = 1;
    protected static final int NE_LIN_15MIN = 0;
    protected JLabel tableLabel = new JLabel();
    protected String tableLabelString = new String();
    private IFramingType fType = null;
    private boolean is600 = false;
    protected IPlatform pci;
    private TDMTerminology terms;
    protected static final SDebug db = new SDebug("TdmThresholdProvPane");

    public TdmThresholdProvPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray) {
        super(string, tabbedView);
        this.models = tdmLineModelArray;
        this.pci = ((NodeModelDelegate)this.uiModel.getNodeModel()).getPlatform();
        this.fType = this.uiModel.getNodeModel().getFramingTypeObj();
        this.terms = this.getUiModel().getNodeModel().getTDMTerminology();
        this.is600 = ((NodeModelDelegate)this.uiModel.getNodeModel()).getPlatform().is600();
        this.initializeLayout();
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
        this.registerWithModel();
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonPanel(), "South");
        this.add(this.getTablePanel(), "Center");
    }

    protected TdmThresholdButtonPanel getButtonPanel() {
        if (null == this.buttonPanel) {
            this.buttonPanel = new TdmThresholdButtonPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.setPreferredSize(new Dimension(800, 300));
        this.currentPane = this.getSonetLinePmThresholdsPane(NE_LIN_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true);
        this.tablePanel.add((Component)((Object)this.currentPane));
        this.tableLabelString = " Near End, 15 Min, " + this.terms.getGeneralTerms(2);
        this.tableLabel.setText(this.tableLabelString);
        jPanel.add((Component)this.tableLabel, "North");
        jPanel.add((Component)this.tablePanel, "Center");
        return jPanel;
    }

    protected AbstractPane getSonetLinePmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        if (this.is15600()) {
            return new CxcTdmLinePmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
        }
        return new TdmLinePmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
    }

    protected AbstractPane getSonetSectionPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        if (this.is15600()) {
            return new CxcTdmSectionPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
        }
        return new TdmSectionPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
    }

    protected AbstractPane getSonetPathPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        if (this.is15600()) {
            return new CxcHoPathPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl, 1);
        }
        return new HoPathPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl, 1);
    }

    protected AbstractPane getSonetPhysicalPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        return new TdmPhysicalPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
    }

    protected LoPathPmThresholdsPane getLoPathPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        return new LoPathPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl, 2);
    }

    protected AbstractPane getSonetFELinePmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        if (this.is15600()) {
            return new CxcTdmLinePmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
        }
        return new SonetFEPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl);
    }

    protected void showPanel(AbstractPane abstractPane) {
        block4: {
            try {
                TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
                this.currentPane.leavingPage();
                this.currentPane.destroy();
                this.tablePanel.remove((Component)((Object)this.currentPane));
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Error in leaving page");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        try {
            abstractPane.enteringPage();
            TablePropertyMgr.getColumnPrefs(abstractPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + abstractPane.getName());
        }
        catch (Exception exception) {
            db.finer("Exception in showPanel() " + exception);
        }
        this.currentPane = abstractPane;
        this.tablePanel.add((Component)((Object)this.currentPane));
        this.validate();
    }

    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof OcnLineUpdate) {
            this.models = (TdmLineModel[])((OcnLineUpdate)object).getModels();
        } else if (object instanceof DwdmLineUpdate) {
            this.models = ((DwdmLineUpdate)object).getTdmLineModels();
        }
    }

    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    public void dispose() {
        this.currentPane.destroy();
        this.buttonPanel = null;
        super.dispose();
    }

    protected boolean is15600() {
        return this.is600;
    }

    protected class TdmThresholdButtonPanel
    extends JPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JRadioButton buttonNE;
        public JRadioButton buttonFE;
        public JRadioButton buttonSection;
        public JRadioButton buttonLine;
        public JRadioButton buttonPath;
        public JRadioButton buttonVt;
        public JButton showButton = new JButton("Refresh");
        public ButtonGroup periodButtonGroup;
        public ButtonGroup endButtonGroup;
        public ButtonGroup secLineButtonGroup;

        public TdmThresholdButtonPanel() {
            this.initialize();
        }

        protected void initButtonListeners() {
            this.buttonNE.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (((JRadioButton)itemEvent.getSource()).isSelected()) {
                        TdmThresholdButtonPanel.this.buttonSection.setEnabled(true);
                        TdmThresholdButtonPanel.this.buttonLine.setEnabled(true);
                        TdmThresholdButtonPanel.this.buttonPath.setEnabled(true);
                        TdmThresholdButtonPanel.this.buttonVt.setEnabled(TdmThresholdButtonPanel.this.supportsVtIppm());
                    }
                }
            });
            this.buttonFE.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (((JRadioButton)itemEvent.getSource()).isSelected()) {
                        TdmThresholdButtonPanel.this.buttonSection.setEnabled(false);
                        TdmThresholdButtonPanel.this.buttonLine.setEnabled(true);
                        TdmThresholdButtonPanel.this.buttonPath.setEnabled(TdmThresholdButtonPanel.this.supportsFePathPm());
                        TdmThresholdButtonPanel.this.buttonVt.setEnabled(TdmThresholdButtonPanel.this.supportsVtIppm());
                        if (TdmThresholdButtonPanel.this.buttonSection.isSelected() || TdmThresholdButtonPanel.this.buttonPath.isSelected() && !TdmThresholdButtonPanel.this.buttonPath.isEnabled() || TdmThresholdButtonPanel.this.buttonVt.isSelected() && !TdmThresholdButtonPanel.this.buttonVt.isEnabled()) {
                            TdmThresholdButtonPanel.this.buttonLine.setSelected(true);
                        }
                    }
                }
            });
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.buttonNE = new JRadioButton("Near End", true);
            this.buttonFE = new JRadioButton("Far End");
            this.buttonLine = new JRadioButton(TdmThresholdProvPane.this.terms.getGeneralTerms(2), true);
            this.buttonSection = new JRadioButton(TdmThresholdProvPane.this.terms.getGeneralTerms(3));
            this.buttonPath = new JRadioButton(TdmThresholdProvPane.this.terms.getGeneralTerms(0));
            this.buttonVt = new JRadioButton(TdmThresholdProvPane.this.terms.getGeneralTerms(1));
            this.buttonVt.setEnabled(this.supportsVtIppm());
            this.secLineButtonGroup = new ButtonGroup();
            this.secLineButtonGroup.add(this.buttonSection);
            this.secLineButtonGroup.add(this.buttonLine);
            this.secLineButtonGroup.add(this.buttonPath);
            this.secLineButtonGroup.add(this.buttonVt);
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.endButtonGroup = new ButtonGroup();
            this.endButtonGroup.add(this.buttonNE);
            this.endButtonGroup.add(this.buttonFE);
            this.showButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TdmThresholdButtonPanel.this.refreshAction();
                }
            });
            this.initButtonListeners();
            Dimension dimension = new Dimension(90, 70);
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder(" Directions "));
            jPanel.setPreferredSize(dimension);
            jPanel.add(this.buttonNE);
            jPanel.add(this.buttonFE);
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel2.setBorder(BorderFactory.createTitledBorder(" Intervals "));
            jPanel2.setPreferredSize(new Dimension(dimension.width - 10, dimension.height));
            jPanel2.add((Component)this.button15Min, "North");
            jPanel2.add((Component)this.button1Day, "South");
            JPanel jPanel3 = new JPanel(new GridLayout(2, 2, 0, 0));
            jPanel3.setBorder(BorderFactory.createTitledBorder(" Types "));
            if (TdmThresholdProvPane.this.fType.isSonet()) {
                jPanel3.setPreferredSize(new Dimension(dimension.width + 70, dimension.height));
            } else {
                jPanel3.setPreferredSize(new Dimension(dimension.width * 4, dimension.height));
            }
            jPanel3.add(this.buttonLine);
            jPanel3.add(this.buttonPath);
            jPanel3.add(this.buttonSection);
            jPanel3.add(this.buttonVt);
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(jPanel2);
            this.add(jPanel3);
            this.add(this.showButton);
            this.setPreferredSize(new Dimension(800, 75));
        }

        public void refreshAction() {
            TdmThresholdProvPane.this.tableLabelString = " ";
            int n = 0;
            if (this.endButtonGroup.getSelection() == this.buttonFE.getModel()) {
                if (db.on()) {
                    db.println("FE");
                }
                n |= 4;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + "Far End";
            } else {
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + "Near End";
            }
            if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                if (db.on()) {
                    db.println("1 Day");
                }
                n |= 1;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", 1 Day";
            } else {
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", 15 Min";
            }
            if (this.secLineButtonGroup.getSelection() == this.buttonSection.getModel()) {
                if (db.on()) {
                    db.println("Section pressed");
                }
                n |= 2;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", " + TdmThresholdProvPane.this.terms.getGeneralTerms(3);
            } else if (this.secLineButtonGroup.getSelection() == this.buttonPath.getModel()) {
                if (db.on()) {
                    db.println("STS pressed");
                }
                n |= 8;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", STS";
            } else if (this.secLineButtonGroup.getSelection() == this.buttonLine.getModel()) {
                if (db.on()) {
                    db.println("Line pressed");
                }
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", " + TdmThresholdProvPane.this.terms.getGeneralTerms(2);
            } else if (this.secLineButtonGroup.getSelection() == this.buttonVt.getModel()) {
                if (db.on()) {
                    db.println("VT pressed");
                }
                n |= 0x10;
                TdmThresholdProvPane.this.tableLabelString = TdmThresholdProvPane.this.tableLabelString + ", VT";
            }
            switch (n) {
                case 7: {
                    if (db.on()) {
                        db.println("FE SEC 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetSectionPmThresholdsPane(TdmThresholdProvPane.FE_SEC_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false));
                    break;
                }
                case 6: {
                    if (db.on()) {
                        db.println("FE SEC 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetSectionPmThresholdsPane(TdmThresholdProvPane.FE_SEC_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false));
                    break;
                }
                case 3: {
                    if (db.on()) {
                        db.println("NE SEC 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetSectionPmThresholdsPane(TdmThresholdProvPane.NE_SEC_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true));
                    break;
                }
                case 2: {
                    if (db.on()) {
                        db.println("NE SEC 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetSectionPmThresholdsPane(TdmThresholdProvPane.NE_SEC_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true));
                    break;
                }
                case 5: {
                    if (db.on()) {
                        db.println("FE LIN 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetFELinePmThresholdsPane(TdmThresholdProvPane.FE_LIN_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false));
                    break;
                }
                case 4: {
                    if (db.on()) {
                        db.println("FE LIN 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetFELinePmThresholdsPane(TdmThresholdProvPane.FE_LIN_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false));
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("NE LIN 1 Day");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetLinePmThresholdsPane(TdmThresholdProvPane.NE_LIN_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true));
                    break;
                }
                case 0: {
                    if (db.on()) {
                        db.println("NE LIN 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetLinePmThresholdsPane(TdmThresholdProvPane.NE_LIN_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true));
                    break;
                }
                case 13: {
                    if (db.on()) {
                        db.println("FE PATH 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetPathPmThresholdsPane(TdmThresholdProvPane.FE_PATH_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false));
                    break;
                }
                case 12: {
                    if (db.on()) {
                        db.println("FE PATH 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetPathPmThresholdsPane(TdmThresholdProvPane.FE_PATH_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false));
                    break;
                }
                case 9: {
                    if (db.on()) {
                        db.println("NE PATH 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetPathPmThresholdsPane(TdmThresholdProvPane.NE_PATH_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true));
                    break;
                }
                case 8: {
                    if (db.on()) {
                        db.println("NE PATH 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getSonetPathPmThresholdsPane(TdmThresholdProvPane.NE_PATH_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true));
                    break;
                }
                case 21: {
                    if (db.on()) {
                        db.println("FE VT 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getLoPathPmThresholdsPane(TdmThresholdProvPane.FE_VT_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false));
                    break;
                }
                case 20: {
                    if (db.on()) {
                        db.println("FE VT 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getLoPathPmThresholdsPane(TdmThresholdProvPane.FE_VT_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false));
                    break;
                }
                case 17: {
                    if (db.on()) {
                        db.println("NE VT 1DAY");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getLoPathPmThresholdsPane(TdmThresholdProvPane.NE_VT_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true));
                    break;
                }
                case 16: {
                    if (db.on()) {
                        db.println("NE VT 15MIN");
                    }
                    TdmThresholdProvPane.this.showPanel(TdmThresholdProvPane.this.getLoPathPmThresholdsPane(TdmThresholdProvPane.NE_VT_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true));
                    break;
                }
            }
            TdmThresholdProvPane.this.tableLabel.setText(TdmThresholdProvPane.this.tableLabelString);
        }

        protected ModuleModel getEntityModel() {
            return (ModuleModel)TdmThresholdProvPane.this.uiModel;
        }

        protected boolean supportsVtIppm() {
            return this.getEntityModel().supportsVtIppm();
        }

        protected boolean supportsFePathPm() {
            return TdmThresholdProvPane.this.is15600() ? true : this.getEntityModel().supportsFarEndPathPm();
        }
    }
}

